/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public class ExceptionWrappingMetadataReader
implements MetadataReader {
    private final OrcDataSourceId orcDataSourceId;
    private final MetadataReader delegate;

    public ExceptionWrappingMetadataReader(OrcDataSourceId orcDataSourceId, MetadataReader delegate) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Preconditions.checkArgument((!(delegate instanceof ExceptionWrappingMetadataReader) ? 1 : 0) != 0, (Object)"ExceptionWrappingMetadataReader can not wrap a ExceptionWrappingMetadataReader");
    }

    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws OrcCorruptionException {
        try {
            return this.delegate.readPostScript(data, offset, length);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid postscript");
        }
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readMetadata(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid file metadata");
        }
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readFooter(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid file footer");
        }
    }

    @Override
    public StripeFooter readStripeFooter(List<OrcType> types, InputStream inputStream) throws IOException {
        try {
            return this.delegate.readStripeFooter(types, inputStream);
        }
        catch (IOException e) {
            throw this.propagate(e, "Invalid stripe footer");
        }
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readRowIndexes(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid stripe row index");
        }
    }

    @Override
    public List<HiveBloomFilter> readBloomFilterIndexes(InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readBloomFilterIndexes(inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid bloom filter");
        }
    }

    private OrcCorruptionException propagate(Throwable throwable, String message) {
        return new OrcCorruptionException(throwable, this.orcDataSourceId, message, new Object[0]);
    }
}

