/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.LazyBlockLoader;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.orc.AbstractOrcRecordReader;
import com.facebook.presto.orc.FilterFunction;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.reader.StreamReader;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class OrcSelectiveRecordReader
extends AbstractOrcRecordReader<SelectiveStreamReader> {
    private static final byte[] NULL_MARKER = new byte[0];
    private static final Page EMPTY_PAGE = new Page(0, new Block[0]);
    private final int[] hiveColumnIndices;
    private final List<Integer> outputColumns;
    private final Map<Integer, Type> columnTypes;
    private final Object[] constantValues;
    private final Function<Block, Block>[] coercers;
    private final Optional<FilterFunction> filterFunctionWithoutInput;
    private final Map<Integer, Integer> filterFunctionInputMapping;
    private final Map<Integer, Integer> columnsWithFilterScores;
    private int[] streamReaderOrder;
    private List<FilterFunctionWithStats>[] filterFunctionsOrder;
    private Set<Integer>[] filterFunctionInputs;
    private boolean reorderFilters;
    private int[] reorderableColumns;
    private List<FilterFunctionWithStats> filterFunctionsWithConstantInputs;
    private Set<Integer> filterFunctionConstantInputs;
    private int[] positions;
    private int[] outputPositions;
    private RuntimeException[] errors;
    private RuntimeException[] tmpErrors;
    private boolean constantFilterIsFalse;
    @Nullable
    private RuntimeException constantFilterError;
    private int readPositions;

    public OrcSelectiveRecordReader(Map<Integer, Type> includedColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields, Map<Integer, Object> constantValues, Map<Integer, Function<Block, Block>> coercers, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, List<ColumnStatistics> fileStats, List<StripeStatistics> stripeStats, OrcDataSource orcDataSource, long offset, long length, List<OrcType> types, Optional<OrcDecompressor> decompressor, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, boolean legacyMapSubscript, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Map<String, Slice> userMetadata, OrcAggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, StripeMetadataSource stripeMetadataSource, boolean cacheable) {
        super(includedColumns, requiredSubfields, (StreamReader[])OrcSelectiveRecordReader.createStreamReaders(orcDataSource, types, hiveStorageTimeZone, legacyMapSubscript, includedColumns, outputColumns, filters, filterFunctions, filterFunctionInputMapping, requiredSubfields, systemMemoryUsage.newOrcAggregatedMemoryContext()), predicate, numberOfRows, fileStripes, fileStats, stripeStats, orcDataSource, offset, length, types, decompressor, rowsInRowGroup, hiveStorageTimeZone, hiveWriterVersion, metadataReader, maxMergeDistance, tinyStripeThreshold, maxBlockSize, userMetadata, systemMemoryUsage, writeValidation, initialBatchSize, stripeMetadataSource, cacheable);
        ImmutableList hiveColumnIndices = ImmutableList.copyOf(includedColumns.keySet());
        Map zeroBasedIndices = (Map)IntStream.range(0, hiveColumnIndices.size()).boxed().collect(ImmutableMap.toImmutableMap(((List)hiveColumnIndices)::get, Function.identity()));
        this.hiveColumnIndices = hiveColumnIndices.stream().mapToInt(i -> i).toArray();
        this.outputColumns = (List)outputColumns.stream().map(zeroBasedIndices::get).collect(ImmutableList.toImmutableList());
        this.columnTypes = (Map)includedColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (Integer)zeroBasedIndices.get(entry.getKey()), Map.Entry::getValue));
        this.filterFunctionWithoutInput = OrcSelectiveRecordReader.getFilterFunctionWithoutInputs(filterFunctions);
        Set usedInputChannels = (Set)filterFunctions.stream().flatMapToInt(function -> Arrays.stream(function.getInputChannels())).boxed().collect(ImmutableSet.toImmutableSet());
        this.filterFunctionInputMapping = Maps.transformValues((Map)Maps.filterKeys(filterFunctionInputMapping, usedInputChannels::contains), zeroBasedIndices::get);
        this.columnsWithFilterScores = (Map)filters.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (Integer)zeroBasedIndices.get(entry.getKey()), entry -> OrcSelectiveRecordReader.scoreFilter((Map)entry.getValue())));
        Objects.requireNonNull(coercers, "coercers is null");
        this.coercers = new Function[this.hiveColumnIndices.length];
        for (Map.Entry<Integer, Function<Block, Block>> entry2 : coercers.entrySet()) {
            this.coercers[((Integer)zeroBasedIndices.get((Object)entry2.getKey())).intValue()] = entry2.getValue();
        }
        Objects.requireNonNull(constantValues, "constantValues is null");
        this.constantValues = new Object[this.hiveColumnIndices.length];
        Iterator<Object> iterator = includedColumns.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (this.isColumnPresent(n)) continue;
            if (n >= 0 && OrcSelectiveRecordReader.containsNonNullFilter(filters.get(n))) {
                this.constantFilterIsFalse = true;
                return;
            }
            this.constantValues[((Integer)zeroBasedIndices.get((Object)Integer.valueOf((int)n))).intValue()] = NULL_MARKER;
        }
        for (Map.Entry entry3 : constantValues.entrySet()) {
            if (entry3.getValue() == null) continue;
            this.constantValues[((Integer)zeroBasedIndices.get(entry3.getKey())).intValue()] = entry3.getValue();
        }
        if (!this.evaluateDeterministicFilterFunctionsWithConstantInputs(filterFunctions)) {
            this.constantFilterIsFalse = true;
            return;
        }
        this.streamReaderOrder = OrcSelectiveRecordReader.orderStreamReaders((Collection)this.columnTypes.keySet().stream().filter(index -> this.constantValues[index] == null).collect(ImmutableSet.toImmutableSet()), this.columnsWithFilterScores, this.filterFunctionInputMapping.keySet(), this.columnTypes);
        List filterFunctionsWithInputs = (List)filterFunctions.stream().filter(OrcSelectiveRecordReader::hasInputs).filter((Predicate<FilterFunction>)Predicates.not(this::allConstantInputs)).collect(ImmutableList.toImmutableList());
        List list = (List)filterFunctionsWithInputs.stream().map(function -> new FilterFunctionWithStats((FilterFunction)function, new FilterStats())).collect(ImmutableList.toImmutableList());
        this.filterFunctionsOrder = OrcSelectiveRecordReader.orderFilterFunctionsWithInputs(this.streamReaderOrder, list, this.filterFunctionInputMapping);
        this.filterFunctionInputs = OrcSelectiveRecordReader.collectFilterFunctionInputs(this.filterFunctionsOrder, this.filterFunctionInputMapping);
        this.reorderableColumns = Arrays.stream(this.streamReaderOrder).filter(columnIndex -> !this.columnsWithFilterScores.containsKey(columnIndex)).filter(this.filterFunctionInputMapping::containsKey).toArray();
        this.reorderFilters = list.size() > 1 && this.reorderableColumns.length > 1;
        this.filterFunctionsWithConstantInputs = (List)filterFunctions.stream().filter(Predicates.not(FilterFunction::isDeterministic)).filter(OrcSelectiveRecordReader::hasInputs).filter(this::allConstantInputs).map(function -> new FilterFunctionWithStats((FilterFunction)function, new FilterStats())).collect(ImmutableList.toImmutableList());
        this.filterFunctionConstantInputs = (Set)this.filterFunctionsWithConstantInputs.stream().flatMapToInt(function -> Arrays.stream(function.getFunction().getInputChannels())).boxed().map(this.filterFunctionInputMapping::get).collect(ImmutableSet.toImmutableSet());
    }

    private boolean evaluateDeterministicFilterFunctionsWithConstantInputs(List<FilterFunction> filterFunctions) {
        for (FilterFunction function : filterFunctions) {
            if (!function.isDeterministic() || !OrcSelectiveRecordReader.hasInputs(function) || !this.allConstantInputs(function) || this.evaluateDeterministicFilterFunctionWithConstantInputs(function)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateDeterministicFilterFunctionWithConstantInputs(FilterFunction function) {
        int[] inputs = function.getInputChannels();
        Block[] blocks = new Block[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            Object constantValue;
            int columnIndex;
            blocks[i] = RunLengthEncodedBlock.create((Type)this.columnTypes.get(columnIndex), (Object)((constantValue = this.constantValues[columnIndex = this.filterFunctionInputMapping.get(inputs[i]).intValue()]) == NULL_MARKER ? null : constantValue), (int)1);
        }
        this.initializeTmpErrors(1);
        int positionCount = function.filter(new Page(blocks), new int[]{0}, 1, this.tmpErrors);
        if (this.tmpErrors[0] != null) {
            this.constantFilterError = this.tmpErrors[0];
        }
        return positionCount == 1;
    }

    private static boolean hasInputs(FilterFunction function) {
        return function.getInputChannels().length > 0;
    }

    private boolean allConstantInputs(FilterFunction function) {
        return Arrays.stream(function.getInputChannels()).map(this.filterFunctionInputMapping::get).allMatch(columnIndex -> this.constantValues[columnIndex] != null);
    }

    private void reorderFiltersIfNeeded() {
        List filters = (List)Arrays.stream(this.filterFunctionsOrder).filter(Objects::nonNull).flatMap(functions -> functions.stream()).sorted(Comparator.comparingDouble(function -> function.getStats().getElapsedNanonsPerDroppedPosition())).collect(ImmutableList.toImmutableList());
        assert (filters.size() > 1);
        HashMap columnScore = new HashMap();
        for (int i = 0; i < filters.size(); ++i) {
            int score = i;
            Arrays.stream(((FilterFunctionWithStats)filters.get(i)).getFunction().getInputChannels()).map(this.filterFunctionInputMapping::get).filter(columnIndex -> !this.columnsWithFilterScores.containsKey(columnIndex)).filter(columnIndex -> this.constantValues[columnIndex] == null).forEach(columnIndex -> columnScore.compute(columnIndex, (k, v) -> v == null ? score : Math.min(score, v)));
        }
        int[] newColumnOrder = columnScore.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).mapToInt(Map.Entry::getKey).toArray();
        boolean sameOrder = true;
        for (int i = 0; i < this.streamReaderOrder.length; ++i) {
            if (this.columnsWithFilterScores.containsKey(this.streamReaderOrder[i])) continue;
            for (int j = 0; j < newColumnOrder.length; ++j) {
                if (this.streamReaderOrder[i] != newColumnOrder[j]) {
                    sameOrder = false;
                }
                this.streamReaderOrder[i++] = newColumnOrder[j];
            }
            break;
        }
        if (!sameOrder) {
            this.filterFunctionsOrder = OrcSelectiveRecordReader.orderFilterFunctionsWithInputs(this.streamReaderOrder, filters, this.filterFunctionInputMapping);
            this.filterFunctionInputs = OrcSelectiveRecordReader.collectFilterFunctionInputs(this.filterFunctionsOrder, this.filterFunctionInputMapping);
        }
    }

    private static List<FilterFunctionWithStats>[] orderFilterFunctionsWithInputs(int[] streamReaderOrder, List<FilterFunctionWithStats> filterFunctions, Map<Integer, Integer> inputMapping) {
        List[] order = new List[streamReaderOrder.length];
        for (FilterFunctionWithStats function : filterFunctions) {
            int[] inputs = function.getFunction().getInputChannels();
            int lastIndex = -1;
            for (int input : inputs) {
                int columnIndex = inputMapping.get(input);
                lastIndex = Math.max(lastIndex, Ints.indexOf((int[])streamReaderOrder, (int)columnIndex));
            }
            Verify.verify((lastIndex >= 0 ? 1 : 0) != 0);
            if (order[lastIndex] == null) {
                order[lastIndex] = new ArrayList();
            }
            order[lastIndex].add(function);
        }
        return order;
    }

    private static Set<Integer>[] collectFilterFunctionInputs(List<FilterFunctionWithStats>[] functionsOrder, Map<Integer, Integer> inputMapping) {
        Set[] inputs = new Set[functionsOrder.length];
        for (int i = 0; i < functionsOrder.length; ++i) {
            List<FilterFunctionWithStats> functions = functionsOrder[i];
            if (functions == null) continue;
            inputs[i] = (Set)functions.stream().flatMapToInt(function -> Arrays.stream(function.getFunction().getInputChannels())).boxed().map(inputMapping::get).collect(ImmutableSet.toImmutableSet());
        }
        return inputs;
    }

    private static Optional<FilterFunction> getFilterFunctionWithoutInputs(List<FilterFunction> filterFunctions) {
        List functions = (List)filterFunctions.stream().filter(Predicates.not(OrcSelectiveRecordReader::hasInputs)).collect(ImmutableList.toImmutableList());
        if (functions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Iterables.getOnlyElement((Iterable)functions));
    }

    private static boolean containsNonNullFilter(Map<Subfield, TupleDomainFilter> columnFilters) {
        return columnFilters != null && !columnFilters.values().stream().allMatch(TupleDomainFilter::testNull);
    }

    private static int scoreFilter(Map<Subfield, TupleDomainFilter> filters) {
        Preconditions.checkArgument((!filters.isEmpty() ? 1 : 0) != 0);
        if (filters.size() > 1) {
            return 1000;
        }
        Map.Entry filterEntry = (Map.Entry)Iterables.getOnlyElement(filters.entrySet());
        if (!((Subfield)filterEntry.getKey()).getPath().isEmpty()) {
            return 1000;
        }
        TupleDomainFilter filter = (TupleDomainFilter)filterEntry.getValue();
        if (filter instanceof TupleDomainFilter.BigintRange) {
            if (((TupleDomainFilter.BigintRange)filter).isSingleValue()) {
                return 10;
            }
            return 50;
        }
        if (filter instanceof TupleDomainFilter.BigintValuesUsingHashTable || filter instanceof TupleDomainFilter.BigintValuesUsingBitmask || filter instanceof TupleDomainFilter.BigintMultiRange) {
            return 50;
        }
        return 100;
    }

    private static int scoreType(Type type) {
        if (type == BooleanType.BOOLEAN) {
            return 10;
        }
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT || type == TimestampType.TIMESTAMP || type == DateType.DATE) {
            return 20;
        }
        if (type == RealType.REAL || type == DoubleType.DOUBLE) {
            return 30;
        }
        if (type instanceof DecimalType) {
            return 40;
        }
        if (Varchars.isVarcharType((Type)type) || type instanceof CharType) {
            return 50;
        }
        return 100;
    }

    private static int[] orderStreamReaders(Collection<Integer> columnIndices, Map<Integer, Integer> columnToScore, Set<Integer> filterFunctionInputs, Map<Integer, Type> columnTypes) {
        int columnIndex2;
        List sortedColumnsByFilterScore = (List)columnToScore.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        int[] order = new int[columnIndices.size()];
        int i = 0;
        Iterator iterator = sortedColumnsByFilterScore.iterator();
        while (iterator.hasNext()) {
            int columnIndex3 = (Integer)iterator.next();
            if (!columnIndices.contains(columnIndex3)) continue;
            order[i++] = columnIndex3;
        }
        List sortedFilterFunctionInputs = (List)((ImmutableMap)filterFunctionInputs.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), columnIndex -> OrcSelectiveRecordReader.scoreType((Type)columnTypes.get(columnIndex))))).entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        Iterator<Object> iterator2 = sortedFilterFunctionInputs.iterator();
        while (iterator2.hasNext()) {
            columnIndex2 = (Integer)iterator2.next();
            if (!columnIndices.contains(columnIndex2) || sortedColumnsByFilterScore.contains(columnIndex2)) continue;
            order[i++] = columnIndex2;
        }
        iterator2 = columnIndices.iterator();
        while (iterator2.hasNext()) {
            columnIndex2 = (Integer)iterator2.next();
            if (sortedColumnsByFilterScore.contains(columnIndex2) || filterFunctionInputs.contains(columnIndex2)) continue;
            order[i++] = columnIndex2;
        }
        return order;
    }

    private static SelectiveStreamReader[] createStreamReaders(OrcDataSource orcDataSource, List<OrcType> types, DateTimeZone hiveStorageTimeZone, boolean legacyMapSubscript, Map<Integer, Type> includedColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields, OrcAggregatedMemoryContext systemMemoryContext) {
        List<StreamDescriptor> streamDescriptors = OrcSelectiveRecordReader.createStreamDescriptor("", "", 0, types, orcDataSource).getNestedStreams();
        Objects.requireNonNull(filterFunctions, "filterFunctions is null");
        Objects.requireNonNull(filterFunctionInputMapping, "filterFunctionInputMapping is null");
        Set filterFunctionInputColumns = (Set)filterFunctions.stream().flatMapToInt(function -> Arrays.stream(function.getInputChannels())).boxed().map(filterFunctionInputMapping::get).collect(ImmutableSet.toImmutableSet());
        OrcType rowType = types.get(0);
        SelectiveStreamReader[] streamReaders = new SelectiveStreamReader[rowType.getFieldCount()];
        for (int columnId = 0; columnId < rowType.getFieldCount(); ++columnId) {
            if (!includedColumns.containsKey(columnId)) continue;
            StreamDescriptor streamDescriptor = streamDescriptors.get(columnId);
            boolean outputRequired = outputColumns.contains(columnId) || filterFunctionInputColumns.contains(columnId);
            streamReaders[columnId] = SelectiveStreamReaders.createStreamReader(streamDescriptor, Optional.ofNullable(filters.get(columnId)).orElse((Map<Subfield, TupleDomainFilter>)ImmutableMap.of()), outputRequired ? Optional.of(includedColumns.get(columnId)) : Optional.empty(), Optional.ofNullable(requiredSubfields.get(columnId)).orElse((List<Subfield>)ImmutableList.of()), hiveStorageTimeZone, legacyMapSubscript, systemMemoryContext);
        }
        return streamReaders;
    }

    public int getReadPositions() {
        return this.readPositions;
    }

    public Page getNextPage() throws IOException {
        SelectiveStreamReader streamReader;
        int columnIndex;
        int i;
        if (this.constantFilterIsFalse) {
            return null;
        }
        int batchSize = this.prepareNextBatch();
        if (batchSize < 0) {
            return null;
        }
        this.readPositions += batchSize;
        this.initializePositions(batchSize);
        int[] positionsToRead = this.positions;
        int positionCount = batchSize;
        if (this.filterFunctionWithoutInput.isPresent()) {
            if ((positionCount = this.applyFilterFunctionWithNoInputs(positionCount)) == 0) {
                this.batchRead(batchSize);
                return EMPTY_PAGE;
            }
            positionsToRead = this.outputPositions;
        }
        if (!this.filterFunctionsWithConstantInputs.isEmpty()) {
            if ((positionCount = this.applyFilterFunctions(this.filterFunctionsWithConstantInputs, this.filterFunctionConstantInputs, positionsToRead, positionCount)) == 0) {
                this.batchRead(batchSize);
                return EMPTY_PAGE;
            }
            positionsToRead = this.outputPositions;
        }
        int offset = this.getNextRowInGroup();
        if (this.reorderFilters && offset >= 1024) {
            this.reorderFiltersIfNeeded();
        }
        for (i = 0; i < this.streamReaderOrder.length && this.hasAnyFilter(columnIndex = this.streamReaderOrder[i]) && (positionCount = (streamReader = this.getStreamReader(columnIndex)).read(offset, positionsToRead, positionCount)) != 0; ++i) {
            positionsToRead = streamReader.getReadPositions();
            Verify.verify((positionCount == 1 || positionsToRead[positionCount - 1] - positionsToRead[0] >= positionCount - 1 ? 1 : 0) != 0, (String)"positions must monotonically increase", (Object[])new Object[0]);
            if (this.filterFunctionsOrder[i] == null) continue;
            if ((positionCount = this.applyFilterFunctions(this.filterFunctionsOrder[i], this.filterFunctionInputs[i], positionsToRead, positionCount)) == 0) break;
            positionsToRead = this.outputPositions;
        }
        this.batchRead(batchSize);
        if (positionCount == 0) {
            return EMPTY_PAGE;
        }
        if (this.constantFilterError != null) {
            throw this.constantFilterError;
        }
        for (i = 0; i < positionCount; ++i) {
            if (this.errors[positionsToRead[i]] == null) continue;
            throw this.errors[positionsToRead[i]];
        }
        for (SelectiveStreamReader reader : (SelectiveStreamReader[])this.getStreamReaders()) {
            if (reader == null) continue;
            reader.throwAnyError(positionsToRead, positionCount);
        }
        Block[] blocks = new Block[this.outputColumns.size()];
        for (int i2 = 0; i2 < this.outputColumns.size(); ++i2) {
            int columnIndex2 = this.outputColumns.get(i2);
            if (this.constantValues[columnIndex2] != null) {
                blocks[i2] = RunLengthEncodedBlock.create((Type)this.columnTypes.get(columnIndex2), this.constantValues[columnIndex2] == NULL_MARKER ? null : this.constantValues[columnIndex2], (int)positionCount);
                continue;
            }
            if (!this.hasAnyFilter(columnIndex2)) {
                blocks[i2] = new LazyBlock(positionCount, (LazyBlockLoader)new OrcBlockLoader(this.getStreamReader(columnIndex2), this.coercers[columnIndex2], offset, positionsToRead, positionCount));
                continue;
            }
            Block block = this.getStreamReader(columnIndex2).getBlock(positionsToRead, positionCount);
            this.updateMaxCombinedBytesPerRow(columnIndex2, block);
            if (this.coercers[columnIndex2] != null) {
                block = this.coercers[columnIndex2].apply(block);
            }
            blocks[i2] = block;
        }
        Page page = new Page(positionCount, blocks);
        this.validateWritePageChecksum(page);
        return page;
    }

    private SelectiveStreamReader getStreamReader(int columnIndex) {
        return ((SelectiveStreamReader[])this.getStreamReaders())[this.hiveColumnIndices[columnIndex]];
    }

    private boolean hasAnyFilter(int columnIndex) {
        return this.columnsWithFilterScores.containsKey(columnIndex) || this.filterFunctionInputMapping.containsKey(columnIndex);
    }

    private void initializePositions(int batchSize) {
        if (this.positions == null || this.positions.length < batchSize) {
            this.positions = new int[batchSize];
            for (int i = 0; i < batchSize; ++i) {
                this.positions[i] = i;
            }
        }
        if (this.errors == null || this.errors.length < batchSize) {
            this.errors = new RuntimeException[batchSize];
        } else {
            Arrays.fill(this.errors, null);
        }
    }

    private int applyFilterFunctionWithNoInputs(int positionCount) {
        this.initializeOutputPositions(positionCount);
        Page page = new Page(positionCount, new Block[0]);
        return this.filterFunctionWithoutInput.get().filter(page, this.outputPositions, positionCount, this.errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int applyFilterFunctions(List<FilterFunctionWithStats> filterFunctions, Set<Integer> filterFunctionInputs, int[] positions, int positionCount) {
        int i;
        BlockLease[] blockLeases = new BlockLease[this.hiveColumnIndices.length];
        Block[] blocks = new Block[this.hiveColumnIndices.length];
        for (int columnIndex : filterFunctionInputs) {
            if (this.constantValues[columnIndex] != null) {
                blocks[columnIndex] = RunLengthEncodedBlock.create((Type)this.columnTypes.get(columnIndex), this.constantValues[columnIndex] == NULL_MARKER ? null : this.constantValues[columnIndex], (int)positionCount);
                continue;
            }
            blockLeases[columnIndex] = this.getStreamReader(columnIndex).getBlockView(positions, positionCount);
            Block block = (Block)blockLeases[columnIndex].get();
            if (this.coercers[columnIndex] != null) {
                block = this.coercers[columnIndex].apply(block);
            }
            blocks[columnIndex] = block;
        }
        this.initializeTmpErrors(positionCount);
        for (i = 0; i < positionCount; ++i) {
            this.tmpErrors[i] = this.errors[positions[i]];
        }
        Arrays.fill(this.errors, null);
        try {
            this.initializeOutputPositions(positionCount);
            for (i = 0; i < filterFunctions.size(); ++i) {
                FilterFunctionWithStats functionWithStats = filterFunctions.get(i);
                FilterFunction function = functionWithStats.getFunction();
                int[] inputs = function.getInputChannels();
                Block[] inputBlocks = new Block[inputs.length];
                for (int j = 0; j < inputs.length; ++j) {
                    inputBlocks[j] = blocks[this.filterFunctionInputMapping.get(inputs[j])];
                }
                Page page = new Page(positionCount, inputBlocks);
                long startTime = System.nanoTime();
                int inputPositionCount = positionCount;
                positionCount = function.filter(page, this.outputPositions, positionCount, this.tmpErrors);
                functionWithStats.getStats().update(inputPositionCount, positionCount, System.nanoTime() - startTime);
                if (positionCount == 0) break;
            }
            for (i = 0; i < positionCount; ++i) {
                this.outputPositions[i] = positions[this.outputPositions[i]];
                this.errors[this.outputPositions[i]] = this.tmpErrors[i];
            }
            int n = positionCount;
            return n;
        }
        finally {
            for (BlockLease blockLease : blockLeases) {
                if (blockLease == null) continue;
                blockLease.close();
            }
        }
    }

    private void initializeTmpErrors(int positionCount) {
        if (this.tmpErrors == null || this.tmpErrors.length < positionCount) {
            this.tmpErrors = new RuntimeException[positionCount];
        } else {
            Arrays.fill(this.tmpErrors, null);
        }
    }

    private void initializeOutputPositions(int positionCount) {
        if (this.outputPositions == null || this.outputPositions.length < positionCount) {
            this.outputPositions = new int[positionCount];
        }
        for (int i = 0; i < positionCount; ++i) {
            this.outputPositions[i] = i;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private static final class FilterStats {
        private long inputPositions;
        private long outputPositions;
        private long elapsedNanos;

        private FilterStats() {
        }

        public void update(int inputPositions, int outputPositions, long elapsedNanos) {
            this.inputPositions += (long)inputPositions;
            this.outputPositions += (long)outputPositions;
            this.elapsedNanos += elapsedNanos;
        }

        public double getElapsedNanonsPerDroppedPosition() {
            return (double)this.elapsedNanos / (double)(1L + this.inputPositions - this.outputPositions);
        }
    }

    private static final class FilterFunctionWithStats {
        private final FilterFunction function;
        private final FilterStats stats;

        private FilterFunctionWithStats(FilterFunction function, FilterStats stats) {
            this.function = function;
            this.stats = stats;
        }

        public FilterFunction getFunction() {
            return this.function;
        }

        public FilterStats getStats() {
            return this.stats;
        }
    }

    private static final class OrcBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final SelectiveStreamReader reader;
        @Nullable
        private final Function<Block, Block> coercer;
        private final int offset;
        private final int[] positions;
        private final int positionCount;
        private boolean loaded;

        public OrcBlockLoader(SelectiveStreamReader reader, @Nullable Function<Block, Block> coercer, int offset, int[] positions, int positionCount) {
            this.reader = Objects.requireNonNull(reader, "reader is null");
            this.coercer = coercer;
            this.offset = offset;
            this.positions = Objects.requireNonNull(positions, "positions is null");
            this.positionCount = positionCount;
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            try {
                this.reader.read(this.offset, this.positions, this.positionCount);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Block block = this.reader.getBlock(this.positions, this.positionCount);
            if (this.coercer != null) {
                block = this.coercer.apply(block);
            }
            lazyBlock.setBlock(block);
            this.loaded = true;
        }
    }
}

