/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class ByteArrayUtils {
    private static final long M = -4132994306676758123L;
    private static final Unsafe unsafe;

    private ByteArrayUtils() {
    }

    public static int compareRanges(byte[] left, int leftOffset, int leftLength, byte[] right, int rightOffset, int rightLength) {
        int lengthToCompare;
        long leftAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + leftOffset;
        long rightAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + rightOffset;
        for (lengthToCompare = Math.min(leftLength, rightLength); lengthToCompare >= 8; lengthToCompare -= 8) {
            long rightLong;
            long leftLong = unsafe.getLong(left, leftAddress);
            if (leftLong != (rightLong = unsafe.getLong(right, rightAddress))) {
                return ByteArrayUtils.longBytesToLong(leftLong) < ByteArrayUtils.longBytesToLong(rightLong) ? -1 : 1;
            }
            leftAddress += 8L;
            rightAddress += 8L;
        }
        while (lengthToCompare > 0) {
            int compareResult = ByteArrayUtils.compareUnsignedBytes(unsafe.getByte(left, leftAddress), unsafe.getByte(right, rightAddress));
            if (compareResult != 0) {
                return compareResult;
            }
            ++leftAddress;
            ++rightAddress;
            --lengthToCompare;
        }
        return Integer.compare(leftLength, rightLength);
    }

    private static int compareUnsignedBytes(byte thisByte, byte thatByte) {
        return Byte.toUnsignedInt(thisByte) - Byte.toUnsignedInt(thatByte);
    }

    private static long longBytesToLong(long bytes) {
        return Long.reverseBytes(bytes) ^ Long.MIN_VALUE;
    }

    public static long hash(byte[] bytes, int offset, int length) {
        long seed = 1L;
        int i = 0;
        while (i + 8 <= length) {
            seed = seed * -4132994306676758123L * unsafe.getLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset + (long)i) ^ seed >> 27;
            i += 8;
        }
        long lastWord = 0L;
        while (i < length) {
            lastWord = (long)bytes[offset + i] | lastWord << 8;
            ++i;
        }
        return seed * -4132994306676758123L * lastWord ^ seed << 27;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

