/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.zstd;

import com.github.luben.zstd.Zstd;
import io.airlift.compress.Compressor;
import java.nio.ByteBuffer;

public class ZstdJniCompressor
implements Compressor {
    private static final int COMPRESSION_LEVEL = 3;

    public int maxCompressedLength(int uncompressedSize) {
        return Math.toIntExact(Zstd.compressBound((long)uncompressedSize));
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        long size = Zstd.compressByteArray((byte[])output, (int)outputOffset, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength, (int)3);
        if (Zstd.isError((long)size)) {
            throw new RuntimeException(Zstd.getErrorName((long)size));
        }
        return Math.toIntExact(size);
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        throw new UnsupportedOperationException();
    }
}

