/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.reader.BooleanSelectiveStreamReader;
import com.facebook.presto.orc.reader.ByteSelectiveStreamReader;
import com.facebook.presto.orc.reader.DoubleSelectiveStreamReader;
import com.facebook.presto.orc.reader.FloatSelectiveStreamReader;
import com.facebook.presto.orc.reader.HierarchicalFilter;
import com.facebook.presto.orc.reader.ListFilter;
import com.facebook.presto.orc.reader.ListSelectiveStreamReader;
import com.facebook.presto.orc.reader.LongDecimalSelectiveStreamReader;
import com.facebook.presto.orc.reader.LongSelectiveStreamReader;
import com.facebook.presto.orc.reader.MapSelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.ShortDecimalSelectiveStreamReader;
import com.facebook.presto.orc.reader.SliceSelectiveStreamReader;
import com.facebook.presto.orc.reader.StructSelectiveStreamReader;
import com.facebook.presto.orc.reader.TimestampSelectiveStreamReader;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTimeZone;

public final class SelectiveStreamReaders {
    private SelectiveStreamReaders() {
    }

    public static SelectiveStreamReader createStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, Optional<Type> outputType, List<Subfield> requiredSubfields, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryContext) {
        OrcType.OrcTypeKind type = streamDescriptor.getOrcTypeKind();
        switch (type) {
            case BOOLEAN: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Boolean stream reader doesn't support subfields");
                return new BooleanSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case BYTE: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Byte stream reader doesn't support subfields");
                return new ByteSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Primitive type stream reader doesn't support subfields");
                return new LongSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext);
            }
            case FLOAT: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Float type stream reader doesn't support subfields");
                return new FloatSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Double stream reader doesn't support subfields");
                return new DoubleSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Primitive stream reader doesn't support subfields");
                return new SliceSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext);
            }
            case TIMESTAMP: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Timestamp stream reader doesn't support subfields");
                return new TimestampSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), hiveStorageTimeZone, outputType.isPresent(), systemMemoryContext.newLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case LIST: {
                return new ListSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, null, 0, outputType, hiveStorageTimeZone, systemMemoryContext);
            }
            case STRUCT: {
                return new StructSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, outputType, hiveStorageTimeZone, systemMemoryContext);
            }
            case MAP: {
                return new MapSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, outputType, hiveStorageTimeZone, systemMemoryContext);
            }
            case DECIMAL: {
                if (streamDescriptor.getOrcType().getPrecision().get() <= 18) {
                    return new ShortDecimalSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext.newLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
                }
                return new LongDecimalSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext.newLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    private static Optional<TupleDomainFilter> getOptionalOnlyFilter(OrcType.OrcTypeKind type, Map<Subfield, TupleDomainFilter> filters) {
        if (filters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((filters.size() == 1 ? 1 : 0) != 0, (Object)String.format("Stream reader for %s doesn't support multiple range filters", new Object[]{type}));
        return Optional.of(Iterables.getOnlyElement(filters.values()));
    }

    public static SelectiveStreamReader createNestedStreamReader(StreamDescriptor streamDescriptor, int level, Optional<HierarchicalFilter> parentFilter, Optional<Type> outputType, List<Subfield> requiredSubfields, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryContext) {
        switch (streamDescriptor.getOrcTypeKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: 
            case FLOAT: 
            case DOUBLE: 
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case TIMESTAMP: 
            case DECIMAL: {
                TupleDomainFilter.PositionalFilter positionalFilter;
                ImmutableMap elementFilters = ImmutableMap.of();
                if (parentFilter.isPresent() && (positionalFilter = parentFilter.get().getPositionalFilter()) != null) {
                    elementFilters = ImmutableMap.of((Object)new Subfield("c"), (Object)positionalFilter);
                }
                if (!outputType.isPresent() && elementFilters.isEmpty()) {
                    return null;
                }
                return SelectiveStreamReaders.createStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)elementFilters, outputType, requiredSubfields, hiveStorageTimeZone, systemMemoryContext.newAggregatedMemoryContext());
            }
            case LIST: {
                Optional<ListFilter> childFilter = parentFilter.map(HierarchicalFilter::getChild).map(ListFilter.class::cast);
                return new ListSelectiveStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), requiredSubfields, childFilter.orElse(null), level, outputType, hiveStorageTimeZone, systemMemoryContext.newAggregatedMemoryContext());
            }
            case STRUCT: {
                Preconditions.checkArgument((!parentFilter.isPresent() ? 1 : 0) != 0, (Object)"Filters on nested structs are not supported yet");
                return new StructSelectiveStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), requiredSubfields, outputType, hiveStorageTimeZone, systemMemoryContext.newAggregatedMemoryContext());
            }
            case MAP: {
                Preconditions.checkArgument((!parentFilter.isPresent() ? 1 : 0) != 0, (Object)"Filters on nested maps are not supported yet");
                return new MapSelectiveStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), requiredSubfields, outputType, hiveStorageTimeZone, systemMemoryContext.newAggregatedMemoryContext());
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getOrcTypeKind()));
    }

    public static int[] initializeOutputPositions(int[] outputPositions, int[] positions, int positionCount) {
        outputPositions = Arrays.ensureCapacity((int[])outputPositions, (int)positionCount);
        System.arraycopy(positions, 0, outputPositions, 0, positionCount);
        return outputPositions;
    }
}

