/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BooleanBatchStreamReader;
import com.facebook.presto.orc.reader.ByteBatchStreamReader;
import com.facebook.presto.orc.reader.DecimalBatchStreamReader;
import com.facebook.presto.orc.reader.DoubleBatchStreamReader;
import com.facebook.presto.orc.reader.FloatBatchStreamReader;
import com.facebook.presto.orc.reader.ListBatchStreamReader;
import com.facebook.presto.orc.reader.LongBatchStreamReader;
import com.facebook.presto.orc.reader.MapBatchStreamReader;
import com.facebook.presto.orc.reader.SliceBatchStreamReader;
import com.facebook.presto.orc.reader.StructBatchStreamReader;
import com.facebook.presto.orc.reader.TimestampBatchStreamReader;
import com.facebook.presto.spi.type.Type;
import org.joda.time.DateTimeZone;

public final class BatchStreamReaders {
    private BatchStreamReaders() {
    }

    public static BatchStreamReader createStreamReader(Type type, StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException {
        switch (streamDescriptor.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanBatchStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(BatchStreamReaders.class.getSimpleName()));
            }
            case BYTE: {
                return new ByteBatchStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(BatchStreamReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongBatchStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case FLOAT: {
                return new FloatBatchStreamReader(type, streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleBatchStreamReader(type, streamDescriptor);
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceBatchStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case TIMESTAMP: {
                return new TimestampBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone);
            }
            case LIST: {
                return new ListBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone, systemMemoryContext);
            }
            case STRUCT: {
                return new StructBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone, systemMemoryContext);
            }
            case MAP: {
                return new MapBatchStreamReader(type, streamDescriptor, hiveStorageTimeZone, systemMemoryContext);
            }
            case DECIMAL: {
                return new DecimalBatchStreamReader(type, streamDescriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getOrcTypeKind()));
    }
}

