/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.github.luben.zstd.Zstd;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.util.Objects;

class OrcZstdDecompressor
implements OrcDecompressor {
    private final OrcDataSourceId orcDataSourceId;
    private final int maxBufferSize;
    private final Decompressor decompressor;

    public OrcZstdDecompressor(OrcDataSourceId orcDataSourceId, int maxBufferSize, boolean zstdJniDecompressionEnabled) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.maxBufferSize = maxBufferSize;
        if (zstdJniDecompressionEnabled) {
            this.decompressor = (input, inputOffset, inputLength, output, outputOffset, maxOutputLength) -> {
                long size = Zstd.decompressByteArray((byte[])output, (int)0, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength);
                if (Zstd.isError((long)size)) {
                    String errorName = Zstd.getErrorName((long)size);
                    throw new MalformedInputException((long)inputOffset, "Zstd JNI decompressor failed with " + errorName);
                }
                return StrictMath.toIntExact(size);
            };
        } else {
            ZstdDecompressor zstdDecompressor = new ZstdDecompressor();
            this.decompressor = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((ZstdDecompressor)zstdDecompressor).decompress(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        }
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        try {
            long uncompressedLength = ZstdDecompressor.getDecompressedSize((byte[])input, (int)offset, (int)length);
            if (uncompressedLength > (long)this.maxBufferSize) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Zstd requires buffer (%s) larger than max size (%s)", uncompressedLength, this.maxBufferSize);
            }
            byte[] buffer = output.initialize(StrictMath.toIntExact(uncompressedLength));
            return this.decompressor.decompress(input, offset, length, buffer, 0, buffer.length);
        }
        catch (MalformedInputException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid compressed stream", new Object[0]);
        }
    }

    public String toString() {
        return "zstd";
    }

    static interface Decompressor {
        public int decompress(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws MalformedInputException;
    }
}

