/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamV1Checkpoint;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import java.io.IOException;

public class LongInputStreamV1
implements LongInputStream {
    private static final int MIN_REPEAT_SIZE = 3;
    private final OrcInputStream input;
    private final boolean signed;
    private long repeatBase;
    private int numValuesInRun;
    private int delta;
    private int used;
    private boolean repeat;

    public LongInputStreamV1(OrcInputStream input, boolean signed) {
        this.input = input;
        this.signed = signed;
    }

    private void readHeader() throws IOException {
        int control = this.input.read();
        if (control == -1) {
            throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Read past end of RLE integer");
        }
        if (control < 128) {
            this.numValuesInRun = control + 3;
            this.used = 0;
            this.repeat = true;
            this.delta = this.input.read();
            if (this.delta == -1) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "End of stream in RLE Integer");
            }
            this.delta = (byte)this.delta;
            this.repeatBase = this.input.readVarint(this.signed);
        } else {
            this.numValuesInRun = 256 - control;
            this.used = 0;
            this.repeat = false;
        }
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numValuesInRun) {
            this.readHeader();
        }
        long result = this.repeat ? this.repeatBase + (long)(this.used * this.delta) : this.input.readVarint(this.signed);
        ++this.used;
        return result;
    }

    @Override
    public Class<? extends LongStreamV1Checkpoint> getCheckpointType() {
        return LongStreamV1Checkpoint.class;
    }

    @Override
    public void seekToCheckpoint(LongStreamCheckpoint checkpoint) throws IOException {
        LongStreamV1Checkpoint v1Checkpoint = (LongStreamV1Checkpoint)checkpoint;
        this.input.seekToCheckpoint(v1Checkpoint.getInputStreamCheckpoint());
        this.numValuesInRun = 0;
        this.used = 0;
        this.skip(v1Checkpoint.getOffset());
    }

    @Override
    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.used == this.numValuesInRun) {
                this.readHeader();
            }
            long consume = Math.min(items, (long)(this.numValuesInRun - this.used));
            if (!this.repeat) {
                this.input.skipVarints(consume);
            }
            this.used = (int)((long)this.used + consume);
            items -= consume;
        }
    }
}

