/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SliceSelectiveStreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.block.ClosingBlockLease;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class SliceDirectSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDirectSelectiveStreamReader.class).instanceSize();
    private static final int ONE_GIGABYTE = Math.toIntExact(new DataSize(1.0, DataSize.Unit.GIGABYTE).toBytes());
    private final TupleDomainFilter filter;
    private final boolean nonDeterministicFilter;
    private final boolean nullsAllowed;
    private final StreamDescriptor streamDescriptor;
    private final boolean outputRequired;
    private final Type outputType;
    private final boolean isCharType;
    private final int maxCodePointCount;
    private int readOffset;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteArrayInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private ByteArrayInputStream dataStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;
    private LocalMemoryContext systemMemoryContext;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean outputPositionsReadOnly;
    private boolean allNulls;
    private boolean[] isNullVector;
    private int[] lengthVector;
    private int lengthIndex;
    private int[] offsets;
    private byte[] data;
    private Slice dataAsSlice;
    private boolean valuesInUse;

    public SliceDirectSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, LocalMemoryContext newLocalMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = Objects.requireNonNull(filter, "filter is null").orElse(null);
        this.systemMemoryContext = newLocalMemoryContext;
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
        this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
        this.outputRequired = outputType.isPresent();
        this.isCharType = streamDescriptor.getOrcType().getOrcTypeKind() == OrcType.OrcTypeKind.CHAR;
        this.maxCodePointCount = streamDescriptor.getOrcType().getLength().orElse(-1);
        Preconditions.checkArgument((filter.isPresent() || this.outputRequired ? 1 : 0) != 0, (Object)"filter must be present if outputRequired is false");
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.filter != null) {
            this.outputPositions = Arrays.ensureCapacity((int[])this.outputPositions, (int)positionCount);
        } else {
            this.outputPositions = positions;
            this.outputPositionsReadOnly = true;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        this.prepareForNextRead(positionCount, positions);
        int streamPosition = this.lengthStream == null ? this.readAllNulls(positions, positionCount) : (this.filter == null ? this.readNoFilter(positions, positionCount) : this.readWithFilter(positions, positionCount));
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        this.allNulls = false;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skipData(streamPosition, position - streamPosition);
                streamPosition = position;
            }
            int offset = this.offsets[i];
            if (this.presentStream != null && this.isNullVector[position]) {
                if (this.offsets != null) {
                    this.offsets[i + 1] = offset;
                }
                this.nulls[i] = true;
            } else {
                int length = this.lengthVector[this.lengthIndex];
                int truncatedLength = 0;
                if (length > 0) {
                    this.dataStream.next(this.data, offset, offset + length);
                    truncatedLength = SliceSelectiveStreamReader.computeTruncatedLength(this.dataAsSlice, offset, length, this.maxCodePointCount, this.isCharType);
                }
                this.offsets[i + 1] = offset + truncatedLength;
                ++this.lengthIndex;
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private int readWithFilter(int[] positions, int positionCount) throws IOException {
        this.allNulls = false;
        int streamPosition = 0;
        int dataToSkip = 0;
        for (int i = 0; i < positionCount; ++i) {
            int offset;
            int position = positions[i];
            if (position > streamPosition) {
                this.skipData(streamPosition, position - streamPosition);
                streamPosition = position;
            }
            int n = offset = this.outputRequired ? this.offsets[this.outputPositionCount] : 0;
            if (this.presentStream != null && this.isNullVector[position]) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.offsets[this.outputPositionCount + 1] = offset;
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int dataOffset;
                int length = this.lengthVector[this.lengthIndex];
                int n2 = dataOffset = this.outputRequired ? offset : 0;
                if (this.filter.testLength(length)) {
                    if (this.dataStream != null) {
                        this.dataStream.skip(dataToSkip);
                        dataToSkip = 0;
                        this.dataStream.next(this.data, dataOffset, dataOffset + length);
                        if (this.filter.testBytes(this.data, dataOffset, length)) {
                            if (this.outputRequired) {
                                int truncatedLength = SliceSelectiveStreamReader.computeTruncatedLength(this.dataAsSlice, dataOffset, length, this.maxCodePointCount, this.isCharType);
                                this.offsets[this.outputPositionCount + 1] = offset + truncatedLength;
                                if (this.nullsAllowed && this.isNullVector != null) {
                                    this.nulls[this.outputPositionCount] = false;
                                }
                            }
                            this.outputPositions[this.outputPositionCount] = position;
                            ++this.outputPositionCount;
                        }
                    } else {
                        assert (length == 0);
                        if (this.filter.testBytes("".getBytes(), 0, 0)) {
                            if (this.outputRequired) {
                                this.offsets[this.outputPositionCount + 1] = offset;
                                if (this.nullsAllowed && this.isNullVector != null) {
                                    this.nulls[this.outputPositionCount] = false;
                                }
                            }
                            this.outputPositions[this.outputPositionCount] = position;
                            ++this.outputPositionCount;
                        }
                    }
                } else {
                    dataToSkip += length;
                }
                ++this.lengthIndex;
            }
            ++streamPosition;
            if (this.filter == null) continue;
            this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
            int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            this.skipData(streamPosition, positionsToSkip);
        }
        if (dataToSkip > 0) {
            this.dataStream.skip(dataToSkip);
        }
        return streamPosition;
    }

    private int readAllNulls(int[] positions, int positionCount) {
        if (this.nonDeterministicFilter) {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                if (this.filter.testNull()) {
                    ++this.outputPositionCount;
                    continue;
                }
                this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
                i += this.filter.getSucceedingPositionsToFail();
            }
        } else if (this.nullsAllowed) {
            this.outputPositionCount = positionCount;
            if (this.filter != null) {
                this.outputPositions = positions;
                this.outputPositionsReadOnly = true;
            }
        } else {
            this.outputPositionCount = 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private void skip(int items) throws IOException {
        if (this.dataStream == null && this.presentStream != null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int lengthToSkip = this.presentStream.countBitsSet(items);
            this.dataStream.skip(this.lengthStream.sum(lengthToSkip));
        } else {
            long sum = this.lengthStream.sum(items);
            if (this.dataStream != null) {
                this.dataStream.skip(sum);
            }
        }
    }

    private void skipData(int start, int items) throws IOException {
        int dataToSkip = 0;
        for (int i = 0; i < items; ++i) {
            if (this.presentStream != null && this.isNullVector[start + i]) continue;
            dataToSkip += this.lengthVector[this.lengthIndex];
            ++this.lengthIndex;
        }
        if (this.dataStream != null) {
            this.dataStream.skip(dataToSkip);
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), this.outputPositionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        VariableWidthBlock block = new VariableWidthBlock(positionCount, this.dataAsSlice, this.offsets, Optional.ofNullable(includeNulls ? this.nulls : null));
        this.dataAsSlice = null;
        this.data = null;
        this.offsets = null;
        this.nulls = null;
        return block;
    }

    private void compactValues(int[] positions, int positionCount, boolean includeNulls) {
        if (this.outputPositionsReadOnly) {
            this.outputPositions = java.util.Arrays.copyOf(this.outputPositions, this.outputPositionCount);
            this.outputPositionsReadOnly = false;
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            int length = this.offsets[i + 1] - this.offsets[i];
            if (length > 0) {
                System.arraycopy(this.data, this.offsets[i], this.data, this.offsets[positionIndex], length);
            }
            this.offsets[positionIndex + 1] = this.offsets[positionIndex] + length;
            this.outputPositions[positionIndex] = nextPosition;
            if (includeNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), this.outputPositionCount));
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        return this.newLease((Block)new VariableWidthBlock(positionCount, this.dataAsSlice, this.offsets, Optional.ofNullable(includeNulls ? this.nulls : null)));
    }

    private BlockLease newLease(Block block) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            this.valuesInUse = false;
        }});
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((byte[])this.data) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.lengthVector) + SizeOf.sizeOf((boolean[])this.isNullVector);
    }

    private void prepareForNextRead(int positionCount, int[] positions) throws IOException {
        this.lengthIndex = 0;
        this.outputPositionCount = 0;
        int totalLength = 0;
        int maxLength = 0;
        int totalPositions = positions[positionCount - 1] + 1;
        int nullCount = 0;
        if (this.presentStream != null) {
            this.isNullVector = Arrays.ensureCapacity((boolean[])this.isNullVector, (int)totalPositions);
            nullCount = this.presentStream.getUnsetBits(totalPositions, this.isNullVector);
        }
        if (this.lengthStream != null) {
            int nonNullCount = totalPositions - nullCount;
            this.lengthVector = Arrays.ensureCapacity((int[])this.lengthVector, (int)nonNullCount);
            this.lengthStream.nextIntVector(nonNullCount, this.lengthVector, 0);
            for (int i = 0; i < nonNullCount; ++i) {
                totalLength += this.lengthVector[i];
                maxLength = Math.max(maxLength, this.lengthVector[i]);
            }
            if (totalLength > ONE_GIGABYTE) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Values in column \"%s\" are too large to process for Presto. %s column values are larger than 1GB [%s]", this.streamDescriptor.getFieldName(), positionCount, this.streamDescriptor.getOrcDataSourceId()));
            }
        }
        if (this.outputRequired) {
            if (this.presentStream != null && this.nullsAllowed) {
                this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)positionCount);
            }
            this.data = Arrays.ensureCapacity((byte[])this.data, (int)totalLength);
            this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(totalPositions + 1));
        } else {
            this.data = Arrays.ensureCapacity((byte[])this.data, (int)maxLength);
        }
        this.dataAsSlice = Slices.wrappedBuffer((byte[])this.data);
    }
}

