/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.LongDictionaryBatchStreamReader;
import com.facebook.presto.orc.reader.LongDirectBatchStreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class LongBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongBatchStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final LongDirectBatchStreamReader directReader;
    private final LongDictionaryBatchStreamReader dictionaryReader;
    private BatchStreamReader currentReader;

    public LongBatchStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.directReader = new LongDirectBatchStreamReader(streamDescriptor);
        this.dictionaryReader = new LongDictionaryBatchStreamReader(streamDescriptor);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.currentReader.prepareNextRead(batchSize);
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        return this.currentReader.readBlock(type);
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncoding(this.streamDescriptor.getSequence()).getColumnEncodingKind();
        if (kind == ColumnEncoding.ColumnEncodingKind.DIRECT || kind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || kind == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            this.currentReader = this.directReader;
        } else if (kind == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
        }
        this.currentReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.directReader.getRetainedSizeInBytes() + this.dictionaryReader.getRetainedSizeInBytes();
    }
}

