/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.CachingOrcDataSource;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.FilterFunction;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.ExceptionWrappingMetadataReader;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.joda.time.DateTimeZone;

public class OrcReader {
    public static final int MAX_BATCH_SIZE = 1024;
    public static final int INITIAL_BATCH_SIZE = 1;
    public static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final OrcDataSource orcDataSource;
    private final ExceptionWrappingMetadataReader metadataReader;
    private final DataSize maxMergeDistance;
    private final DataSize tinyStripeThreshold;
    private final DataSize maxBlockSize;
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final int bufferSize;
    private final CompressionKind compressionKind;
    private final Optional<OrcDecompressor> decompressor;
    private final Footer footer;
    private final Metadata metadata;
    private final Optional<OrcWriteValidation> writeValidation;
    private final StripeMetadataSource stripeMetadataSource;

    public OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource) throws IOException {
        this(orcDataSource, orcEncoding, maxMergeDistance, tinyStripeThreshold, maxBlockSize, orcFileTailSource, stripeMetadataSource, Optional.empty());
    }

    OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource, Optional<OrcWriteValidation> writeValidation) throws IOException {
        this.orcDataSource = orcDataSource = OrcReader.wrapWithCacheIfTiny(orcDataSource, tinyStripeThreshold);
        Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        this.metadataReader = new ExceptionWrappingMetadataReader(orcDataSource.getId(), orcEncoding.createMetadataReader());
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        this.stripeMetadataSource = Objects.requireNonNull(stripeMetadataSource, "stripeMetadataSource is null");
        OrcFileTail orcFileTail = orcFileTailSource.getOrcFileTail(orcDataSource, this.metadataReader, writeValidation);
        this.bufferSize = orcFileTail.getBufferSize();
        this.compressionKind = orcFileTail.getCompressionKind();
        this.decompressor = OrcDecompressor.createOrcDecompressor(orcDataSource.getId(), this.compressionKind, this.bufferSize);
        this.hiveWriterVersion = orcFileTail.getHiveWriterVersion();
        try (OrcInputStream footerInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)orcFileTail.getFooterSlice().getInput(), this.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), orcFileTail.getFooterSize());){
            this.footer = this.metadataReader.readFooter(this.hiveWriterVersion, footerInputStream);
        }
        if (this.footer.getTypes().size() == 0) {
            throw new OrcCorruptionException(orcDataSource.getId(), "File has no columns");
        }
        var11_11 = null;
        try (OrcInputStream metadataInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)orcFileTail.getMetadataSlice().getInput(), this.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), orcFileTail.getMetadataSize());){
            this.metadata = this.metadataReader.readMetadata(this.hiveWriterVersion, metadataInputStream);
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getColumnNames().equals(this.footer.getTypes().get(0).getFieldNames()), "Unexpected column names", new Object[0]);
        OrcReader.validateWrite(writeValidation, orcDataSource, validation -> validation.getRowGroupMaxRowCount() == this.footer.getRowsInRowGroup(), "Unexpected rows in group", new Object[0]);
        if (writeValidation.isPresent()) {
            writeValidation.get().validateMetadata(orcDataSource.getId(), this.footer.getUserMetadata());
            writeValidation.get().validateFileStatistics(orcDataSource.getId(), this.footer.getFileStats());
            writeValidation.get().validateStripeStatistics(orcDataSource.getId(), this.footer.getStripes(), this.metadata.getStripeStatsList());
        }
    }

    public List<String> getColumnNames() {
        return this.footer.getTypes().get(0).getFieldNames();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OrcBatchRecordReader createBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize) {
        return this.createBatchRecordReader(includedColumns, predicate, 0L, this.orcDataSource.getSize(), hiveStorageTimeZone, systemMemoryUsage, initialBatchSize);
    }

    public OrcBatchRecordReader createBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage, int initialBatchSize) {
        return new OrcBatchRecordReader(Objects.requireNonNull(includedColumns, "includedColumns is null"), Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null"), this.hiveWriterVersion, this.metadataReader, this.maxMergeDistance, this.tinyStripeThreshold, this.maxBlockSize, this.footer.getUserMetadata(), systemMemoryUsage.newAggregatedMemoryContext(), this.writeValidation, initialBatchSize, this.stripeMetadataSource);
    }

    public OrcSelectiveRecordReader createSelectiveRecordReader(Map<Integer, Type> includedColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputs, Map<Integer, List<Subfield>> requiredSubfields, Map<Integer, Object> constantValues, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize) {
        return new OrcSelectiveRecordReader(includedColumns, outputColumns, filters, filterFunctions, filterFunctionInputs, requiredSubfields, constantValues, predicate, this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), hiveStorageTimeZone, this.hiveWriterVersion, this.metadataReader, this.maxMergeDistance, this.tinyStripeThreshold, this.maxBlockSize, this.footer.getUserMetadata(), systemMemoryUsage.newAggregatedMemoryContext(), writeValidation, initialBatchSize, this.stripeMetadataSource);
    }

    private static OrcDataSource wrapWithCacheIfTiny(OrcDataSource dataSource, DataSize maxCacheSize) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        if (dataSource.getSize() > maxCacheSize.toBytes()) {
            return dataSource;
        }
        DiskRange diskRange = new DiskRange(0L, Math.toIntExact(dataSource.getSize()));
        return new CachingOrcDataSource(dataSource, desiredOffset -> diskRange);
    }

    static void validateFile(OrcWriteValidation writeValidation, OrcDataSource input, List<Type> types, DateTimeZone hiveStorageTimeZone, OrcEncoding orcEncoding) throws OrcCorruptionException {
        ImmutableMap.Builder readTypes = ImmutableMap.builder();
        for (int columnIndex = 0; columnIndex < types.size(); ++columnIndex) {
            readTypes.put((Object)columnIndex, (Object)types.get(columnIndex));
        }
        try {
            OrcReader orcReader = new OrcReader(input, orcEncoding, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE), new StorageOrcFileTailSource(), new StorageStripeMetadataSource(), Optional.of(writeValidation));
            try (OrcBatchRecordReader orcRecordReader = orcReader.createBatchRecordReader((Map<Integer, Type>)readTypes.build(), OrcPredicate.TRUE, hiveStorageTimeZone, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1);){
                while (orcRecordReader.nextBatch() >= 0) {
                }
            }
        }
        catch (IOException e) {
            throw new OrcCorruptionException(e, input.getId(), "Validation failed", new Object[0]);
        }
    }

    public static void validateWrite(Optional<OrcWriteValidation> writeValidation, OrcDataSource orcDataSource, Predicate<OrcWriteValidation> test, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (writeValidation.isPresent() && !test.test(writeValidation.get())) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }
}

