/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.AbstractOrcRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BatchStreamReaders;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class OrcBatchRecordReader
extends AbstractOrcRecordReader<BatchStreamReader> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcBatchRecordReader.class).instanceSize();
    private final Map<Integer, Type> includedColumns;

    public OrcBatchRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, List<ColumnStatistics> fileStats, List<StripeStatistics> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, List<OrcType> types, Optional<OrcDecompressor> decompressor, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Map<String, Slice> userMetadata, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize, StripeMetadataSource stripeMetadataSource) {
        super(includedColumns, (StreamReader[])OrcBatchRecordReader.createStreamReaders(orcDataSource, types, hiveStorageTimeZone, includedColumns), predicate, numberOfRows, fileStripes, fileStats, stripeStats, orcDataSource, splitOffset, splitLength, types, decompressor, rowsInRowGroup, hiveStorageTimeZone, hiveWriterVersion, metadataReader, maxMergeDistance, tinyStripeThreshold, maxBlockSize, userMetadata, systemMemoryUsage, writeValidation, initialBatchSize, stripeMetadataSource);
        this.includedColumns = includedColumns;
    }

    public int nextBatch() throws IOException {
        int batchSize = this.prepareNextBatch();
        if (batchSize < 0) {
            return batchSize;
        }
        for (BatchStreamReader column : (BatchStreamReader[])this.getStreamReaders()) {
            if (column == null) continue;
            column.prepareNextRead(batchSize);
        }
        this.batchRead(batchSize);
        this.validateWritePageChecksum(batchSize);
        return batchSize;
    }

    public Block readBlock(Type type, int columnIndex) throws IOException {
        Block block = ((BatchStreamReader[])this.getStreamReaders())[columnIndex].readBlock(type);
        this.updateMaxCombinedBytesPerRow(columnIndex, block);
        return block;
    }

    @Override
    @VisibleForTesting
    protected long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + super.getRetainedSizeInBytes();
    }

    private void validateWritePageChecksum(int batchSize) throws IOException {
        if (this.shouldValidateWritePageChecksum()) {
            Block[] blocks = new Block[((BatchStreamReader[])this.getStreamReaders()).length];
            for (int columnIndex = 0; columnIndex < ((BatchStreamReader[])this.getStreamReaders()).length; ++columnIndex) {
                blocks[columnIndex] = this.readBlock(this.includedColumns.get(columnIndex), columnIndex);
            }
            Page page = new Page(batchSize, blocks);
            this.validateWritePageChecksum(page);
        }
    }

    private static BatchStreamReader[] createStreamReaders(OrcDataSource orcDataSource, List<OrcType> types, DateTimeZone hiveStorageTimeZone, Map<Integer, Type> includedColumns) {
        List<StreamDescriptor> streamDescriptors = OrcBatchRecordReader.createStreamDescriptor("", "", 0, types, orcDataSource).getNestedStreams();
        OrcType rowType = types.get(0);
        BatchStreamReader[] streamReaders = new BatchStreamReader[rowType.getFieldCount()];
        for (int columnId = 0; columnId < rowType.getFieldCount(); ++columnId) {
            if (!includedColumns.containsKey(columnId)) continue;
            StreamDescriptor streamDescriptor = streamDescriptors.get(columnId);
            streamReaders[columnId] = BatchStreamReaders.createStreamReader(streamDescriptor, hiveStorageTimeZone);
        }
        return streamReaders;
    }
}

