/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.stream.ByteInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class BooleanInputStream
implements ValueInputStream<BooleanStreamCheckpoint> {
    private static final int HIGH_BIT_MASK = 128;
    private final ByteInputStream byteStream;
    private byte data;
    private int bitsInData;

    public BooleanInputStream(OrcInputStream byteStream) {
        this.byteStream = new ByteInputStream(byteStream);
    }

    private void readByte() throws IOException {
        Preconditions.checkState((this.bitsInData == 0 ? 1 : 0) != 0);
        this.data = this.byteStream.next();
        this.bitsInData = 8;
    }

    public boolean nextBit() throws IOException {
        if (this.bitsInData == 0) {
            this.readByte();
        }
        boolean result = (this.data & 0x80) != 0;
        this.data = (byte)(this.data << 1);
        --this.bitsInData;
        return result;
    }

    @Override
    public Class<BooleanStreamCheckpoint> getCheckpointType() {
        return BooleanStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(BooleanStreamCheckpoint checkpoint) throws IOException {
        this.byteStream.seekToCheckpoint(checkpoint.getByteStreamCheckpoint());
        this.bitsInData = 0;
        this.skip(checkpoint.getOffset());
    }

    @Override
    public void skip(long items) throws IOException {
        if ((long)this.bitsInData >= items) {
            this.data = (byte)(this.data << (int)items);
            this.bitsInData = (int)((long)this.bitsInData - items);
        } else {
            this.bitsInData = 0;
            this.byteStream.skip((items -= (long)this.bitsInData) >>> 3);
            if ((items &= 7L) != 0L) {
                this.readByte();
                this.data = (byte)(this.data << (int)items);
                this.bitsInData = (int)((long)this.bitsInData - items);
            }
        }
    }

    public int countBitsSet(int items) throws IOException {
        int count = 0;
        if (items > this.bitsInData && this.bitsInData > 0) {
            count += BooleanInputStream.bitCount(this.data);
            items -= this.bitsInData;
            this.bitsInData = 0;
        }
        while (items > 8) {
            count += BooleanInputStream.bitCount(this.byteStream.next());
            items -= 8;
        }
        for (int i = 0; i < items; ++i) {
            count += this.nextBit() ? 1 : 0;
        }
        return count;
    }

    public int getSetBits(int batchSize, boolean[] vector) throws IOException {
        int count = 0;
        for (int i = 0; i < batchSize; ++i) {
            vector[i] = this.nextBit();
            count += vector[i] ? 1 : 0;
        }
        return count;
    }

    public int getSetBits(int batchSize, boolean[] vector, boolean[] isNull) throws IOException {
        int count = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            vector[i] = this.nextBit();
            count += vector[i] ? 1 : 0;
        }
        return count;
    }

    public void getSetBits(Type type, int batchSize, BlockBuilder builder) throws IOException {
        for (int i = 0; i < batchSize; ++i) {
            type.writeBoolean(builder, this.nextBit());
        }
    }

    public int getUnsetBits(int batchSize, boolean[] vector) throws IOException {
        return this.getUnsetBits(batchSize, vector, 0);
    }

    public int getUnsetBits(int batchSize, boolean[] vector, int offset) throws IOException {
        int count = 0;
        for (int i = offset; i < batchSize + offset; ++i) {
            vector[i] = !this.nextBit();
            count += vector[i] ? 1 : 0;
        }
        return count;
    }

    public int getUnsetBits(int batchSize) throws IOException {
        int count = 0;
        for (int i = 0; i < batchSize; ++i) {
            count += this.nextBit() ? 0 : 1;
        }
        return count;
    }

    private static int bitCount(byte data) {
        return Integer.bitCount(data & 0xFF);
    }
}

