/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.ApacheHiveTimestampDecoder;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.block.ClosingBlockLease;
import com.facebook.presto.spi.block.LongArrayBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.TimestampType;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class TimestampSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TimestampSelectiveStreamReader.class).instanceSize();
    private static final Block NULL_BLOCK = TimestampType.TIMESTAMP.createBlockBuilder(null, 1).appendNull().build();
    private final StreamDescriptor streamDescriptor;
    private final TupleDomainFilter filter;
    private final boolean nullsAllowed;
    private final boolean outputRequired;
    private final LocalMemoryContext systemMemoryContext;
    private final long baseTimestampInSeconds;
    private final boolean nonDeterministicFilter;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private InputStreamSource<LongInputStream> secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private InputStreamSource<LongInputStream> nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private LongInputStream secondsStream;
    private LongInputStream nanosStream;
    private boolean rowGroupOpen;
    private int readOffset;
    @Nullable
    private long[] values;
    @Nullable
    private boolean[] nulls;
    @Nullable
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean outputPositionsReadOnly;
    private boolean allNulls;
    private boolean valuesInUse;

    public TimestampSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, DateTimeZone hiveStorageTimeZone, boolean outputRequired, LocalMemoryContext systemMemoryContext) {
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((filter.isPresent() || outputRequired ? 1 : 0) != 0, (Object)"filter must be present if outputRequired is false");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.filter = filter.orElse(null);
        this.outputRequired = outputRequired;
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.secondsStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.nanosStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.values) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.secondsStream = this.secondsStreamSource.openStream();
        this.nanosStream = this.nanosStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0, (Object)"positionCount must be greater than zero");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, this.nullsAllowed && this.presentStream != null);
        }
        if (this.filter != null) {
            this.outputPositions = Arrays.ensureCapacity((int[])this.outputPositions, (int)positionCount);
        } else {
            this.outputPositions = positions;
            this.outputPositionsReadOnly = true;
        }
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.skip(offset - this.readOffset);
        }
        int streamPosition = 0;
        streamPosition = this.secondsStream == null && this.nanosStream == null && this.presentStream != null ? this.readAllNulls(positions, positionCount) : (this.filter == null ? this.readNoFilter(positions, positionCount) : this.readWithFilter(positions, positionCount));
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private int readWithFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        this.outputPositionCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nonDeterministicFilter && this.filter.testNull() || this.nullsAllowed) {
                    if (this.outputRequired) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                long value = ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
                if (this.filter.testLong(value)) {
                    if (this.outputRequired) {
                        this.values[this.outputPositionCount] = value;
                        if (this.nullsAllowed && this.presentStream != null) {
                            this.nulls[this.outputPositionCount] = false;
                        }
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            }
            ++streamPosition;
            if (this.filter == null) continue;
            this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
            int succeedingPositionsToFail = this.filter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            this.skip(positionsToSkip);
        }
        return streamPosition;
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nonDeterministicFilter) {
            this.outputPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                if (this.filter.testNull()) {
                    ++this.outputPositionCount;
                    continue;
                }
                this.outputPositionCount -= this.filter.getPrecedingPositionsToFail();
                i += this.filter.getSucceedingPositionsToFail();
            }
        } else {
            this.outputPositionCount = this.nullsAllowed ? positionCount : 0;
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private int readNoFilter(int[] positions, int positionCount) throws IOException {
        int streamPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                this.nulls[i] = true;
            } else {
                this.values[i] = ApacheHiveTimestampDecoder.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
                if (this.presentStream != null) {
                    this.nulls[i] = false;
                }
            }
            ++streamPosition;
        }
        this.outputPositionCount = positionCount;
        return streamPosition;
    }

    private void skip(int items) throws IOException {
        if (this.secondsStream == null && this.nanosStream == null) {
            this.presentStream.skip(items);
        } else if (this.presentStream != null) {
            int dataToSkip = this.presentStream.countBitsSet(items);
            this.secondsStream.skip(dataToSkip);
            this.nanosStream.skip(dataToSkip);
        } else {
            this.secondsStream.skip(items);
            this.nanosStream.skip(items);
        }
    }

    private void ensureValuesCapacity(int capacity, boolean recordNulls) {
        this.values = Arrays.ensureCapacity((long[])this.values, (int)capacity);
        if (recordNulls) {
            this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)capacity);
        }
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(NULL_BLOCK, this.outputPositionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount == this.outputPositionCount) {
            LongArrayBlock block = new LongArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.values);
            this.nulls = null;
            this.values = null;
            return block;
        }
        long[] valuesCopy = new long[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            valuesCopy[positionIndex] = this.values[i];
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new LongArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)new RunLengthEncodedBlock(NULL_BLOCK, this.outputPositionCount));
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        return this.newLease((Block)new LongArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.values));
    }

    private BlockLease newLease(Block block) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            this.valuesInUse = false;
        }});
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        if (this.outputPositionsReadOnly) {
            this.outputPositions = java.util.Arrays.copyOf(this.outputPositions, this.outputPositionCount);
            this.outputPositionsReadOnly = false;
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            this.values[positionIndex] = this.values[i];
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }
}

