/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.BooleanBatchStreamReader;
import com.facebook.presto.orc.reader.ByteBatchStreamReader;
import com.facebook.presto.orc.reader.DecimalBatchStreamReader;
import com.facebook.presto.orc.reader.DoubleBatchStreamReader;
import com.facebook.presto.orc.reader.FloatBatchStreamReader;
import com.facebook.presto.orc.reader.ListBatchStreamReader;
import com.facebook.presto.orc.reader.LongBatchStreamReader;
import com.facebook.presto.orc.reader.MapBatchStreamReader;
import com.facebook.presto.orc.reader.SliceBatchStreamReader;
import com.facebook.presto.orc.reader.StructBatchStreamReader;
import com.facebook.presto.orc.reader.TimestampBatchStreamReader;
import org.joda.time.DateTimeZone;

public final class BatchStreamReaders {
    private BatchStreamReaders() {
    }

    public static BatchStreamReader createStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        switch (streamDescriptor.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanBatchStreamReader(streamDescriptor);
            }
            case BYTE: {
                return new ByteBatchStreamReader(streamDescriptor);
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongBatchStreamReader(streamDescriptor);
            }
            case FLOAT: {
                return new FloatBatchStreamReader(streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleBatchStreamReader(streamDescriptor);
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceBatchStreamReader(streamDescriptor);
            }
            case TIMESTAMP: {
                return new TimestampBatchStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case LIST: {
                return new ListBatchStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case STRUCT: {
                return new StructBatchStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case MAP: {
                return new MapBatchStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case DECIMAL: {
                return new DecimalBatchStreamReader(streamDescriptor);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getOrcTypeKind()));
    }
}

