/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamDwrfCheckpoint;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.stream.LongDecode;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import java.io.IOException;

public class LongInputStreamDwrf
implements LongInputStream {
    private final OrcInputStream input;
    private final OrcType.OrcTypeKind orcTypeKind;
    private final boolean signed;
    private final boolean usesVInt;

    public LongInputStreamDwrf(OrcInputStream input, OrcType.OrcTypeKind type, boolean signed, boolean usesVInt) {
        this.input = input;
        this.orcTypeKind = type;
        this.signed = signed;
        this.usesVInt = usesVInt;
    }

    @Override
    public Class<LongStreamDwrfCheckpoint> getCheckpointType() {
        return LongStreamDwrfCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(LongStreamCheckpoint checkpoint) throws IOException {
        LongStreamDwrfCheckpoint dwrfCheckpoint = (LongStreamDwrfCheckpoint)checkpoint;
        this.input.seekToCheckpoint(dwrfCheckpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        for (long i = 0L; i < items; ++i) {
            this.next();
        }
    }

    @Override
    public long next() throws IOException {
        return LongDecode.readDwrfLong(this.input, this.orcTypeKind, this.signed, this.usesVInt);
    }
}

