/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.block.ClosingBlockLease;
import com.facebook.presto.spi.block.RowBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class StructSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StructSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final boolean nullsAllowed;
    private final boolean nonNullsAllowed;
    private final boolean outputRequired;
    @Nullable
    private final Type outputType;
    private final Map<String, SelectiveStreamReader> nestedReaders;
    private final LocalMemoryContext systemMemoryContext;
    private int readOffset;
    private int nestedReadOffset;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private int[] nestedPositions;
    private int[] nestedOutputPositions;
    private int nestedOutputPositionCount;
    private boolean valuesInUse;

    public StructSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> requiredSubfields, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryContext) {
        Preconditions.checkArgument((boolean)filters.keySet().stream().map(Subfield::getPath).allMatch(List::isEmpty), (Object)"filters on nested columns are not supported yet");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null").newLocalMemoryContext(StructSelectiveStreamReader.class.getSimpleName());
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.orElse(null);
        TupleDomainFilter filter = StructSelectiveStreamReader.getTopLevelFilter(filters).orElse(null);
        this.nullsAllowed = filter == null || filter.testNull();
        this.nonNullsAllowed = filter == null || filter.testNonNull();
        Optional<List> nestedTypes = outputType.map(type -> type.getTypeParameters());
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        Optional<Map<String, List<Subfield>>> requiredFields = StructSelectiveStreamReader.getRequiredFields(requiredSubfields);
        ImmutableMap.Builder nestedReaders = ImmutableMap.builder();
        for (int i = 0; i < nestedStreams.size(); ++i) {
            StreamDescriptor nestedStream = nestedStreams.get(i);
            String fieldName = nestedStream.getFieldName().toLowerCase(Locale.ENGLISH);
            Optional<Type> fieldOutputType = nestedTypes.isPresent() ? Optional.of(nestedTypes.get().get(i)) : Optional.empty();
            boolean requiredField = requiredFields.map(names -> names.containsKey(fieldName)).orElse(true);
            if (requiredField) {
                List nestedRequiredSubfields = requiredFields.map(names -> (List)names.get(fieldName)).orElse((List)ImmutableList.of());
                SelectiveStreamReader nestedReader = SelectiveStreamReaders.createStreamReader(nestedStream, (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), fieldOutputType, nestedRequiredSubfields, hiveStorageTimeZone, systemMemoryContext.newAggregatedMemoryContext());
                nestedReaders.put((Object)fieldName, (Object)nestedReader);
                continue;
            }
            nestedReaders.put((Object)fieldName, (Object)new PruningStreamReader(nestedStream, fieldOutputType));
        }
        this.nestedReaders = nestedReaders.build();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0, (Object)"positionCount must be greater than zero");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        this.outputPositions = !this.nullsAllowed || !this.nonNullsAllowed ? Arrays.ensureCapacity((int[])this.outputPositions, (int)positionCount) : positions;
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.presentStream == null) {
            if (this.nonNullsAllowed) {
                this.readNestedStreams(offset, positions, positionCount);
                this.readOffset = offset + positions[positionCount - 1];
                this.outputPositions = positions;
                this.outputPositionCount = positionCount;
            } else {
                this.outputPositionCount = 0;
            }
        } else {
            if (this.readOffset < offset) {
                this.nestedReadOffset += this.presentStream.countBitsSet(offset - this.readOffset);
            }
            this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)positionCount);
            this.nestedPositions = Arrays.ensureCapacity((int[])this.nestedPositions, (int)positionCount);
            this.outputPositionCount = 0;
            int streamPosition = 0;
            int nestedPositionCount = 0;
            int nullCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (position > streamPosition) {
                    int nonNullCount = this.presentStream.countBitsSet(position - streamPosition);
                    nullCount += position - streamPosition - nonNullCount;
                    streamPosition = position;
                }
                ++streamPosition;
                if (this.presentStream.nextBit()) {
                    if (!this.nonNullsAllowed) continue;
                    this.nulls[this.outputPositionCount] = false;
                    if (!this.nullsAllowed) {
                        this.outputPositions[this.outputPositionCount] = position;
                    }
                    ++this.outputPositionCount;
                    this.nestedPositions[nestedPositionCount++] = position - nullCount;
                    continue;
                }
                if (this.nullsAllowed) {
                    this.nulls[this.outputPositionCount] = true;
                    if (!this.nonNullsAllowed) {
                        this.outputPositions[this.outputPositionCount] = position;
                    }
                    ++this.outputPositionCount;
                }
                ++nullCount;
            }
            if (nestedPositionCount > 0) {
                this.readNestedStreams(this.nestedReadOffset, this.nestedPositions, nestedPositionCount);
            } else {
                this.allNulls = true;
            }
            this.readOffset = offset + streamPosition;
            this.nestedReadOffset += streamPosition - nullCount;
        }
        return this.outputPositionCount;
    }

    private void readNestedStreams(int offset, int[] positions, int positionCount) throws IOException {
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            reader.read(offset, positions, positionCount);
        }
        this.nestedOutputPositions = Arrays.ensureCapacity((int[])this.nestedOutputPositions, (int)positionCount);
        System.arraycopy(positions, 0, this.nestedOutputPositions, 0, positionCount);
        this.nestedOutputPositionCount = positionCount;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (this.outputPositionCount == positionCount) {
            Block block = RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), (Block[])this.getFieldBlocks());
            this.nulls = null;
            return block;
        }
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedIndex = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                if (includeNulls && this.nulls[i]) continue;
                ++nestedIndex;
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            if (!includeNulls || !this.nulls[i]) {
                this.nestedOutputPositions[this.nestedOutputPositionCount++] = this.nestedOutputPositions[nestedIndex];
                ++nestedIndex;
            }
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        if (this.nestedOutputPositionCount == 0) {
            return StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount);
        }
        return RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable((boolean[])(includeNulls ? nullsCopy : null)), (Block[])this.getFieldBlocks());
    }

    private Block[] getFieldBlocks() {
        Block[] blocks = new Block[this.nestedReaders.size()];
        int i = 0;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            blocks[i++] = reader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
        }
        return blocks;
    }

    private static RunLengthEncodedBlock createNullBlock(Type type, int positionCount) {
        return new RunLengthEncodedBlock(type.createBlockBuilder(null, 1).appendNull().build(), positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount), new BlockLease[0]);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
            if (this.nestedOutputPositionCount == 0) {
                this.allNulls = true;
                return this.newLease((Block)StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount), new BlockLease[0]);
            }
        }
        BlockLease[] fieldBlockLeases = new BlockLease[this.nestedReaders.size()];
        Block[] fieldBlocks = new Block[this.nestedReaders.size()];
        int i = 0;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            fieldBlockLeases[i] = reader.getBlockView(this.nestedOutputPositions, this.nestedOutputPositionCount);
            fieldBlocks[i] = (Block)fieldBlockLeases[i].get();
            ++i;
        }
        return this.newLease(RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), (Block[])fieldBlocks), fieldBlockLeases);
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedIndex = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                if (compactNulls && this.nulls[i]) continue;
                ++nestedIndex;
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            if (!compactNulls || !this.nulls[i]) {
                this.nestedOutputPositions[this.nestedOutputPositionCount++] = this.nestedOutputPositions[nestedIndex];
                ++nestedIndex;
            }
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    private BlockLease newLease(Block block, BlockLease ... fieldBlockLeases) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            for (BlockLease lease : fieldBlockLeases) {
                lease.close();
            }
            this.valuesInUse = false;
        }});
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            reader.startStripe(dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            reader.startRowGroup(dataStreamSources);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((int[])this.nestedPositions) + SizeOf.sizeOf((int[])this.nestedOutputPositions) + SizeOf.sizeOf((boolean[])this.nulls) + this.nestedReaders.values().stream().mapToLong(StreamReader::getRetainedSizeInBytes).sum();
    }

    private static Optional<TupleDomainFilter> getTopLevelFilter(Map<Subfield, TupleDomainFilter> filters) {
        Map topLevelFilters = Maps.filterEntries(filters, entry -> ((Subfield)entry.getKey()).getPath().isEmpty());
        if (topLevelFilters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((topLevelFilters.size() == 1 ? 1 : 0) != 0, (Object)"ROW column may have at most one top-level range filter");
        TupleDomainFilter filter = (TupleDomainFilter)Iterables.getOnlyElement(topLevelFilters.values());
        Preconditions.checkArgument((filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL ? 1 : 0) != 0, (Object)"Top-level range filter on ROW column must be IS NULL or IS NOT NULL");
        return Optional.of(filter);
    }

    private static Optional<Map<String, List<Subfield>>> getRequiredFields(List<Subfield> requiredSubfields) {
        if (requiredSubfields.isEmpty()) {
            return Optional.empty();
        }
        HashMap<String, List> fields = new HashMap<String, List>();
        for (Subfield subfield : requiredSubfields) {
            List path = subfield.getPath();
            String name = ((Subfield.NestedField)path.get(0)).getName();
            fields.computeIfAbsent(name, k -> new ArrayList());
            if (path.size() <= 1) continue;
            ((List)fields.get(name)).add(new Subfield("c", path.subList(1, path.size())));
        }
        return Optional.of(ImmutableMap.copyOf(fields));
    }

    private static final class PruningStreamReader
    implements SelectiveStreamReader {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(PruningStreamReader.class).instanceSize();
        private final StreamDescriptor streamDescriptor;
        @Nullable
        private final Type outputType;
        private int[] outputPositions;
        private int outputPositionCount;

        private PruningStreamReader(StreamDescriptor streamDescriptor, Optional<Type> outputType) {
            this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
            this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
        }

        @Override
        public int read(int offset, int[] positions, int positionCount) {
            this.outputPositions = positions;
            this.outputPositionCount = positionCount;
            return this.outputPositionCount;
        }

        @Override
        public int[] getReadPositions() {
            return this.outputPositions;
        }

        @Override
        public Block getBlock(int[] positions, int positionCount) {
            Preconditions.checkState((this.outputType != null ? 1 : 0) != 0, (Object)"This stream reader doesn't produce output");
            return StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount);
        }

        @Override
        public BlockLease getBlockView(int[] positions, int positionCount) {
            Preconditions.checkState((this.outputType != null ? 1 : 0) != 0, (Object)"This stream reader doesn't produce output");
            return ClosingBlockLease.newLease((Block)StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount), (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[0]);
        }

        @Override
        public void throwAnyError(int[] positions, int positionCount) {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
        }

        @Override
        public void close() {
        }

        @Override
        public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        }

        @Override
        public void startRowGroup(InputStreamSources dataStreamSources) {
        }

        @Override
        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputPositions);
        }
    }
}

