/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.MapDirectSelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class MapSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final MapDirectSelectiveStreamReader directReader;
    private SelectiveStreamReader currentReader;

    public MapSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> requiredSubfields, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryContext) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.directReader = new MapDirectSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, outputType, hiveStorageTimeZone, systemMemoryContext);
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncoding(this.streamDescriptor.getSequence()).getColumnEncodingKind();
        if (kind != ColumnEncoding.ColumnEncodingKind.DIRECT && kind != ColumnEncoding.ColumnEncodingKind.DIRECT_V2 && kind != ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            if (kind == ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT) {
                throw new IllegalArgumentException("Flat map encoding is not supported yet");
            }
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
        }
        this.currentReader = this.directReader;
        this.currentReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.directReader.getRetainedSizeInBytes();
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        return this.currentReader.read(offset, positions, positionCount);
    }

    @Override
    public int[] getReadPositions() {
        return this.currentReader.getReadPositions();
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        return this.currentReader.getBlock(positions, positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        return this.currentReader.getBlockView(positions, positionCount);
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
        this.currentReader.throwAnyError(positions, positionCount);
    }

    @Override
    public void close() {
        this.currentReader.close();
    }
}

