/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.block.ClosingBlockLease;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class MapDirectSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapDirectSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final boolean nullsAllowed;
    private final boolean nonNullsAllowed;
    private final boolean outputRequired;
    @Nullable
    private final MapType outputType;
    private final SelectiveStreamReader keyReader;
    private final SelectiveStreamReader valueReader;
    private final LocalMemoryContext systemMemoryContext;
    private int readOffset;
    private int nestedReadOffset;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;
    @Nullable
    private int[] offsets;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private int[] nestedLengths;
    private int[] nestedOffsets;
    private int[] nestedPositions;
    private int[] nestedOutputPositions;
    private int nestedOutputPositionCount;
    private boolean valuesInUse;

    public MapDirectSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> requiredSubfields, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryContext) {
        Preconditions.checkArgument((boolean)filters.keySet().stream().map(Subfield::getPath).allMatch(List::isEmpty), (Object)"filters on nested columns are not supported yet");
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null").newLocalMemoryContext(MapDirectSelectiveStreamReader.class.getSimpleName());
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.map(MapType.class::cast).orElse(null);
        TupleDomainFilter filter = MapDirectSelectiveStreamReader.getTopLevelFilter(filters).orElse(null);
        this.nullsAllowed = filter == null || filter.testNull();
        this.nonNullsAllowed = filter == null || filter.testNonNull();
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        Optional<Type> keyOutputType = outputType.map(MapType.class::cast).map(MapType::getKeyType);
        Optional<Type> valueOutputType = outputType.map(MapType.class::cast).map(MapType::getValueType);
        Map keyFilter = (Map)MapDirectSelectiveStreamReader.makeKeyFilter(nestedStreams.get(0).getStreamType(), requiredSubfields).map(f -> ImmutableMap.of((Object)new Subfield("c"), (Object)f)).orElse(ImmutableMap.of());
        this.keyReader = SelectiveStreamReaders.createStreamReader(nestedStreams.get(0), keyFilter, keyOutputType, (List<Subfield>)ImmutableList.of(), hiveStorageTimeZone, systemMemoryContext.newAggregatedMemoryContext());
        this.valueReader = SelectiveStreamReaders.createStreamReader(nestedStreams.get(1), (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), valueOutputType, (List<Subfield>)ImmutableList.of(), hiveStorageTimeZone, systemMemoryContext.newAggregatedMemoryContext());
    }

    private static Optional<TupleDomainFilter> makeKeyFilter(OrcType.OrcTypeKind orcType, List<Subfield> requiredSubfields) {
        if (requiredSubfields.isEmpty()) {
            return Optional.empty();
        }
        switch (orcType) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                long[] requiredIndices = requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.LongSubscript.class::cast).mapToLong(Subfield.LongSubscript::getIndex).toArray();
                if (requiredIndices.length == 0) {
                    return Optional.empty();
                }
                if (requiredIndices.length == 1) {
                    return Optional.of(TupleDomainFilter.BigintRange.of(requiredIndices[0], requiredIndices[0], false));
                }
                return Optional.of(TupleDomainFilter.BigintValues.of(requiredIndices, false));
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                byte[][] requiredIndices = (byte[][])requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.StringSubscript.class::cast).map(Subfield.StringSubscript::getIndex).map(String::getBytes).toArray(x$0 -> new byte[x$0][]);
                if (requiredIndices.length == 0) {
                    return Optional.empty();
                }
                if (requiredIndices.length == 1) {
                    return Optional.of(TupleDomainFilter.BytesRange.of(requiredIndices[0], false, requiredIndices[0], false, false));
                }
                return Optional.of(TupleDomainFilter.BytesValues.of(requiredIndices, false));
            }
        }
        return Optional.empty();
    }

    private static Optional<TupleDomainFilter> getTopLevelFilter(Map<Subfield, TupleDomainFilter> filters) {
        Map topLevelFilters = Maps.filterEntries(filters, entry -> ((Subfield)entry.getKey()).getPath().isEmpty());
        if (topLevelFilters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((topLevelFilters.size() == 1 ? 1 : 0) != 0, (Object)"MAP column may have at most one top-level range filter");
        TupleDomainFilter filter = (TupleDomainFilter)Iterables.getOnlyElement(topLevelFilters.values());
        Preconditions.checkArgument((filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL ? 1 : 0) != 0, (Object)"Top-level range filter on MAP column must be IS NULL or IS NOT NULL");
        return Optional.of(filter);
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        this.outputPositions = !this.nullsAllowed || !this.nonNullsAllowed ? Arrays.ensureCapacity((int[])this.outputPositions, (int)positionCount) : positions;
        this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(positionCount + 1));
        this.offsets[0] = 0;
        this.nestedLengths = Arrays.ensureCapacity((int[])this.nestedLengths, (int)positionCount);
        this.nestedOffsets = Arrays.ensureCapacity((int[])this.nestedOffsets, (int)(positionCount + 1));
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.presentStream == null) {
            this.readNoNulls(offset, positions, positionCount);
        } else {
            this.readWithNulls(offset, positions, positionCount);
        }
        return this.outputPositionCount;
    }

    private void readNoNulls(int offset, int[] positions, int positionCount) throws IOException {
        if (!this.nonNullsAllowed) {
            this.outputPositionCount = 0;
            return;
        }
        if (this.readOffset < offset) {
            this.nestedReadOffset = (int)((long)this.nestedReadOffset + this.lengthStream.sum(offset - this.readOffset));
        }
        int streamPosition = 0;
        int nestedOffset = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                nestedOffset = (int)((long)nestedOffset + this.lengthStream.sum(position - streamPosition));
                streamPosition = position;
            }
            ++streamPosition;
            int length = Math.toIntExact(this.lengthStream.next());
            this.offsets[i + 1] = this.offsets[i] + length;
            this.nestedLengths[i] = length;
            this.nestedOffsets[i] = nestedOffset;
            nestedOffset += length;
        }
        this.nestedOffsets[positionCount] = nestedOffset;
        int nestedPositionCount = this.populateNestedPositions(positionCount, nestedOffset);
        this.outputPositions = positions;
        this.outputPositionCount = positionCount;
        this.readOffset = offset + streamPosition;
        this.readKeyValueStreams(nestedPositionCount);
        this.nestedReadOffset += nestedOffset;
    }

    private void readWithNulls(int offset, int[] positions, int positionCount) throws IOException {
        if (this.readOffset < offset) {
            int dataToSkip = this.presentStream.countBitsSet(offset - this.readOffset);
            this.nestedReadOffset = (int)((long)this.nestedReadOffset + this.lengthStream.sum(dataToSkip));
        }
        this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)positionCount);
        this.outputPositionCount = 0;
        int streamPosition = 0;
        int nonNullPositionCount = 0;
        int nestedOffset = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                int dataToSkip = this.presentStream.countBitsSet(position - streamPosition);
                nestedOffset = (int)((long)nestedOffset + this.lengthStream.sum(dataToSkip));
                streamPosition = position;
            }
            ++streamPosition;
            if (this.presentStream.nextBit()) {
                int length = Math.toIntExact(this.lengthStream.next());
                if (this.nonNullsAllowed) {
                    this.nulls[this.outputPositionCount] = false;
                    this.offsets[this.outputPositionCount + 1] = this.offsets[this.outputPositionCount] + length;
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                    this.nestedLengths[nonNullPositionCount] = length;
                    this.nestedOffsets[nonNullPositionCount] = nestedOffset;
                    ++nonNullPositionCount;
                }
                nestedOffset += length;
                continue;
            }
            if (!this.nullsAllowed) continue;
            this.nulls[this.outputPositionCount] = true;
            this.offsets[this.outputPositionCount + 1] = this.offsets[this.outputPositionCount];
            this.outputPositions[this.outputPositionCount] = position;
            ++this.outputPositionCount;
        }
        this.nestedOffsets[nonNullPositionCount] = nestedOffset;
        int nestedPositionCount = this.populateNestedPositions(nonNullPositionCount, nestedOffset);
        if (nestedPositionCount > 0) {
            this.readKeyValueStreams(nestedPositionCount);
        } else {
            this.allNulls = true;
        }
        this.readOffset = offset + streamPosition;
        this.nestedReadOffset += nestedOffset;
    }

    private int populateNestedPositions(int positionCount, int nestedOffset) {
        this.nestedPositions = Arrays.ensureCapacity((int[])this.nestedPositions, (int)nestedOffset);
        int nestedPositionCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            for (int j = 0; j < this.nestedLengths[i]; ++j) {
                this.nestedPositions[nestedPositionCount++] = this.nestedOffsets[i] + j;
            }
        }
        return nestedPositionCount;
    }

    private void readKeyValueStreams(int positionCount) throws IOException {
        int readCount = this.keyReader.read(this.nestedReadOffset, this.nestedPositions, positionCount);
        int[] readPositions = this.keyReader.getReadPositions();
        if (readCount == 0) {
            this.nestedOutputPositionCount = 0;
            return;
        }
        if (readCount < positionCount) {
            int positionIndex = 0;
            int nextPosition = readPositions[positionIndex];
            int offset = 0;
            int previousOffset = 0;
            for (int i = 0; i < this.outputPositionCount; ++i) {
                int j;
                int length = 0;
                for (j = previousOffset; j < this.offsets[i + 1]; ++j) {
                    if (j != nextPosition) continue;
                    ++length;
                    if (++positionIndex >= readCount) break;
                    nextPosition = readPositions[positionIndex];
                }
                previousOffset = this.offsets[i + 1];
                this.offsets[i + 1] = offset += length;
                if (positionIndex < readCount) continue;
                for (j = i + 1; j < this.outputPositionCount; ++j) {
                    this.offsets[j + 1] = offset;
                }
                break;
            }
        }
        int valueReadCount = this.valueReader.read(this.nestedReadOffset, readPositions, readCount);
        assert (valueReadCount == readCount);
        this.nestedOutputPositions = Arrays.ensureCapacity((int[])this.nestedOutputPositions, (int)readCount);
        System.arraycopy(readPositions, 0, this.nestedOutputPositions, 0, readCount);
        this.nestedOutputPositionCount = readCount;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return MapDirectSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (this.outputPositionCount == positionCount) {
            Block keyBlock = this.keyReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
            Block valueBlock = this.valueReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
            Block block = this.outputType.createBlockFromKeyValue(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.offsets, keyBlock, valueBlock);
            this.nulls = null;
            this.offsets = null;
            return block;
        }
        int[] offsetsCopy = new int[positionCount + 1];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedSkipped = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                nestedSkipped += this.offsets[i + 1] - this.offsets[i];
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            offsetsCopy[positionIndex + 1] = this.offsets[i + 1] - nestedSkipped;
            for (int j = offsetsCopy[positionIndex]; j < offsetsCopy[positionIndex + 1]; ++j) {
                this.nestedOutputPositions[this.nestedOutputPositionCount] = this.nestedOutputPositions[this.nestedOutputPositionCount + nestedSkipped];
                ++this.nestedOutputPositionCount;
            }
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        if (this.nestedOutputPositionCount == 0) {
            return MapDirectSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount);
        }
        Block keyBlock = this.keyReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
        Block valueBlock = this.valueReader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
        return this.outputType.createBlockFromKeyValue(positionCount, Optional.ofNullable((boolean[])(includeNulls ? nullsCopy : null)), offsetsCopy, keyBlock, valueBlock);
    }

    private static RunLengthEncodedBlock createNullBlock(Type type, int positionCount) {
        return new RunLengthEncodedBlock(type.createBlockBuilder(null, 1).appendNull().build(), positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)MapDirectSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount), new BlockLease[0]);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
            if (this.nestedOutputPositionCount == 0) {
                this.allNulls = true;
                return this.newLease((Block)MapDirectSelectiveStreamReader.createNullBlock((Type)this.outputType, positionCount), new BlockLease[0]);
            }
        }
        BlockLease keyBlockLease = this.keyReader.getBlockView(this.nestedOutputPositions, this.nestedOutputPositionCount);
        BlockLease valueBlockLease = this.valueReader.getBlockView(this.nestedOutputPositions, this.nestedOutputPositionCount);
        return this.newLease(this.outputType.createBlockFromKeyValue(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.offsets, (Block)keyBlockLease.get(), (Block)valueBlockLease.get()), keyBlockLease, valueBlockLease);
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedSkipped = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                nestedSkipped += this.offsets[i + 1] - this.offsets[i];
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            this.offsets[positionIndex + 1] = this.offsets[i + 1] - nestedSkipped;
            for (int j = this.offsets[positionIndex]; j < this.offsets[positionIndex + 1]; ++j) {
                this.nestedOutputPositions[this.nestedOutputPositionCount] = this.nestedOutputPositions[this.nestedOutputPositionCount + nestedSkipped];
                ++this.nestedOutputPositionCount;
            }
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    private BlockLease newLease(Block block, BlockLease ... fieldBlockLeases) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            for (BlockLease lease : fieldBlockLeases) {
                lease.close();
            }
            this.valuesInUse = false;
        }});
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyReader.startStripe(dictionaryStreamSources, encoding);
        this.valueReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyReader.startRowGroup(dataStreamSources);
        this.valueReader.startRowGroup(dataStreamSources);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.nestedLengths) + SizeOf.sizeOf((int[])this.nestedOffsets) + SizeOf.sizeOf((int[])this.nestedPositions) + SizeOf.sizeOf((int[])this.nestedOutputPositions) + this.keyReader.getRetainedSizeInBytes() + this.valueReader.getRetainedSizeInBytes();
    }
}

