/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.reader.ListFilter;
import com.facebook.presto.spi.Subfield;
import java.util.Map;

public interface HierarchicalFilter {
    public HierarchicalFilter getChild();

    public TupleDomainFilter.NullsFilter getNullsFilter();

    public TupleDomainFilter.PositionalFilter getPositionalFilter();

    public int[] getTopLevelOffsets();

    public int getTopLevelOffsetCount();

    public long[] getElementFilters();

    public boolean[] getTopLevelFailed();

    public boolean[] getTopLevelIndexOutOfBounds();

    public long getRetainedSizeInBytes();

    public static HierarchicalFilter createHierarchicalFilter(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> subfieldFilters, int level, HierarchicalFilter parent) {
        switch (streamDescriptor.getStreamType()) {
            case LIST: {
                return new ListFilter(streamDescriptor, subfieldFilters, level, parent);
            }
            case MAP: 
            case STRUCT: {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }
}

