/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

final class ApacheHiveTimestampDecoder {
    private ApacheHiveTimestampDecoder() {
    }

    public static long decodeTimestamp(long seconds, long serializedNanos, long baseTimestampInSeconds) {
        long millis = (seconds + baseTimestampInSeconds) * 1000L;
        long nanos = ApacheHiveTimestampDecoder.parseNanos(serializedNanos);
        if (nanos > 999999999L || nanos < 0L) {
            throw new IllegalArgumentException("nanos field of an encoded timestamp in ORC must be between 0 and 999999999 inclusive, got " + nanos);
        }
        if (millis < 0L && nanos != 0L) {
            millis -= 1000L;
        }
        return millis + nanos / 1000000L;
    }

    private static int parseNanos(long serialized) {
        int zeros = (int)serialized & 7;
        int result = (int)(serialized >>> 3);
        if (zeros != 0) {
            for (int i = 0; i <= zeros; ++i) {
                result *= 10;
            }
        }
        return result;
    }
}

