/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class Stream {
    private final int column;
    private final StreamKind streamKind;
    private final int length;
    private final boolean useVInts;
    private final int sequence;

    public Stream(int column, StreamKind streamKind, int length, boolean useVInts) {
        this(column, streamKind, length, useVInts, 0);
    }

    public Stream(int column, StreamKind streamKind, int length, boolean useVInts, int sequence) {
        this.column = column;
        this.streamKind = Objects.requireNonNull(streamKind, "streamKind is null");
        this.length = length;
        this.useVInts = useVInts;
        this.sequence = sequence;
    }

    public int getColumn() {
        return this.column;
    }

    public StreamKind getStreamKind() {
        return this.streamKind;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUseVInts() {
        return this.useVInts;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("streamKind", (Object)this.streamKind).add("length", this.length).add("useVInts", this.useVInts).add("sequence", this.sequence).toString();
    }

    public static enum StreamKind {
        PRESENT,
        DATA,
        LENGTH,
        DICTIONARY_DATA,
        DICTIONARY_COUNT,
        SECONDARY,
        ROW_INDEX,
        BLOOM_FILTER,
        BLOOM_FILTER_UTF8,
        IN_DICTIONARY,
        ROW_GROUP_DICTIONARY,
        ROW_GROUP_DICTIONARY_LENGTH,
        IN_MAP;

    }
}

