/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.checkpoint.Checkpoints;
import com.facebook.presto.orc.checkpoint.InvalidCheckpointException;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.stream.CheckpointInputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.facebook.presto.orc.stream.ValueInputStreamSource;
import com.facebook.presto.orc.stream.ValueStreams;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;

public class StripeReader {
    private final OrcDataSource orcDataSource;
    private final Optional<OrcDecompressor> decompressor;
    private final List<OrcType> types;
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final Set<Integer> includedOrcColumns;
    private final int rowsInRowGroup;
    private final OrcPredicate predicate;
    private final MetadataReader metadataReader;
    private final Optional<OrcWriteValidation> writeValidation;

    public StripeReader(OrcDataSource orcDataSource, Optional<OrcDecompressor> decompressor, List<OrcType> types, Set<Integer> includedColumns, int rowsInRowGroup, OrcPredicate predicate, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, Optional<OrcWriteValidation> writeValidation) {
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.includedOrcColumns = StripeReader.getIncludedOrcColumns(types, Objects.requireNonNull(includedColumns, "includedColumns is null"));
        this.rowsInRowGroup = rowsInRowGroup;
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.hiveWriterVersion = Objects.requireNonNull(hiveWriterVersion, "hiveWriterVersion is null");
        this.metadataReader = Objects.requireNonNull(metadataReader, "metadataReader is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
    }

    public Stripe readStripe(StripeInformation stripe, AggregatedMemoryContext systemMemoryUsage) throws IOException {
        InputStreamSources dictionaryStreamSources;
        Map<StreamId, ValueInputStream<?>> valueStreams;
        StripeFooter stripeFooter = this.readStripeFooter(stripe, systemMemoryUsage);
        List<ColumnEncoding> columnEncodings = stripeFooter.getColumnEncodings();
        HashMap<StreamId, Stream> streams = new HashMap<StreamId, Stream>();
        boolean hasRowGroupDictionary = false;
        for (Stream stream : stripeFooter.getStreams()) {
            Optional<SortedMap<Integer, DwrfSequenceEncoding>> additionalSequenceEncodings;
            if (!this.includedOrcColumns.contains(stream.getColumn())) continue;
            streams.put(new StreamId(stream), stream);
            if (stream.getStreamKind() != Stream.StreamKind.IN_DICTIONARY) continue;
            ColumnEncoding columnEncoding = columnEncodings.get(stream.getColumn());
            if (columnEncoding.getColumnEncodingKind() == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
                hasRowGroupDictionary = true;
            }
            if (!(additionalSequenceEncodings = columnEncoding.getAdditionalSequenceEncodings()).isPresent() || !additionalSequenceEncodings.get().values().stream().map(DwrfSequenceEncoding::getValueEncoding).anyMatch(encoding -> encoding.getColumnEncodingKind() == ColumnEncoding.ColumnEncodingKind.DICTIONARY)) continue;
            hasRowGroupDictionary = true;
        }
        boolean invalidCheckPoint = false;
        if (stripe.getNumberOfRows() > this.rowsInRowGroup || hasRowGroupDictionary) {
            Set<Integer> selectedRowGroups;
            Map diskRanges = StripeReader.getDiskRanges(stripeFooter.getStreams());
            diskRanges = Maps.filterKeys(diskRanges, (Predicate)Predicates.in(streams.keySet()));
            Map<StreamId, OrcInputStream> streamsData = this.readDiskRanges(stripe.getOffset(), diskRanges, systemMemoryUsage);
            Map<StreamId, List<HiveBloomFilter>> bloomFilterIndexes = this.readBloomFilterIndexes(streams, streamsData);
            Map<StreamId, List<RowGroupIndex>> columnIndexes = this.readColumnIndexes(streams, streamsData, bloomFilterIndexes);
            if (this.writeValidation.isPresent()) {
                this.writeValidation.get().validateRowGroupStatistics(this.orcDataSource.getId(), stripe.getOffset(), columnIndexes);
            }
            if ((selectedRowGroups = this.selectRowGroups(stripe, columnIndexes)).isEmpty()) {
                systemMemoryUsage.close();
                return null;
            }
            valueStreams = this.createValueStreams(streams, streamsData, columnEncodings);
            dictionaryStreamSources = this.createDictionaryStreamSources(streams, valueStreams, columnEncodings);
            try {
                List<RowGroup> rowGroups = this.createRowGroups(stripe.getNumberOfRows(), streams, valueStreams, columnIndexes, selectedRowGroups, columnEncodings);
                return new Stripe(stripe.getNumberOfRows(), columnEncodings, rowGroups, dictionaryStreamSources);
            }
            catch (InvalidCheckpointException e) {
                if (hasRowGroupDictionary) {
                    throw new OrcCorruptionException(e, this.orcDataSource.getId(), "Checkpoints are corrupt", new Object[0]);
                }
                invalidCheckPoint = true;
            }
        }
        ImmutableMap.Builder diskRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, DiskRange> entry : StripeReader.getDiskRanges(stripeFooter.getStreams()).entrySet()) {
            StreamId streamId = entry.getKey();
            if (!streams.keySet().contains(streamId)) continue;
            diskRangesBuilder.put(entry);
        }
        ImmutableMap diskRanges = diskRangesBuilder.build();
        Map<StreamId, OrcInputStream> streamsData = this.readDiskRanges(stripe.getOffset(), (Map<StreamId, DiskRange>)diskRanges, systemMemoryUsage);
        long minAverageRowBytes = 0L;
        for (Map.Entry entry : streams.entrySet()) {
            if (((StreamId)entry.getKey()).getStreamKind() != Stream.StreamKind.ROW_INDEX) continue;
            List<RowGroupIndex> rowGroupIndexes = this.metadataReader.readRowIndexes(this.hiveWriterVersion, streamsData.get(entry.getKey()));
            Preconditions.checkState((rowGroupIndexes.size() == 1 || invalidCheckPoint ? 1 : 0) != 0, (Object)"expect a single row group or an invalid check point");
            long totalBytes = 0L;
            long totalRows = 0L;
            for (RowGroupIndex rowGroupIndex : rowGroupIndexes) {
                ColumnStatistics columnStatistics = rowGroupIndex.getColumnStatistics();
                if (!columnStatistics.hasMinAverageValueSizeInBytes()) continue;
                totalBytes += columnStatistics.getMinAverageValueSizeInBytes() * columnStatistics.getNumberOfValues();
                totalRows += columnStatistics.getNumberOfValues();
            }
            if (totalRows <= 0L) continue;
            minAverageRowBytes += totalBytes / totalRows;
        }
        valueStreams = this.createValueStreams(streams, streamsData, columnEncodings);
        dictionaryStreamSources = this.createDictionaryStreamSources(streams, valueStreams, columnEncodings);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<StreamId, ValueInputStream<?>> entry : valueStreams.entrySet()) {
            builder.put((Object)entry.getKey(), new ValueInputStreamSource(entry.getValue()));
        }
        RowGroup rowGroup = new RowGroup(0, 0L, stripe.getNumberOfRows(), minAverageRowBytes, new InputStreamSources((Map<StreamId, InputStreamSource<?>>)builder.build()));
        return new Stripe(stripe.getNumberOfRows(), columnEncodings, (List<RowGroup>)ImmutableList.of((Object)rowGroup), dictionaryStreamSources);
    }

    public Map<StreamId, OrcInputStream> readDiskRanges(long stripeOffset, Map<StreamId, DiskRange> diskRanges, AggregatedMemoryContext systemMemoryUsage) throws IOException {
        ImmutableMap.Builder diskRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            diskRangesBuilder.put((Object)entry.getKey(), (Object)new DiskRange(stripeOffset + diskRange.getOffset(), diskRange.getLength()));
        }
        diskRanges = diskRangesBuilder.build();
        Map streamsData = this.orcDataSource.readFully(diskRanges);
        ImmutableMap.Builder streamsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : streamsData.entrySet()) {
            OrcDataSourceInput sourceInput = entry.getValue();
            streamsBuilder.put(entry.getKey(), (Object)new OrcInputStream(this.orcDataSource.getId(), sourceInput.getInput(), this.decompressor, systemMemoryUsage, sourceInput.getRetainedSizeInBytes()));
        }
        return streamsBuilder.build();
    }

    private Map<StreamId, ValueInputStream<?>> createValueStreams(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData, List<ColumnEncoding> columnEncodings) {
        ImmutableMap.Builder valueStreams = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            StreamId streamId = entry.getKey();
            Stream stream = entry.getValue();
            ColumnEncoding.ColumnEncodingKind columnEncoding = columnEncodings.get(stream.getColumn()).getColumnEncoding(stream.getSequence()).getColumnEncodingKind();
            if (StripeReader.isIndexStream(stream) || stream.getLength() == 0) continue;
            OrcInputStream inputStream = streamsData.get(streamId);
            OrcType.OrcTypeKind columnType = this.types.get(stream.getColumn()).getOrcTypeKind();
            valueStreams.put((Object)streamId, ValueStreams.createValueStreams(streamId, inputStream, columnType, columnEncoding, stream.isUseVInts()));
        }
        return valueStreams.build();
    }

    public InputStreamSources createDictionaryStreamSources(Map<StreamId, Stream> streams, Map<StreamId, ValueInputStream<?>> valueStreams, List<ColumnEncoding> columnEncodings) {
        ImmutableMap.Builder dictionaryStreamBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            ValueInputStream<?> valueStream;
            int column;
            ColumnEncoding.ColumnEncodingKind columnEncoding;
            StreamId streamId = entry.getKey();
            Stream stream = entry.getValue();
            if (!StripeReader.isDictionary(stream, columnEncoding = columnEncodings.get(column = stream.getColumn()).getColumnEncoding(stream.getSequence()).getColumnEncodingKind()) || (valueStream = valueStreams.get(streamId)) == null) continue;
            OrcType.OrcTypeKind columnType = this.types.get(stream.getColumn()).getOrcTypeKind();
            StreamCheckpoint streamCheckpoint = Checkpoints.getDictionaryStreamCheckpoint(streamId, columnType, columnEncoding);
            CheckpointInputStreamSource streamSource = CheckpointInputStreamSource.createCheckpointStreamSource(valueStream, streamCheckpoint);
            dictionaryStreamBuilder.put((Object)streamId, streamSource);
        }
        return new InputStreamSources((Map<StreamId, InputStreamSource<?>>)dictionaryStreamBuilder.build());
    }

    private List<RowGroup> createRowGroups(int rowsInStripe, Map<StreamId, Stream> streams, Map<StreamId, ValueInputStream<?>> valueStreams, Map<StreamId, List<RowGroupIndex>> columnIndexes, Set<Integer> selectedRowGroups, List<ColumnEncoding> encodings) throws InvalidCheckpointException {
        ImmutableList.Builder rowGroupBuilder = ImmutableList.builder();
        for (int rowGroupId : selectedRowGroups) {
            Map<StreamId, StreamCheckpoint> checkpoints = Checkpoints.getStreamCheckpoints(this.includedOrcColumns, this.types, this.decompressor.isPresent(), rowGroupId, encodings, streams, columnIndexes);
            int rowOffset = rowGroupId * this.rowsInRowGroup;
            int rowsInGroup = Math.min(rowsInStripe - rowOffset, this.rowsInRowGroup);
            long minAverageRowBytes = columnIndexes.entrySet().stream().mapToLong(e -> ((RowGroupIndex)((List)e.getValue()).get(rowGroupId)).getColumnStatistics().getMinAverageValueSizeInBytes()).sum();
            rowGroupBuilder.add((Object)StripeReader.createRowGroup(rowGroupId, rowOffset, rowsInGroup, minAverageRowBytes, valueStreams, checkpoints));
        }
        return rowGroupBuilder.build();
    }

    public static RowGroup createRowGroup(int groupId, int rowOffset, int rowCount, long minAverageRowBytes, Map<StreamId, ValueInputStream<?>> valueStreams, Map<StreamId, StreamCheckpoint> checkpoints) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<StreamId, StreamCheckpoint> entry : checkpoints.entrySet()) {
            StreamId streamId = entry.getKey();
            StreamCheckpoint checkpoint = entry.getValue();
            ValueInputStream<?> valueStream = valueStreams.get(streamId);
            if (valueStream == null) continue;
            builder.put((Object)streamId, CheckpointInputStreamSource.createCheckpointStreamSource(valueStream, checkpoint));
        }
        InputStreamSources rowGroupStreams = new InputStreamSources((Map<StreamId, InputStreamSource<?>>)builder.build());
        return new RowGroup(groupId, rowOffset, rowCount, minAverageRowBytes, rowGroupStreams);
    }

    public StripeFooter readStripeFooter(StripeInformation stripe, AggregatedMemoryContext systemMemoryUsage) throws IOException {
        long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int tailLength = Math.toIntExact(stripe.getFooterLength());
        byte[] tailBuffer = new byte[tailLength];
        this.orcDataSource.readFully(offset, tailBuffer);
        try (OrcInputStream inputStream = new OrcInputStream(this.orcDataSource.getId(), (FixedLengthSliceInput)Slices.wrappedBuffer((byte[])tailBuffer).getInput(), this.decompressor, systemMemoryUsage, tailLength);){
            StripeFooter stripeFooter = this.metadataReader.readStripeFooter(this.types, inputStream);
            return stripeFooter;
        }
    }

    static boolean isIndexStream(Stream stream) {
        return stream.getStreamKind() == Stream.StreamKind.ROW_INDEX || stream.getStreamKind() == Stream.StreamKind.DICTIONARY_COUNT || stream.getStreamKind() == Stream.StreamKind.BLOOM_FILTER || stream.getStreamKind() == Stream.StreamKind.BLOOM_FILTER_UTF8;
    }

    private Map<StreamId, List<HiveBloomFilter>> readBloomFilterIndexes(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData) throws IOException {
        ImmutableMap.Builder bloomFilters = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            Stream stream = entry.getValue();
            if (stream.getStreamKind() != Stream.StreamKind.BLOOM_FILTER) continue;
            OrcInputStream inputStream = streamsData.get(entry.getKey());
            bloomFilters.put((Object)entry.getKey(), this.metadataReader.readBloomFilterIndexes(inputStream));
        }
        return bloomFilters.build();
    }

    private Map<StreamId, List<RowGroupIndex>> readColumnIndexes(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData, Map<StreamId, List<HiveBloomFilter>> bloomFilterIndexes) throws IOException {
        ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            Stream stream = entry.getValue();
            if (stream.getStreamKind() != Stream.StreamKind.ROW_INDEX) continue;
            OrcInputStream inputStream = streamsData.get(entry.getKey());
            List<HiveBloomFilter> bloomFilters = bloomFilterIndexes.get(entry.getKey());
            ImmutableList rowGroupIndexes = this.metadataReader.readRowIndexes(this.hiveWriterVersion, inputStream);
            if (bloomFilters != null && !bloomFilters.isEmpty()) {
                ImmutableList.Builder newRowGroupIndexes = ImmutableList.builder();
                for (int i = 0; i < rowGroupIndexes.size(); ++i) {
                    RowGroupIndex rowGroupIndex = rowGroupIndexes.get(i);
                    ColumnStatistics columnStatistics = rowGroupIndex.getColumnStatistics().withBloomFilter(bloomFilters.get(i));
                    newRowGroupIndexes.add((Object)new RowGroupIndex(rowGroupIndex.getPositions(), columnStatistics));
                }
                rowGroupIndexes = newRowGroupIndexes.build();
            }
            columnIndexes.put((Object)entry.getKey(), rowGroupIndexes);
        }
        return columnIndexes.build();
    }

    private Set<Integer> selectRowGroups(StripeInformation stripe, Map<StreamId, List<RowGroupIndex>> columnIndexes) {
        int rowsInStripe = Math.toIntExact(stripe.getNumberOfRows());
        int groupsInStripe = StripeReader.ceil(rowsInStripe, this.rowsInRowGroup);
        ImmutableSet.Builder selectedRowGroups = ImmutableSet.builder();
        int remainingRows = rowsInStripe;
        for (int rowGroup = 0; rowGroup < groupsInStripe; ++rowGroup) {
            Map<Integer, ColumnStatistics> statistics;
            int rows = Math.min(remainingRows, this.rowsInRowGroup);
            if (this.predicate.matches(rows, statistics = StripeReader.getRowGroupStatistics(this.types.get(0), columnIndexes, rowGroup))) {
                selectedRowGroups.add((Object)rowGroup);
            }
            remainingRows -= rows;
        }
        return selectedRowGroups.build();
    }

    private static Map<Integer, ColumnStatistics> getRowGroupStatistics(OrcType rootStructType, Map<StreamId, List<RowGroupIndex>> columnIndexes, int rowGroup) {
        Objects.requireNonNull(rootStructType, "rootStructType is null");
        Preconditions.checkArgument((rootStructType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT ? 1 : 0) != 0);
        Objects.requireNonNull(columnIndexes, "columnIndexes is null");
        Preconditions.checkArgument((rowGroup >= 0 ? 1 : 0) != 0, (Object)"rowGroup is negative");
        HashMap<Integer, List> groupedColumnStatistics = new HashMap<Integer, List>();
        for (Map.Entry<StreamId, List<RowGroupIndex>> entry : columnIndexes.entrySet()) {
            groupedColumnStatistics.computeIfAbsent(entry.getKey().getColumn(), key -> new ArrayList()).add(entry.getValue().get(rowGroup).getColumnStatistics());
        }
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < rootStructType.getFieldCount(); ++ordinal) {
            List columnStatistics = (List)groupedColumnStatistics.get(rootStructType.getFieldTypeIndex(ordinal));
            if (columnStatistics == null) continue;
            if (columnStatistics.size() == 1) {
                statistics.put((Object)ordinal, Iterables.getOnlyElement((Iterable)columnStatistics));
                continue;
            }
            statistics.put((Object)ordinal, (Object)ColumnStatistics.mergeColumnStatistics(columnStatistics));
        }
        return statistics.build();
    }

    private static boolean isDictionary(Stream stream, ColumnEncoding.ColumnEncodingKind columnEncoding) {
        return stream.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA || stream.getStreamKind() == Stream.StreamKind.LENGTH && (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY || columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2);
    }

    private static Map<StreamId, DiskRange> getDiskRanges(List<Stream> streams) {
        ImmutableMap.Builder streamDiskRanges = ImmutableMap.builder();
        long stripeOffset = 0L;
        for (Stream stream : streams) {
            int streamLength = Math.toIntExact(stream.getLength());
            if (streamLength > 0) {
                streamDiskRanges.put((Object)new StreamId(stream), (Object)new DiskRange(stripeOffset, streamLength));
            }
            stripeOffset += (long)streamLength;
        }
        return streamDiskRanges.build();
    }

    private static Set<Integer> getIncludedOrcColumns(List<OrcType> types, Set<Integer> includedColumns) {
        LinkedHashSet<Integer> includes = new LinkedHashSet<Integer>();
        OrcType root = types.get(0);
        for (int includedColumn : includedColumns) {
            StripeReader.includeOrcColumnsRecursive(types, includes, root.getFieldTypeIndex(includedColumn));
        }
        return includes;
    }

    private static void includeOrcColumnsRecursive(List<OrcType> types, Set<Integer> result, int typeId) {
        result.add(typeId);
        OrcType type = types.get(typeId);
        int children = type.getFieldCount();
        for (int i = 0; i < children; ++i) {
            StripeReader.includeOrcColumnsRecursive(types, result, type.getFieldTypeIndex(i));
        }
    }

    private static int ceil(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }
}

