/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.AbstractOrcRecordReader;
import com.facebook.presto.orc.FilterFunction;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;

public class OrcSelectiveRecordReader
extends AbstractOrcRecordReader<SelectiveStreamReader> {
    private final int[] hiveColumnIndices;
    private final List<Integer> outputColumns;
    private final Map<Integer, Type> columnTypes;
    private final Object[] constantValues;
    private final List<FilterFunction> filterFunctions;
    private final Map<Integer, Integer> filterFunctionInputMapping;
    private final Set<Integer> filterFunctionInputs;
    private final Set<Integer> columnsWithFilters;
    private int[] streamReaderOrder;
    private int[] positions;
    private int[] outputPositions;
    private RuntimeException[] errors;

    public OrcSelectiveRecordReader(Map<Integer, Type> includedColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields, Map<Integer, Object> constantValues, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, List<ColumnStatistics> fileStats, List<StripeStatistics> stripeStats, OrcDataSource orcDataSource, long offset, long length, List<OrcType> types, Optional<OrcDecompressor> decompressor, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, PostScript.HiveWriterVersion hiveWriterVersion, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, Map<String, Slice> userMetadata, AggregatedMemoryContext systemMemoryUsage, Optional<OrcWriteValidation> writeValidation, int initialBatchSize) {
        super(includedColumns, (StreamReader[])OrcSelectiveRecordReader.createStreamReaders(orcDataSource, types, hiveStorageTimeZone, includedColumns, outputColumns, filters, filterFunctions, filterFunctionInputMapping, requiredSubfields, systemMemoryUsage.newAggregatedMemoryContext()), predicate, numberOfRows, fileStripes, fileStats, stripeStats, orcDataSource, offset, length, types, decompressor, rowsInRowGroup, hiveStorageTimeZone, hiveWriterVersion, metadataReader, maxMergeDistance, tinyStripeThreshold, maxBlockSize, userMetadata, systemMemoryUsage, writeValidation, initialBatchSize);
        ImmutableList hiveColumnIndices = ImmutableList.copyOf(includedColumns.keySet());
        Map zeroBasedIndices = (Map)IntStream.range(0, hiveColumnIndices.size()).boxed().collect(ImmutableMap.toImmutableMap(((List)hiveColumnIndices)::get, Function.identity()));
        this.hiveColumnIndices = hiveColumnIndices.stream().mapToInt(i -> i).toArray();
        this.outputColumns = (List)outputColumns.stream().map(zeroBasedIndices::get).collect(ImmutableList.toImmutableList());
        this.columnTypes = (Map)includedColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (Integer)zeroBasedIndices.get(entry.getKey()), Map.Entry::getValue));
        this.filterFunctions = filterFunctions;
        this.filterFunctionInputMapping = Maps.transformValues(filterFunctionInputMapping, zeroBasedIndices::get);
        this.filterFunctionInputs = (Set)filterFunctions.stream().flatMapToInt(function -> Arrays.stream(function.getInputChannels())).boxed().map(this.filterFunctionInputMapping::get).collect(ImmutableSet.toImmutableSet());
        this.columnsWithFilters = (Set)filters.keySet().stream().map(zeroBasedIndices::get).collect(ImmutableSet.toImmutableSet());
        Objects.requireNonNull(constantValues, "constantValues is null");
        this.constantValues = new Object[this.hiveColumnIndices.length];
        for (Map.Entry<Integer, Object> entry2 : constantValues.entrySet()) {
            this.constantValues[((Integer)zeroBasedIndices.get((Object)entry2.getKey())).intValue()] = entry2.getValue();
        }
        this.streamReaderOrder = OrcSelectiveRecordReader.orderStreamReaders((Collection)this.columnTypes.keySet().stream().filter(index -> this.constantValues[index] == null).collect(ImmutableSet.toImmutableSet()), this.columnsWithFilters, this.filterFunctionInputs);
    }

    private static int[] orderStreamReaders(Collection<Integer> columnIndices, Set<Integer> columnsWithFilters, Set<Integer> filterFunctionInputs) {
        int[] order = new int[columnIndices.size()];
        int i = 0;
        for (int columnIndex : columnsWithFilters) {
            if (!columnIndices.contains(columnIndex)) continue;
            order[i++] = columnIndex;
        }
        for (int columnIndex : filterFunctionInputs) {
            if (!columnIndices.contains(columnIndex) || columnsWithFilters.contains(columnIndex)) continue;
            order[i++] = columnIndex;
        }
        for (int columnIndex : columnIndices) {
            if (columnsWithFilters.contains(columnIndex) || filterFunctionInputs.contains(columnIndex)) continue;
            order[i++] = columnIndex;
        }
        return order;
    }

    private static SelectiveStreamReader[] createStreamReaders(OrcDataSource orcDataSource, List<OrcType> types, DateTimeZone hiveStorageTimeZone, Map<Integer, Type> includedColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields, AggregatedMemoryContext systemMemoryContext) {
        List<StreamDescriptor> streamDescriptors = OrcSelectiveRecordReader.createStreamDescriptor("", "", 0, types, orcDataSource).getNestedStreams();
        Objects.requireNonNull(filterFunctions, "filterFunctions is null");
        Objects.requireNonNull(filterFunctionInputMapping, "filterFunctionInputMapping is null");
        Set filterFunctionInputColumns = (Set)filterFunctions.stream().flatMapToInt(function -> Arrays.stream(function.getInputChannels())).boxed().map(filterFunctionInputMapping::get).collect(ImmutableSet.toImmutableSet());
        OrcType rowType = types.get(0);
        SelectiveStreamReader[] streamReaders = new SelectiveStreamReader[rowType.getFieldCount()];
        for (int columnId = 0; columnId < rowType.getFieldCount(); ++columnId) {
            if (!includedColumns.containsKey(columnId)) continue;
            StreamDescriptor streamDescriptor = streamDescriptors.get(columnId);
            boolean outputRequired = outputColumns.contains(columnId) || filterFunctionInputColumns.contains(columnId);
            streamReaders[columnId] = SelectiveStreamReaders.createStreamReader(streamDescriptor, Optional.ofNullable(filters.get(columnId)).orElse((Map<Subfield, TupleDomainFilter>)ImmutableMap.of()), outputRequired ? Optional.of(includedColumns.get(columnId)) : Optional.empty(), Optional.ofNullable(requiredSubfields.get(columnId)).orElse((List<Subfield>)ImmutableList.of()), hiveStorageTimeZone, systemMemoryContext);
        }
        return streamReaders;
    }

    public Page getNextPage() throws IOException {
        int batchSize = this.prepareNextBatch();
        if (batchSize < 0) {
            return null;
        }
        this.initializePositions(batchSize);
        int[] positionsToRead = this.positions;
        int positionCount = batchSize;
        boolean filterFunctionsApplied = this.filterFunctions.isEmpty();
        for (int columnIndex : this.streamReaderOrder) {
            SelectiveStreamReader streamReader;
            if (!filterFunctionsApplied && !this.hasAnyFilter(columnIndex)) {
                if ((positionCount = this.applyFilterFunctions(positionsToRead, positionCount)) == 0) break;
                positionsToRead = this.outputPositions;
                filterFunctionsApplied = true;
            }
            if ((positionCount = (streamReader = this.getStreamReader(columnIndex)).read(this.getNextRowInGroup(), positionsToRead, positionCount)) == 0) break;
            positionsToRead = streamReader.getReadPositions();
        }
        if (positionCount > 0 && !filterFunctionsApplied) {
            positionCount = this.applyFilterFunctions(positionsToRead, positionCount);
            positionsToRead = this.outputPositions;
        }
        this.batchRead(batchSize);
        if (positionCount == 0) {
            return new Page(0, new Block[0]);
        }
        for (SelectiveStreamReader reader : (SelectiveStreamReader[])this.getStreamReaders()) {
            if (reader == null) continue;
            reader.throwAnyError(positionsToRead, positionCount);
        }
        Block[] blockArray = new Block[this.outputColumns.size()];
        for (int i = 0; i < this.outputColumns.size(); ++i) {
            int columnIndex = this.outputColumns.get(i);
            if (this.constantValues[columnIndex] != null) {
                blockArray[i] = RunLengthEncodedBlock.create((Type)this.columnTypes.get(columnIndex), (Object)this.constantValues[columnIndex], (int)batchSize);
                continue;
            }
            Block block = this.getStreamReader(columnIndex).getBlock(positionsToRead, positionCount);
            this.updateMaxCombinedBytesPerRow(columnIndex, block);
            blockArray[i] = block;
        }
        Page page = new Page(positionCount, blockArray);
        this.validateWritePageChecksum(page);
        return page;
    }

    private SelectiveStreamReader getStreamReader(int columnIndex) {
        return ((SelectiveStreamReader[])this.getStreamReaders())[this.hiveColumnIndices[columnIndex]];
    }

    private boolean hasAnyFilter(int columnIndex) {
        return this.columnsWithFilters.contains(columnIndex) || this.filterFunctionInputs.contains(columnIndex);
    }

    private void initializePositions(int batchSize) {
        if (this.positions == null || this.positions.length < batchSize) {
            this.positions = new int[batchSize];
            for (int i = 0; i < batchSize; ++i) {
                this.positions[i] = i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int applyFilterFunctions(int[] positions, int positionCount) {
        BlockLease[] blockLeases = new BlockLease[this.hiveColumnIndices.length];
        Block[] blocks = new Block[this.hiveColumnIndices.length];
        Iterator<Object> iterator = this.filterFunctionInputs.iterator();
        while (iterator.hasNext()) {
            int columnIndex = iterator.next();
            if (this.constantValues[columnIndex] != null) {
                blocks[columnIndex] = RunLengthEncodedBlock.create((Type)this.columnTypes.get(columnIndex), (Object)this.constantValues[columnIndex], (int)positionCount);
                continue;
            }
            blockLeases[columnIndex] = this.getStreamReader(columnIndex).getBlockView(positions, positionCount);
            blocks[columnIndex] = (Block)blockLeases[columnIndex].get();
        }
        try {
            int i;
            this.initializeOutputPositions(positionCount);
            for (FilterFunction function : this.filterFunctions) {
                int[] inputs = function.getInputChannels();
                Block[] inputBlocks = new Block[inputs.length];
                for (int i2 = 0; i2 < inputs.length; ++i2) {
                    inputBlocks[i2] = blocks[this.filterFunctionInputMapping.get(inputs[i2])];
                }
                Page page = new Page(positionCount, inputBlocks);
                if ((positionCount = function.filter(page, this.outputPositions, positionCount, this.errors)) != 0) continue;
                break;
            }
            for (i = 0; i < positionCount; ++i) {
                if (this.errors[i] == null) continue;
                throw this.errors[i];
            }
            for (i = 0; i < positionCount; ++i) {
                this.outputPositions[i] = positions[this.outputPositions[i]];
            }
            int n = positionCount;
            return n;
        }
        finally {
            for (BlockLease blockLease : blockLeases) {
                if (blockLease == null) continue;
                blockLease.close();
            }
        }
    }

    private void initializeOutputPositions(int positionCount) {
        if (this.outputPositions == null || this.outputPositions.length < positionCount) {
            this.outputPositions = new int[positionCount];
        }
        for (int i = 0; i < positionCount; ++i) {
            this.outputPositions[i] = i;
        }
        if (this.errors == null || this.errors.length < positionCount) {
            this.errors = new RuntimeException[positionCount];
        } else {
            Arrays.fill(this.errors, null);
        }
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            for (SelectiveStreamReader streamReader : (SelectiveStreamReader[])this.getStreamReaders()) {
                if (streamReader == null) continue;
                closer.register(streamReader::close);
            }
        }
        super.close();
    }
}

