/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.checkpoint;

import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.ByteArrayStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.ByteStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.DecimalStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.DoubleStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.FloatStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.InputStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.InvalidCheckpointException;
import com.facebook.presto.orc.checkpoint.LongStreamDwrfCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamV1Checkpoint;
import com.facebook.presto.orc.checkpoint.LongStreamV2Checkpoint;
import com.facebook.presto.orc.checkpoint.RowGroupDictionaryLengthStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Checkpoints {
    private Checkpoints() {
    }

    public static Map<StreamId, StreamCheckpoint> getStreamCheckpoints(Set<Integer> columns, List<OrcType> columnTypes, boolean compressed, int rowGroupId, List<ColumnEncoding> columnEncodings, Map<StreamId, Stream> streams, Map<StreamId, List<RowGroupIndex>> columnIndexes) throws InvalidCheckpointException {
        ImmutableSetMultimap.Builder streamKindsBuilder = ImmutableSetMultimap.builder();
        for (Stream stream : streams.values()) {
            streamKindsBuilder.put((Object)stream.getColumn(), (Object)stream.getStreamKind());
        }
        ImmutableSetMultimap streamKinds = streamKindsBuilder.build();
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        for (Map.Entry<StreamId, List<RowGroupIndex>> entry : columnIndexes.entrySet()) {
            int column = entry.getKey().getColumn();
            if (!columns.contains(column)) continue;
            int sequence = entry.getKey().getSequence();
            List<Integer> positionsList = entry.getValue().get(rowGroupId).getPositions();
            ColumnEncoding.ColumnEncodingKind columnEncoding = columnEncodings.get(column).getColumnEncodingKind();
            OrcType.OrcTypeKind columnType = columnTypes.get(column).getOrcTypeKind();
            Set availableStreams = streamKinds.get((Object)column);
            ColumnPositionsList columnPositionsList = new ColumnPositionsList(column, sequence, columnType, positionsList);
            switch (columnType) {
                case BOOLEAN: {
                    checkpoints.putAll(Checkpoints.getBooleanColumnCheckpoints(column, sequence, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case BYTE: {
                    checkpoints.putAll(Checkpoints.getByteColumnCheckpoints(column, sequence, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: {
                    checkpoints.putAll(Checkpoints.getLongColumnCheckpoints(column, sequence, columnEncoding, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case FLOAT: {
                    checkpoints.putAll(Checkpoints.getFloatColumnCheckpoints(column, sequence, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case DOUBLE: {
                    checkpoints.putAll(Checkpoints.getDoubleColumnCheckpoints(column, sequence, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case TIMESTAMP: {
                    checkpoints.putAll(Checkpoints.getTimestampColumnCheckpoints(column, sequence, columnEncoding, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case BINARY: 
                case STRING: 
                case VARCHAR: 
                case CHAR: {
                    checkpoints.putAll(Checkpoints.getSliceColumnCheckpoints(column, sequence, columnEncoding, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case LIST: 
                case MAP: {
                    checkpoints.putAll(Checkpoints.getListOrMapColumnCheckpoints(column, sequence, columnEncoding, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case STRUCT: {
                    checkpoints.putAll(Checkpoints.getStructColumnCheckpoints(column, sequence, compressed, availableStreams, columnPositionsList));
                    break;
                }
                case DECIMAL: {
                    checkpoints.putAll(Checkpoints.getDecimalColumnCheckpoints(column, sequence, columnEncoding, compressed, availableStreams, columnPositionsList));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported column type " + (Object)((Object)columnType));
                }
            }
            if (!columnPositionsList.hasNextPosition() || Iterables.all(positionsList, (Predicate)Predicates.equalTo((Object)0))) continue;
            throw new InvalidCheckpointException(String.format("Column %s, of type %s, contains %s offset positions, but only %s positions were consumed", new Object[]{column, columnType, positionsList.size(), columnPositionsList.getIndex()}), new Object[0]);
        }
        return checkpoints.build();
    }

    public static StreamCheckpoint getDictionaryStreamCheckpoint(StreamId streamId, OrcType.OrcTypeKind columnType, ColumnEncoding.ColumnEncodingKind columnEncoding) {
        if (streamId.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA) {
            switch (columnType) {
                case SHORT: 
                case INT: 
                case LONG: {
                    return new LongStreamDwrfCheckpoint(InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
                }
                case BINARY: 
                case STRING: 
                case VARCHAR: 
                case CHAR: {
                    return new ByteArrayStreamCheckpoint(InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.LENGTH || streamId.getStreamKind() == Stream.StreamKind.DATA) {
            if (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
                return new LongStreamV2Checkpoint(0, InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
            }
            if (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
                return new LongStreamV1Checkpoint(0, InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
            }
        }
        throw new IllegalArgumentException("Unsupported column type " + (Object)((Object)columnType) + " for dictionary stream " + streamId);
    }

    private static Map<StreamId, StreamCheckpoint> getBooleanColumnCheckpoints(int column, int sequence, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getByteColumnCheckpoints(int column, int sequence, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)new ByteStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getLongColumnCheckpoints(int column, int sequence, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.IN_DICTIONARY)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_DICTIONARY), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getFloatColumnCheckpoints(int column, int sequence, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)new FloatStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getDoubleColumnCheckpoints(int column, int sequence, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)new DoubleStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getTimestampColumnCheckpoints(int column, int sequence, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.SECONDARY)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.SECONDARY), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getSliceColumnCheckpoints(int column, int sequence, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2) {
            if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
                checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)new ByteArrayStreamCheckpoint(compressed, positionsList));
            }
            if (availableStreams.contains((Object)Stream.StreamKind.LENGTH)) {
                checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.LENGTH), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
            }
        } else if (encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            if (availableStreams.contains((Object)Stream.StreamKind.IN_DICTIONARY)) {
                if (availableStreams.contains((Object)Stream.StreamKind.ROW_GROUP_DICTIONARY)) {
                    checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.ROW_GROUP_DICTIONARY), (Object)new ByteArrayStreamCheckpoint(compressed, positionsList));
                }
                checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH), (Object)new RowGroupDictionaryLengthStreamCheckpoint(compressed, positionsList));
                if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
                    checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
                }
                checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_DICTIONARY), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
            } else if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
                checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
            }
        } else {
            throw new IllegalArgumentException("Unsupported encoding for slice column: " + (Object)((Object)encoding));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getListOrMapColumnCheckpoints(int column, int sequence, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.LENGTH)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.LENGTH), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getStructColumnCheckpoints(int column, int sequence, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static Map<StreamId, StreamCheckpoint> getDecimalColumnCheckpoints(int column, int sequence, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.IN_MAP)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.IN_MAP), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.DATA), (Object)new DecimalStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.SECONDARY)) {
            checkpoints.put((Object)new StreamId(column, sequence, Stream.StreamKind.SECONDARY), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.build();
    }

    private static StreamCheckpoint createLongStreamCheckpoint(ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, ColumnPositionsList positionsList) {
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            return new LongStreamV2Checkpoint(compressed, positionsList);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            return new LongStreamV1Checkpoint(compressed, positionsList);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            return new LongStreamDwrfCheckpoint(compressed, positionsList);
        }
        throw new IllegalArgumentException("Unsupported encoding for long stream: " + (Object)((Object)encoding));
    }

    public static class ColumnPositionsList {
        private final int column;
        private final int sequence;
        private final OrcType.OrcTypeKind columnType;
        private final List<Integer> positionsList;
        private int index;

        private ColumnPositionsList(int column, int sequence, OrcType.OrcTypeKind columnType, List<Integer> positionsList) {
            this.column = column;
            this.sequence = sequence;
            this.columnType = Objects.requireNonNull(columnType, "columnType is null");
            this.positionsList = ImmutableList.copyOf((Collection)Objects.requireNonNull(positionsList, "positionsList is null"));
        }

        public int getIndex() {
            return this.index;
        }

        public boolean hasNextPosition() {
            return this.index < this.positionsList.size();
        }

        public int nextPosition() {
            if (!this.hasNextPosition()) {
                throw new InvalidCheckpointException("Not enough positions for column %s and sequence %s, of type %s, checkpoints", new Object[]{this.column, this.sequence, this.columnType});
            }
            return this.positionsList.get(this.index++);
        }
    }
}

