/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class StreamDescriptor {
    private final String streamName;
    private final int streamId;
    private final int sequence;
    private final OrcType.OrcTypeKind streamType;
    private final String fieldName;
    private final OrcDataSource orcDataSource;
    private final List<StreamDescriptor> nestedStreams;

    public StreamDescriptor(String streamName, int streamId, String fieldName, OrcType.OrcTypeKind streamType, OrcDataSource orcDataSource, List<StreamDescriptor> nestedStreams) {
        this(streamName, streamId, fieldName, streamType, orcDataSource, nestedStreams, 0);
    }

    public StreamDescriptor(String streamName, int streamId, String fieldName, OrcType.OrcTypeKind streamType, OrcDataSource orcDataSource, List<StreamDescriptor> nestedStreams, int sequence) {
        this.streamName = Objects.requireNonNull(streamName, "streamName is null");
        this.streamId = streamId;
        this.sequence = sequence;
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName is null");
        this.streamType = Objects.requireNonNull(streamType, "type is null");
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.nestedStreams = ImmutableList.copyOf((Collection)Objects.requireNonNull(nestedStreams, "nestedStreams is null"));
    }

    public String getStreamName() {
        return this.streamName;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public OrcType.OrcTypeKind getStreamType() {
        return this.streamType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public OrcDataSourceId getOrcDataSourceId() {
        return this.orcDataSource.getId();
    }

    public OrcDataSource getOrcDataSource() {
        return this.orcDataSource;
    }

    public List<StreamDescriptor> getNestedStreams() {
        return this.nestedStreams;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("streamName", (Object)this.streamName).add("streamId", this.streamId).add("sequence", this.sequence).add("streamType", (Object)this.streamType).add("dataSource", (Object)this.orcDataSource.getId()).toString();
    }
}

