/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampStreamReader
implements StreamReader {
    private static final int MILLIS_PER_SECOND = 1000;
    private final StreamDescriptor streamDescriptor;
    private final long baseTimestampInSeconds;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean[] nullVector = new boolean[0];
    @Nonnull
    private InputStreamSource<LongInputStream> secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream secondsStream;
    @Nonnull
    private InputStreamSource<LongInputStream> nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream nanosStream;
    private long[] secondsVector = new long[0];
    private long[] nanosVector = new long[0];
    private boolean rowGroupOpen;

    public TimestampStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.secondsStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is not present");
                }
                if (this.nanosStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is not present");
                }
                this.secondsStream.skip(this.readOffset);
                this.nanosStream.skip(this.readOffset);
            }
        }
        if (this.secondsVector.length < this.nextBatchSize) {
            this.secondsVector = new long[this.nextBatchSize];
        }
        if (this.nanosVector.length < this.nextBatchSize) {
            this.nanosVector = new long[this.nextBatchSize];
        }
        BlockBuilder builder = type.createBlockBuilder(null, this.nextBatchSize);
        if (this.presentStream == null) {
            if (this.secondsStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is not present");
            }
            if (this.nanosStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is not present");
            }
            this.secondsStream.nextLongVector(this.nextBatchSize, this.secondsVector);
            this.nanosStream.nextLongVector(this.nextBatchSize, this.nanosVector);
            for (int i = 0; i < this.nextBatchSize; ++i) {
                type.writeLong(builder, TimestampStreamReader.decodeTimestamp(this.secondsVector[i], this.nanosVector[i], this.baseTimestampInSeconds));
            }
        } else {
            int nullValues;
            if (this.nullVector.length < this.nextBatchSize) {
                this.nullVector = new boolean[this.nextBatchSize];
            }
            if ((nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.nullVector)) != this.nextBatchSize) {
                if (this.secondsStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but seconds stream is not present");
                }
                if (this.nanosStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but nanos stream is not present");
                }
                this.secondsStream.nextLongVector(this.nextBatchSize, this.secondsVector, this.nullVector);
                this.nanosStream.nextLongVector(this.nextBatchSize, this.nanosVector, this.nullVector);
                for (int i = 0; i < this.nextBatchSize; ++i) {
                    if (this.nullVector[i]) {
                        builder.appendNull();
                        continue;
                    }
                    type.writeLong(builder, TimestampStreamReader.decodeTimestamp(this.secondsVector[i], this.nanosVector[i], this.baseTimestampInSeconds));
                }
            } else {
                for (int i = 0; i < this.nextBatchSize; ++i) {
                    builder.appendNull();
                }
            }
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return builder.build();
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.secondsStream = this.secondsStreamSource.openStream();
        this.nanosStream = this.nanosStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.secondsStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.nanosStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.secondsStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.nanosStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    public static long decodeTimestamp(long seconds, long serializedNanos, long baseTimestampInSeconds) {
        long millis = (seconds + baseTimestampInSeconds) * 1000L;
        long nanos = TimestampStreamReader.parseNanos(serializedNanos);
        if (millis < 0L && nanos != 0L) {
            millis -= 1000L;
        }
        return millis + nanos / 1000000L;
    }

    private static int parseNanos(long serialized) {
        int zeros = (int)serialized & 7;
        int result = (int)(serialized >>> 3);
        if (zeros != 0) {
            for (int i = 0; i <= zeros; ++i) {
                result *= 10;
            }
        }
        return result;
    }
}

