/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.RowBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class StructStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final StreamReader[] structFields;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;

    public StructStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        this.structFields = new StreamReader[nestedStreams.size()];
        for (int i = 0; i < nestedStreams.size(); ++i) {
            StreamDescriptor nestedStream = nestedStreams.get(i);
            this.structFields[i] = StreamReaders.createStreamReader(nestedStream, hiveStorageTimeZone);
        }
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            for (StreamReader structField : this.structFields) {
                structField.prepareNextRead(this.readOffset);
            }
        }
        List typeParameters = type.getTypeParameters();
        boolean[] nullVector = new boolean[this.nextBatchSize];
        Block[] blocks = new Block[typeParameters.size()];
        if (this.presentStream == null) {
            for (int i = 0; i < typeParameters.size(); ++i) {
                StreamReader structField = this.structFields[i];
                structField.prepareNextRead(this.nextBatchSize);
                blocks[i] = structField.readBlock((Type)typeParameters.get(i));
            }
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                for (int i = 0; i < typeParameters.size(); ++i) {
                    StreamReader structField = this.structFields[i];
                    structField.prepareNextRead(this.nextBatchSize - nullValues);
                    blocks[i] = structField.readBlock((Type)typeParameters.get(i));
                }
            } else {
                for (int i = 0; i < typeParameters.size(); ++i) {
                    blocks[i] = ((Type)typeParameters.get(i)).createBlockBuilder(null, 0).build();
                }
            }
        }
        Block rowBlock = RowBlock.fromFieldBlocks((boolean[])nullVector, (Block[])blocks);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return rowBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (StreamReader structField : this.structFields) {
            structField.startStripe(dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (StreamReader structField : this.structFields) {
            structField.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

