/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StringStatisticsBuilder
implements SliceColumnStatisticsBuilder {
    private final int stringStatisticsLimitInBytes;
    private long nonNullValueCount;
    private Slice minimum;
    private Slice maximum;
    private long sum;

    public StringStatisticsBuilder(int stringStatisticsLimitInBytes) {
        this(stringStatisticsLimitInBytes, 0L, null, null, 0L);
    }

    private StringStatisticsBuilder(int stringStatisticsLimitInBytes, long nonNullValueCount, Slice minimum, Slice maximum, long sum) {
        this.stringStatisticsLimitInBytes = stringStatisticsLimitInBytes;
        this.nonNullValueCount = nonNullValueCount;
        this.minimum = minimum;
        this.maximum = maximum;
        this.sum = sum;
    }

    public StringStatisticsBuilder withStringStatisticsLimit(int limitInBytes) {
        Preconditions.checkArgument((limitInBytes >= 0 ? 1 : 0) != 0, (Object)"limitInBytes is less than 0");
        return new StringStatisticsBuilder(limitInBytes, this.nonNullValueCount, this.minimum, this.maximum, this.sum);
    }

    public long getNonNullValueCount() {
        return this.nonNullValueCount;
    }

    @Override
    public void addValue(Slice value) {
        Objects.requireNonNull(value, "value is null");
        if (this.nonNullValueCount == 0L) {
            Preconditions.checkState((this.minimum == null && this.maximum == null ? 1 : 0) != 0);
            this.minimum = value;
            this.maximum = value;
        } else if (this.minimum != null && value.compareTo(this.minimum) <= 0) {
            this.minimum = value;
        } else if (this.maximum != null && value.compareTo(this.maximum) >= 0) {
            this.maximum = value;
        }
        ++this.nonNullValueCount;
        this.sum = Math.addExact(this.sum, (long)value.length());
    }

    private void addStringStatistics(long valueCount, StringStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((valueCount > 0L ? 1 : 0) != 0, (Object)"valueCount is 0");
        Preconditions.checkArgument((value.getMin() != null || value.getMax() != null ? 1 : 0) != 0, (Object)"min and max cannot both be null");
        if (this.nonNullValueCount == 0L) {
            Preconditions.checkState((this.minimum == null && this.maximum == null ? 1 : 0) != 0);
            this.minimum = value.getMin();
            this.maximum = value.getMax();
        } else {
            if (this.minimum != null && (value.getMin() == null || this.minimum.compareTo(value.getMin()) > 0)) {
                this.minimum = value.getMin();
            }
            if (this.maximum != null && (value.getMax() == null || this.maximum.compareTo(value.getMax()) < 0)) {
                this.maximum = value.getMax();
            }
        }
        this.nonNullValueCount += valueCount;
        this.sum = Math.addExact(this.sum, value.getSum());
    }

    private Optional<StringStatistics> buildStringStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        this.minimum = this.dropStringMinMaxIfNecessary(this.minimum);
        this.maximum = this.dropStringMinMaxIfNecessary(this.maximum);
        if (this.minimum == null && this.maximum == null) {
            return Optional.empty();
        }
        return Optional.of(new StringStatistics(this.minimum, this.maximum, this.sum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<StringStatistics> stringStatistics = this.buildStringStatistics();
        stringStatistics.ifPresent(s -> Verify.verify((this.nonNullValueCount > 0L ? 1 : 0) != 0));
        return new ColumnStatistics(this.nonNullValueCount, stringStatistics.map(s -> 5L + this.sum / this.nonNullValueCount).orElse(0L), null, null, null, stringStatistics.orElse(null), null, null, null, null);
    }

    public static Optional<StringStatistics> mergeStringStatistics(List<ColumnStatistics> stats) {
        StringStatisticsBuilder stringStatisticsBuilder = new StringStatisticsBuilder(Integer.MAX_VALUE);
        for (ColumnStatistics columnStatistics : stats) {
            StringStatistics partialStatistics = columnStatistics.getStringStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            stringStatisticsBuilder.addStringStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return stringStatisticsBuilder.buildStringStatistics();
    }

    private Slice dropStringMinMaxIfNecessary(Slice minOrMax) {
        if (minOrMax == null || minOrMax.length() > this.stringStatisticsLimitInBytes) {
            return null;
        }
        if (minOrMax.isCompact()) {
            return minOrMax;
        }
        return Slices.copyOf((Slice)minOrMax);
    }
}

