/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DateStatistics
implements RangeStatistics<Integer> {
    public static final long DATE_VALUE_BYTES = 5L;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DateStatistics.class).instanceSize();
    private final boolean hasMinimum;
    private final boolean hasMaximum;
    private final int minimum;
    private final int maximum;

    public DateStatistics(Integer minimum, Integer maximum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum <= maximum ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.hasMinimum = minimum != null;
        this.minimum = this.hasMinimum ? minimum : 0;
        this.hasMaximum = maximum != null;
        this.maximum = this.hasMaximum ? maximum : 0;
    }

    @Override
    public Integer getMin() {
        return this.hasMinimum ? Integer.valueOf(this.minimum) : null;
    }

    @Override
    public Integer getMax() {
        return this.hasMaximum ? Integer.valueOf(this.maximum) : null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateStatistics that = (DateStatistics)o;
        return Objects.equals(this.getMin(), that.getMin()) && Objects.equals(this.getMax(), that.getMax());
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.getMin()).add("max", (Object)this.getMax()).toString();
    }
}

