/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.proto.OrcProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.facebook.presto.orc.protobuf.MessageLite;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CountingOutputStream;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OrcMetadataWriter
implements MetadataWriter {
    private static final int PRESTO_WRITER_ID = 2;
    private static final int ORC_WRITER_VERSION = 6;
    private static final List<Integer> ORC_METADATA_VERSION = ImmutableList.of((Object)0, (Object)12);

    @Override
    public List<Integer> getOrcMetadataVersion() {
        return ORC_METADATA_VERSION;
    }

    @Override
    public int writePostscript(SliceOutput output, int footerLength, int metadataLength, CompressionKind compression, int compressionBlockSize) throws IOException {
        OrcProto.PostScript postScriptProtobuf = OrcProto.PostScript.newBuilder().addAllVersion(ORC_METADATA_VERSION).setFooterLength((long)footerLength).setMetadataLength((long)metadataLength).setCompression(OrcMetadataWriter.toCompression(compression)).setCompressionBlockSize((long)compressionBlockSize).setWriterVersion(6).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)postScriptProtobuf);
    }

    @Override
    public int writeMetadata(SliceOutput output, Metadata metadata) throws IOException {
        OrcProto.Metadata metadataProtobuf = OrcProto.Metadata.newBuilder().addAllStripeStats((Iterable)metadata.getStripeStatsList().stream().map(OrcMetadataWriter::toStripeStatistics).collect(Collectors.toList())).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)metadataProtobuf);
    }

    private static OrcProto.StripeStatistics toStripeStatistics(StripeStatistics stripeStatistics) {
        return OrcProto.StripeStatistics.newBuilder().addAllColStats((Iterable)stripeStatistics.getColumnStatistics().stream().map(OrcMetadataWriter::toColumnStatistics).collect(Collectors.toList())).build();
    }

    @Override
    public int writeFooter(SliceOutput output, Footer footer) throws IOException {
        OrcProto.Footer footerProtobuf = OrcProto.Footer.newBuilder().setWriter(2).setNumberOfRows(footer.getNumberOfRows()).setRowIndexStride(footer.getRowsInRowGroup()).addAllStripes((Iterable)footer.getStripes().stream().map(OrcMetadataWriter::toStripeInformation).collect(Collectors.toList())).addAllTypes((Iterable)footer.getTypes().stream().map(OrcMetadataWriter::toType).collect(Collectors.toList())).addAllStatistics((Iterable)footer.getFileStats().stream().map(OrcMetadataWriter::toColumnStatistics).collect(Collectors.toList())).addAllMetadata((Iterable)footer.getUserMetadata().entrySet().stream().map(OrcMetadataWriter::toUserMetadata).collect(Collectors.toList())).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)footerProtobuf);
    }

    private static OrcProto.StripeInformation toStripeInformation(StripeInformation stripe) {
        return OrcProto.StripeInformation.newBuilder().setNumberOfRows((long)stripe.getNumberOfRows()).setOffset(stripe.getOffset()).setIndexLength(stripe.getIndexLength()).setDataLength(stripe.getDataLength()).setFooterLength(stripe.getFooterLength()).build();
    }

    private static OrcProto.Type toType(OrcType type) {
        OrcProto.Type.Builder builder = OrcProto.Type.newBuilder().setKind(OrcMetadataWriter.toTypeKind(type.getOrcTypeKind())).addAllSubtypes(type.getFieldTypeIndexes()).addAllFieldNames(type.getFieldNames());
        if (type.getLength().isPresent()) {
            builder.setMaximumLength(type.getLength().get().intValue());
        }
        if (type.getPrecision().isPresent()) {
            builder.setPrecision(type.getPrecision().get().intValue());
        }
        if (type.getScale().isPresent()) {
            builder.setScale(type.getScale().get().intValue());
        }
        return builder.build();
    }

    private static OrcProto.Type.Kind toTypeKind(OrcType.OrcTypeKind orcTypeKind) {
        switch (orcTypeKind) {
            case BOOLEAN: {
                return OrcProto.Type.Kind.BOOLEAN;
            }
            case BYTE: {
                return OrcProto.Type.Kind.BYTE;
            }
            case SHORT: {
                return OrcProto.Type.Kind.SHORT;
            }
            case INT: {
                return OrcProto.Type.Kind.INT;
            }
            case LONG: {
                return OrcProto.Type.Kind.LONG;
            }
            case DECIMAL: {
                return OrcProto.Type.Kind.DECIMAL;
            }
            case FLOAT: {
                return OrcProto.Type.Kind.FLOAT;
            }
            case DOUBLE: {
                return OrcProto.Type.Kind.DOUBLE;
            }
            case STRING: {
                return OrcProto.Type.Kind.STRING;
            }
            case VARCHAR: {
                return OrcProto.Type.Kind.VARCHAR;
            }
            case CHAR: {
                return OrcProto.Type.Kind.CHAR;
            }
            case BINARY: {
                return OrcProto.Type.Kind.BINARY;
            }
            case DATE: {
                return OrcProto.Type.Kind.DATE;
            }
            case TIMESTAMP: {
                return OrcProto.Type.Kind.TIMESTAMP;
            }
            case LIST: {
                return OrcProto.Type.Kind.LIST;
            }
            case MAP: {
                return OrcProto.Type.Kind.MAP;
            }
            case STRUCT: {
                return OrcProto.Type.Kind.STRUCT;
            }
            case UNION: {
                return OrcProto.Type.Kind.UNION;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)orcTypeKind));
    }

    private static OrcProto.ColumnStatistics toColumnStatistics(ColumnStatistics columnStatistics) {
        OrcProto.ColumnStatistics.Builder builder = OrcProto.ColumnStatistics.newBuilder();
        if (columnStatistics.hasNumberOfValues()) {
            builder.setNumberOfValues(columnStatistics.getNumberOfValues());
        }
        if (columnStatistics.getBooleanStatistics() != null) {
            builder.setBucketStatistics(OrcProto.BucketStatistics.newBuilder().addCount(columnStatistics.getBooleanStatistics().getTrueValueCount()).build());
        }
        if (columnStatistics.getIntegerStatistics() != null) {
            OrcProto.IntegerStatistics.Builder integerStatistics = OrcProto.IntegerStatistics.newBuilder().setMinimum(columnStatistics.getIntegerStatistics().getMin().longValue()).setMaximum(columnStatistics.getIntegerStatistics().getMax().longValue());
            if (columnStatistics.getIntegerStatistics().getSum() != null) {
                integerStatistics.setSum(columnStatistics.getIntegerStatistics().getSum().longValue());
            }
            builder.setIntStatistics(integerStatistics.build());
        }
        if (columnStatistics.getDoubleStatistics() != null) {
            builder.setDoubleStatistics(OrcProto.DoubleStatistics.newBuilder().setMinimum(columnStatistics.getDoubleStatistics().getMin().doubleValue()).setMaximum(columnStatistics.getDoubleStatistics().getMax().doubleValue()).build());
        }
        if (columnStatistics.getStringStatistics() != null) {
            OrcProto.StringStatistics.Builder statisticsBuilder = OrcProto.StringStatistics.newBuilder();
            if (columnStatistics.getStringStatistics().getMin() != null) {
                statisticsBuilder.setMinimumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMin().getBytes()));
            }
            if (columnStatistics.getStringStatistics().getMax() != null) {
                statisticsBuilder.setMaximumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMax().getBytes()));
            }
            statisticsBuilder.setSum(columnStatistics.getStringStatistics().getSum());
            builder.setStringStatistics(statisticsBuilder.build());
        }
        if (columnStatistics.getDateStatistics() != null) {
            builder.setDateStatistics(OrcProto.DateStatistics.newBuilder().setMinimum(columnStatistics.getDateStatistics().getMin().intValue()).setMaximum(columnStatistics.getDateStatistics().getMax().intValue()).build());
        }
        if (columnStatistics.getDecimalStatistics() != null) {
            builder.setDecimalStatistics(OrcProto.DecimalStatistics.newBuilder().setMinimum(columnStatistics.getDecimalStatistics().getMin().toString()).setMaximum(columnStatistics.getDecimalStatistics().getMax().toString()).build());
        }
        return builder.build();
    }

    private static OrcProto.UserMetadataItem toUserMetadata(Map.Entry<String, Slice> entry) {
        return OrcProto.UserMetadataItem.newBuilder().setName(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue().getBytes())).build();
    }

    @Override
    public int writeStripeFooter(SliceOutput output, StripeFooter footer) throws IOException {
        OrcProto.StripeFooter footerProtobuf = OrcProto.StripeFooter.newBuilder().addAllStreams((Iterable)footer.getStreams().stream().map(OrcMetadataWriter::toStream).collect(Collectors.toList())).addAllColumns((Iterable)footer.getColumnEncodings().stream().map(OrcMetadataWriter::toColumnEncoding).collect(Collectors.toList())).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)footerProtobuf);
    }

    private static OrcProto.Stream toStream(Stream stream) {
        return OrcProto.Stream.newBuilder().setColumn(stream.getColumn()).setKind(OrcMetadataWriter.toStreamKind(stream.getStreamKind())).setLength((long)stream.getLength()).build();
    }

    private static OrcProto.Stream.Kind toStreamKind(Stream.StreamKind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return OrcProto.Stream.Kind.PRESENT;
            }
            case DATA: {
                return OrcProto.Stream.Kind.DATA;
            }
            case LENGTH: {
                return OrcProto.Stream.Kind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return OrcProto.Stream.Kind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return OrcProto.Stream.Kind.DICTIONARY_COUNT;
            }
            case SECONDARY: {
                return OrcProto.Stream.Kind.SECONDARY;
            }
            case ROW_INDEX: {
                return OrcProto.Stream.Kind.ROW_INDEX;
            }
        }
        throw new IllegalArgumentException("Unsupported stream kind: " + (Object)((Object)streamKind));
    }

    private static OrcProto.ColumnEncoding toColumnEncoding(ColumnEncoding columnEncodings) {
        return OrcProto.ColumnEncoding.newBuilder().setKind(OrcMetadataWriter.toColumnEncoding(columnEncodings.getColumnEncodingKind())).setDictionarySize(columnEncodings.getDictionarySize()).build();
    }

    private static OrcProto.ColumnEncoding.Kind toColumnEncoding(ColumnEncoding.ColumnEncodingKind columnEncodingKind) {
        switch (columnEncodingKind) {
            case DIRECT: {
                return OrcProto.ColumnEncoding.Kind.DIRECT;
            }
            case DICTIONARY: {
                return OrcProto.ColumnEncoding.Kind.DICTIONARY;
            }
            case DIRECT_V2: {
                return OrcProto.ColumnEncoding.Kind.DIRECT_V2;
            }
            case DICTIONARY_V2: {
                return OrcProto.ColumnEncoding.Kind.DICTIONARY_V2;
            }
        }
        throw new IllegalArgumentException("Unsupported column encoding kind: " + (Object)((Object)columnEncodingKind));
    }

    @Override
    public int writeRowIndexes(SliceOutput output, List<RowGroupIndex> rowGroupIndexes) throws IOException {
        OrcProto.RowIndex rowIndexProtobuf = OrcProto.RowIndex.newBuilder().addAllEntry((Iterable)rowGroupIndexes.stream().map(OrcMetadataWriter::toRowGroupIndex).collect(Collectors.toList())).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)rowIndexProtobuf);
    }

    private static OrcProto.RowIndexEntry toRowGroupIndex(RowGroupIndex rowGroupIndex) {
        return OrcProto.RowIndexEntry.newBuilder().addAllPositions((Iterable)rowGroupIndex.getPositions().stream().map(Integer::longValue).collect(Collectors.toList())).setStatistics(OrcMetadataWriter.toColumnStatistics(rowGroupIndex.getColumnStatistics())).build();
    }

    private static OrcProto.CompressionKind toCompression(CompressionKind compressionKind) {
        switch (compressionKind) {
            case NONE: {
                return OrcProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return OrcProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return OrcProto.CompressionKind.SNAPPY;
            }
            case LZ4: {
                return OrcProto.CompressionKind.LZ4;
            }
        }
        throw new IllegalArgumentException("Unsupported compression kind: " + (Object)((Object)compressionKind));
    }

    private static int writeProtobufObject(OutputStream output, MessageLite object) throws IOException {
        CountingOutputStream countingOutput = new CountingOutputStream(output);
        object.writeTo((OutputStream)countingOutput);
        return Math.toIntExact(countingOutput.getCount());
    }
}

