/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.proto.OrcProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.facebook.presto.orc.protobuf.CodedInputStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OrcMetadataReader
implements MetadataReader {
    private static final int REPLACEMENT_CHARACTER_CODE_POINT = 65533;
    private static final int PROTOBUF_MESSAGE_MAX_LIMIT = Math.toIntExact(new DataSize(1.0, DataSize.Unit.GIGABYTE).toBytes());

    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((byte[])data, (int)offset, (int)length);
        OrcProto.PostScript postScript = OrcProto.PostScript.parseFrom((CodedInputStream)input);
        return new PostScript(postScript.getVersionList(), postScript.getFooterLength(), postScript.getMetadataLength(), OrcMetadataReader.toCompression(postScript.getCompression()), postScript.getCompressionBlockSize(), OrcMetadataReader.toHiveWriterVersion(postScript.getWriterVersion()));
    }

    private static PostScript.HiveWriterVersion toHiveWriterVersion(int writerVersion) {
        if (writerVersion >= 1) {
            return PostScript.HiveWriterVersion.ORC_HIVE_8732;
        }
        return PostScript.HiveWriterVersion.ORIGINAL;
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        input.setSizeLimit(PROTOBUF_MESSAGE_MAX_LIMIT);
        OrcProto.Metadata metadata = OrcProto.Metadata.parseFrom((CodedInputStream)input);
        return new Metadata(OrcMetadataReader.toStripeStatistics(hiveWriterVersion, metadata.getStripeStatsList()));
    }

    private static List<StripeStatistics> toStripeStatistics(PostScript.HiveWriterVersion hiveWriterVersion, List<OrcProto.StripeStatistics> types) {
        return (List)types.stream().map(stripeStatistics -> OrcMetadataReader.toStripeStatistics(hiveWriterVersion, stripeStatistics)).collect(ImmutableList.toImmutableList());
    }

    private static StripeStatistics toStripeStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.StripeStatistics stripeStatistics) {
        return new StripeStatistics(OrcMetadataReader.toColumnStatistics(hiveWriterVersion, stripeStatistics.getColStatsList(), false));
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        input.setSizeLimit(PROTOBUF_MESSAGE_MAX_LIMIT);
        OrcProto.Footer footer = OrcProto.Footer.parseFrom((CodedInputStream)input);
        return new Footer(footer.getNumberOfRows(), footer.getRowIndexStride(), OrcMetadataReader.toStripeInformation(footer.getStripesList()), OrcMetadataReader.toType(footer.getTypesList()), OrcMetadataReader.toColumnStatistics(hiveWriterVersion, footer.getStatisticsList(), false), OrcMetadataReader.toUserMetadata(footer.getMetadataList()));
    }

    private static List<StripeInformation> toStripeInformation(List<OrcProto.StripeInformation> types) {
        return (List)types.stream().map(OrcMetadataReader::toStripeInformation).collect(ImmutableList.toImmutableList());
    }

    private static StripeInformation toStripeInformation(OrcProto.StripeInformation stripeInformation) {
        return new StripeInformation(Math.toIntExact(stripeInformation.getNumberOfRows()), stripeInformation.getOffset(), stripeInformation.getIndexLength(), stripeInformation.getDataLength(), stripeInformation.getFooterLength());
    }

    @Override
    public StripeFooter readStripeFooter(List<OrcType> types, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.StripeFooter stripeFooter = OrcProto.StripeFooter.parseFrom((CodedInputStream)input);
        return new StripeFooter(OrcMetadataReader.toStream(stripeFooter.getStreamsList()), OrcMetadataReader.toColumnEncoding(stripeFooter.getColumnsList()));
    }

    private static Stream toStream(OrcProto.Stream stream) {
        return new Stream(stream.getColumn(), OrcMetadataReader.toStreamKind(stream.getKind()), Math.toIntExact(stream.getLength()), true);
    }

    private static List<Stream> toStream(List<OrcProto.Stream> streams) {
        return (List)streams.stream().map(OrcMetadataReader::toStream).collect(ImmutableList.toImmutableList());
    }

    private static ColumnEncoding toColumnEncoding(OrcProto.ColumnEncoding columnEncoding) {
        return new ColumnEncoding(OrcMetadataReader.toColumnEncodingKind(columnEncoding.getKind()), columnEncoding.getDictionarySize());
    }

    private static List<ColumnEncoding> toColumnEncoding(List<OrcProto.ColumnEncoding> columnEncodings) {
        return (List)columnEncodings.stream().map(OrcMetadataReader::toColumnEncoding).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.RowIndex rowIndex = OrcProto.RowIndex.parseFrom((CodedInputStream)input);
        return (List)rowIndex.getEntryList().stream().map(rowIndexEntry -> OrcMetadataReader.toRowGroupIndex(hiveWriterVersion, rowIndexEntry)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<HiveBloomFilter> readBloomFilterIndexes(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.BloomFilterIndex bloomFilter = OrcProto.BloomFilterIndex.parseFrom((CodedInputStream)input);
        List bloomFilterList = bloomFilter.getBloomFilterList();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (OrcProto.BloomFilter orcBloomFilter : bloomFilterList) {
            builder.add((Object)new HiveBloomFilter(orcBloomFilter.getBitsetList(), orcBloomFilter.getBitsetCount() * 64, orcBloomFilter.getNumHashFunctions()));
        }
        return builder.build();
    }

    private static RowGroupIndex toRowGroupIndex(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.RowIndexEntry rowIndexEntry) {
        List positionsList = rowIndexEntry.getPositionsList();
        ImmutableList.Builder positions = ImmutableList.builder();
        for (int index = 0; index < positionsList.size(); ++index) {
            long longPosition = (Long)positionsList.get(index);
            int intPosition = (int)longPosition;
            Preconditions.checkState(((long)intPosition == longPosition ? 1 : 0) != 0, (String)"Expected checkpoint position %s, to be an integer", (int)index);
            positions.add((Object)intPosition);
        }
        return new RowGroupIndex((List<Integer>)positions.build(), OrcMetadataReader.toColumnStatistics(hiveWriterVersion, rowIndexEntry.getStatistics(), true));
    }

    private static ColumnStatistics toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.ColumnStatistics statistics, boolean isRowGroup) {
        long minAverageValueBytes;
        if (statistics.hasBucketStatistics()) {
            minAverageValueBytes = 2L;
        } else if (statistics.hasIntStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasDoubleStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasStringStatistics()) {
            minAverageValueBytes = 5L;
            if (statistics.hasNumberOfValues() && statistics.getNumberOfValues() > 0L) {
                minAverageValueBytes += statistics.getStringStatistics().getSum() / statistics.getNumberOfValues();
            }
        } else if (statistics.hasDateStatistics()) {
            minAverageValueBytes = 5L;
        } else if (statistics.hasDecimalStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasBinaryStatistics()) {
            minAverageValueBytes = 5L;
            if (statistics.hasNumberOfValues() && statistics.getNumberOfValues() > 0L) {
                minAverageValueBytes += statistics.getBinaryStatistics().getSum() / statistics.getNumberOfValues();
            }
        } else {
            minAverageValueBytes = 0L;
        }
        return new ColumnStatistics(statistics.getNumberOfValues(), minAverageValueBytes, OrcMetadataReader.toBooleanStatistics(statistics.getBucketStatistics()), OrcMetadataReader.toIntegerStatistics(statistics.getIntStatistics()), OrcMetadataReader.toDoubleStatistics(statistics.getDoubleStatistics()), OrcMetadataReader.toStringStatistics(hiveWriterVersion, statistics.getStringStatistics(), isRowGroup), OrcMetadataReader.toDateStatistics(hiveWriterVersion, statistics.getDateStatistics(), isRowGroup), OrcMetadataReader.toDecimalStatistics(statistics.getDecimalStatistics()), OrcMetadataReader.toBinaryStatistics(statistics.getBinaryStatistics()), null);
    }

    private static List<ColumnStatistics> toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, List<OrcProto.ColumnStatistics> columnStatistics, boolean isRowGroup) {
        if (columnStatistics == null) {
            return ImmutableList.of();
        }
        return (List)columnStatistics.stream().map(statistics -> OrcMetadataReader.toColumnStatistics(hiveWriterVersion, statistics, isRowGroup)).collect(ImmutableList.toImmutableList());
    }

    private static Map<String, Slice> toUserMetadata(List<OrcProto.UserMetadataItem> metadataList) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (OrcProto.UserMetadataItem item : metadataList) {
            mapBuilder.put((Object)item.getName(), (Object)OrcMetadataReader.byteStringToSlice(item.getValue()));
        }
        return mapBuilder.build();
    }

    private static BooleanStatistics toBooleanStatistics(OrcProto.BucketStatistics bucketStatistics) {
        if (bucketStatistics.getCountCount() == 0) {
            return null;
        }
        return new BooleanStatistics(bucketStatistics.getCount(0));
    }

    private static IntegerStatistics toIntegerStatistics(OrcProto.IntegerStatistics integerStatistics) {
        if (!integerStatistics.hasMinimum() && !integerStatistics.hasMaximum()) {
            return null;
        }
        return new IntegerStatistics(integerStatistics.hasMinimum() ? Long.valueOf(integerStatistics.getMinimum()) : null, integerStatistics.hasMaximum() ? Long.valueOf(integerStatistics.getMaximum()) : null, integerStatistics.hasSum() ? Long.valueOf(integerStatistics.getSum()) : null);
    }

    private static DoubleStatistics toDoubleStatistics(OrcProto.DoubleStatistics doubleStatistics) {
        if (!doubleStatistics.hasMinimum() && !doubleStatistics.hasMaximum()) {
            return null;
        }
        if (doubleStatistics.hasMinimum() && Double.isNaN(doubleStatistics.getMinimum()) || doubleStatistics.hasMaximum() && Double.isNaN(doubleStatistics.getMaximum()) || doubleStatistics.hasSum() && Double.isNaN(doubleStatistics.getSum())) {
            return null;
        }
        return new DoubleStatistics(doubleStatistics.hasMinimum() ? Double.valueOf(doubleStatistics.getMinimum()) : null, doubleStatistics.hasMaximum() ? Double.valueOf(doubleStatistics.getMaximum()) : null);
    }

    static StringStatistics toStringStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.StringStatistics stringStatistics, boolean isRowGroup) {
        if (hiveWriterVersion == PostScript.HiveWriterVersion.ORIGINAL && !isRowGroup) {
            return null;
        }
        if (!stringStatistics.hasMinimum() && !stringStatistics.hasMaximum()) {
            return null;
        }
        Slice maximum = stringStatistics.hasMaximum() ? OrcMetadataReader.maxStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMaximumBytes()), hiveWriterVersion) : null;
        Slice minimum = stringStatistics.hasMinimum() ? OrcMetadataReader.minStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMinimumBytes()), hiveWriterVersion) : null;
        long sum = stringStatistics.hasSum() ? stringStatistics.getSum() : 0L;
        return new StringStatistics(minimum, maximum, sum);
    }

    private static DecimalStatistics toDecimalStatistics(OrcProto.DecimalStatistics decimalStatistics) {
        if (!decimalStatistics.hasMinimum() && !decimalStatistics.hasMaximum()) {
            return null;
        }
        BigDecimal minimum = decimalStatistics.hasMinimum() ? new BigDecimal(decimalStatistics.getMinimum()) : null;
        BigDecimal maximum = decimalStatistics.hasMaximum() ? new BigDecimal(decimalStatistics.getMaximum()) : null;
        return new DecimalStatistics(minimum, maximum, 8L);
    }

    private static BinaryStatistics toBinaryStatistics(OrcProto.BinaryStatistics binaryStatistics) {
        if (!binaryStatistics.hasSum()) {
            return null;
        }
        return new BinaryStatistics(binaryStatistics.getSum());
    }

    static Slice byteStringToSlice(ByteString value) {
        return Slices.wrappedBuffer((byte[])value.toByteArray());
    }

    @VisibleForTesting
    public static Slice maxStringTruncateToValidRange(Slice value, PostScript.HiveWriterVersion version) {
        if (value == null) {
            return null;
        }
        if (version != PostScript.HiveWriterVersion.ORIGINAL) {
            return value;
        }
        int index = OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter(value);
        if (index == value.length()) {
            return value;
        }
        Slice newValue = Slices.copyOf((Slice)value, (int)0, (int)(index + 1));
        newValue.setByte(index, 255);
        return newValue;
    }

    @VisibleForTesting
    public static Slice minStringTruncateToValidRange(Slice value, PostScript.HiveWriterVersion version) {
        if (value == null) {
            return null;
        }
        if (version != PostScript.HiveWriterVersion.ORIGINAL) {
            return value;
        }
        int index = OrcMetadataReader.findStringStatisticTruncationPositionForOriginalOrcWriter(value);
        if (index == value.length()) {
            return value;
        }
        return Slices.copyOf((Slice)value, (int)0, (int)index);
    }

    @VisibleForTesting
    static int findStringStatisticTruncationPositionForOriginalOrcWriter(Slice utf8) {
        int position;
        int codePoint;
        int length = utf8.length();
        for (position = 0; position < length && (codePoint = SliceUtf8.tryGetCodePointAt((Slice)utf8, (int)position)) >= 0 && codePoint != 65533 && codePoint < 65536; position += SliceUtf8.lengthOfCodePoint((int)codePoint)) {
        }
        return position;
    }

    private static DateStatistics toDateStatistics(PostScript.HiveWriterVersion hiveWriterVersion, OrcProto.DateStatistics dateStatistics, boolean isRowGroup) {
        if (hiveWriterVersion == PostScript.HiveWriterVersion.ORIGINAL && !isRowGroup) {
            return null;
        }
        if (!dateStatistics.hasMinimum() && !dateStatistics.hasMaximum()) {
            return null;
        }
        return new DateStatistics(dateStatistics.hasMinimum() ? Integer.valueOf(dateStatistics.getMinimum()) : null, dateStatistics.hasMaximum() ? Integer.valueOf(dateStatistics.getMaximum()) : null);
    }

    private static OrcType toType(OrcProto.Type type) {
        Optional<Integer> length = Optional.empty();
        if (type.getKind() == OrcProto.Type.Kind.VARCHAR || type.getKind() == OrcProto.Type.Kind.CHAR) {
            length = Optional.of(type.getMaximumLength());
        }
        Optional<Integer> precision = Optional.empty();
        Optional<Integer> scale = Optional.empty();
        if (type.getKind() == OrcProto.Type.Kind.DECIMAL) {
            precision = Optional.of(type.getPrecision());
            scale = Optional.of(type.getScale());
        }
        return new OrcType(OrcMetadataReader.toTypeKind(type.getKind()), type.getSubtypesList(), (List<String>)type.getFieldNamesList(), length, precision, scale);
    }

    private static List<OrcType> toType(List<OrcProto.Type> types) {
        return (List)types.stream().map(OrcMetadataReader::toType).collect(ImmutableList.toImmutableList());
    }

    private static OrcType.OrcTypeKind toTypeKind(OrcProto.Type.Kind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return OrcType.OrcTypeKind.BOOLEAN;
            }
            case BYTE: {
                return OrcType.OrcTypeKind.BYTE;
            }
            case SHORT: {
                return OrcType.OrcTypeKind.SHORT;
            }
            case INT: {
                return OrcType.OrcTypeKind.INT;
            }
            case LONG: {
                return OrcType.OrcTypeKind.LONG;
            }
            case FLOAT: {
                return OrcType.OrcTypeKind.FLOAT;
            }
            case DOUBLE: {
                return OrcType.OrcTypeKind.DOUBLE;
            }
            case STRING: {
                return OrcType.OrcTypeKind.STRING;
            }
            case BINARY: {
                return OrcType.OrcTypeKind.BINARY;
            }
            case TIMESTAMP: {
                return OrcType.OrcTypeKind.TIMESTAMP;
            }
            case LIST: {
                return OrcType.OrcTypeKind.LIST;
            }
            case MAP: {
                return OrcType.OrcTypeKind.MAP;
            }
            case STRUCT: {
                return OrcType.OrcTypeKind.STRUCT;
            }
            case UNION: {
                return OrcType.OrcTypeKind.UNION;
            }
            case DECIMAL: {
                return OrcType.OrcTypeKind.DECIMAL;
            }
            case DATE: {
                return OrcType.OrcTypeKind.DATE;
            }
            case VARCHAR: {
                return OrcType.OrcTypeKind.VARCHAR;
            }
            case CHAR: {
                return OrcType.OrcTypeKind.CHAR;
            }
        }
        throw new IllegalStateException(typeKind + " stream type not implemented yet");
    }

    private static Stream.StreamKind toStreamKind(OrcProto.Stream.Kind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return Stream.StreamKind.PRESENT;
            }
            case DATA: {
                return Stream.StreamKind.DATA;
            }
            case LENGTH: {
                return Stream.StreamKind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return Stream.StreamKind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return Stream.StreamKind.DICTIONARY_COUNT;
            }
            case SECONDARY: {
                return Stream.StreamKind.SECONDARY;
            }
            case ROW_INDEX: {
                return Stream.StreamKind.ROW_INDEX;
            }
            case BLOOM_FILTER: {
                return Stream.StreamKind.BLOOM_FILTER;
            }
        }
        throw new IllegalStateException(streamKind + " stream type not implemented yet");
    }

    private static ColumnEncoding.ColumnEncodingKind toColumnEncodingKind(OrcProto.ColumnEncoding.Kind columnEncodingKind) {
        switch (columnEncodingKind) {
            case DIRECT: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT;
            }
            case DIRECT_V2: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT_V2;
            }
            case DICTIONARY: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY;
            }
            case DICTIONARY_V2: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2;
            }
        }
        throw new IllegalStateException(columnEncodingKind + " stream encoding not implemented yet");
    }

    private static CompressionKind toCompression(OrcProto.CompressionKind compression) {
        switch (compression) {
            case NONE: {
                return CompressionKind.NONE;
            }
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
            case LZ4: {
                return CompressionKind.LZ4;
            }
            case ZSTD: {
                return CompressionKind.ZSTD;
            }
        }
        throw new IllegalStateException(compression + " compression not implemented yet");
    }
}

