/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.facebook.presto.orc.protobuf.MessageLite;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CountingOutputStream;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class DwrfMetadataWriter
implements MetadataWriter {
    private static final int DWRF_WRITER_VERSION = 1;
    public static final Map<String, Slice> STATIC_METADATA = ImmutableMap.builder().put((Object)"orc.writer.name", (Object)Slices.utf8Slice((String)"presto")).put((Object)"orc.writer.version", (Object)Slices.utf8Slice((String)String.valueOf(1))).build();

    @Override
    public List<Integer> getOrcMetadataVersion() {
        return ImmutableList.of();
    }

    @Override
    public int writePostscript(SliceOutput output, int footerLength, int metadataLength, CompressionKind compression, int compressionBlockSize) throws IOException {
        DwrfProto.PostScript postScriptProtobuf = DwrfProto.PostScript.newBuilder().setFooterLength((long)footerLength).setWriterVersion(1).setCompression(DwrfMetadataWriter.toCompression(compression)).setCompressionBlockSize((long)compressionBlockSize).build();
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)postScriptProtobuf);
    }

    @Override
    public int writeMetadata(SliceOutput output, Metadata metadata) {
        return 0;
    }

    @Override
    public int writeFooter(SliceOutput output, Footer footer) throws IOException {
        DwrfProto.Footer footerProtobuf = DwrfProto.Footer.newBuilder().setNumberOfRows(footer.getNumberOfRows()).setRowIndexStride(footer.getRowsInRowGroup()).addAllStripes((Iterable)footer.getStripes().stream().map(DwrfMetadataWriter::toStripeInformation).collect(ImmutableList.toImmutableList())).addAllTypes((Iterable)footer.getTypes().stream().map(DwrfMetadataWriter::toType).collect(ImmutableList.toImmutableList())).addAllStatistics((Iterable)footer.getFileStats().stream().map(DwrfMetadataWriter::toColumnStatistics).collect(ImmutableList.toImmutableList())).addAllMetadata((Iterable)footer.getUserMetadata().entrySet().stream().map(DwrfMetadataWriter::toUserMetadata).collect(ImmutableList.toImmutableList())).addAllMetadata((Iterable)STATIC_METADATA.entrySet().stream().map(DwrfMetadataWriter::toUserMetadata).collect(ImmutableList.toImmutableList())).build();
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)footerProtobuf);
    }

    private static DwrfProto.StripeInformation toStripeInformation(StripeInformation stripe) {
        return DwrfProto.StripeInformation.newBuilder().setNumberOfRows((long)stripe.getNumberOfRows()).setOffset(stripe.getOffset()).setIndexLength(stripe.getIndexLength()).setDataLength(stripe.getDataLength()).setFooterLength(stripe.getFooterLength()).build();
    }

    private static DwrfProto.Type toType(OrcType type) {
        DwrfProto.Type.Builder builder = DwrfProto.Type.newBuilder().setKind(DwrfMetadataWriter.toTypeKind(type.getOrcTypeKind())).addAllSubtypes(type.getFieldTypeIndexes()).addAllFieldNames(type.getFieldNames());
        return builder.build();
    }

    private static DwrfProto.Type.Kind toTypeKind(OrcType.OrcTypeKind orcTypeKind) {
        switch (orcTypeKind) {
            case BOOLEAN: {
                return DwrfProto.Type.Kind.BOOLEAN;
            }
            case BYTE: {
                return DwrfProto.Type.Kind.BYTE;
            }
            case SHORT: {
                return DwrfProto.Type.Kind.SHORT;
            }
            case INT: {
                return DwrfProto.Type.Kind.INT;
            }
            case LONG: {
                return DwrfProto.Type.Kind.LONG;
            }
            case FLOAT: {
                return DwrfProto.Type.Kind.FLOAT;
            }
            case DOUBLE: {
                return DwrfProto.Type.Kind.DOUBLE;
            }
            case STRING: 
            case VARCHAR: {
                return DwrfProto.Type.Kind.STRING;
            }
            case BINARY: {
                return DwrfProto.Type.Kind.BINARY;
            }
            case TIMESTAMP: {
                return DwrfProto.Type.Kind.TIMESTAMP;
            }
            case LIST: {
                return DwrfProto.Type.Kind.LIST;
            }
            case MAP: {
                return DwrfProto.Type.Kind.MAP;
            }
            case STRUCT: {
                return DwrfProto.Type.Kind.STRUCT;
            }
            case UNION: {
                return DwrfProto.Type.Kind.UNION;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)orcTypeKind));
    }

    private static DwrfProto.ColumnStatistics toColumnStatistics(ColumnStatistics columnStatistics) {
        DwrfProto.ColumnStatistics.Builder builder = DwrfProto.ColumnStatistics.newBuilder();
        if (columnStatistics.hasNumberOfValues()) {
            builder.setNumberOfValues(columnStatistics.getNumberOfValues());
        }
        if (columnStatistics.getBooleanStatistics() != null) {
            builder.setBucketStatistics(DwrfProto.BucketStatistics.newBuilder().addCount(columnStatistics.getBooleanStatistics().getTrueValueCount()).build());
        }
        if (columnStatistics.getIntegerStatistics() != null) {
            DwrfProto.IntegerStatistics.Builder integerStatistics = DwrfProto.IntegerStatistics.newBuilder().setMinimum(columnStatistics.getIntegerStatistics().getMin().longValue()).setMaximum(columnStatistics.getIntegerStatistics().getMax().longValue());
            if (columnStatistics.getIntegerStatistics().getSum() != null) {
                integerStatistics.setSum(columnStatistics.getIntegerStatistics().getSum().longValue());
            }
            builder.setIntStatistics(integerStatistics.build());
        }
        if (columnStatistics.getDoubleStatistics() != null) {
            builder.setDoubleStatistics(DwrfProto.DoubleStatistics.newBuilder().setMinimum(columnStatistics.getDoubleStatistics().getMin().doubleValue()).setMaximum(columnStatistics.getDoubleStatistics().getMax().doubleValue()).build());
        }
        if (columnStatistics.getStringStatistics() != null) {
            DwrfProto.StringStatistics.Builder statisticsBuilder = DwrfProto.StringStatistics.newBuilder();
            if (columnStatistics.getStringStatistics().getMin() != null) {
                statisticsBuilder.setMinimumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMin().getBytes()));
            }
            if (columnStatistics.getStringStatistics().getMax() != null) {
                statisticsBuilder.setMaximumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMax().getBytes()));
            }
            statisticsBuilder.setSum(columnStatistics.getStringStatistics().getSum());
            builder.setStringStatistics(statisticsBuilder.build());
        }
        return builder.build();
    }

    private static DwrfProto.UserMetadataItem toUserMetadata(Map.Entry<String, Slice> entry) {
        return DwrfProto.UserMetadataItem.newBuilder().setName(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue().getBytes())).build();
    }

    @Override
    public int writeStripeFooter(SliceOutput output, StripeFooter footer) throws IOException {
        DwrfProto.StripeFooter footerProtobuf = DwrfProto.StripeFooter.newBuilder().addAllStreams((Iterable)footer.getStreams().stream().map(DwrfMetadataWriter::toStream).collect(ImmutableList.toImmutableList())).addAllColumns((Iterable)footer.getColumnEncodings().stream().map(DwrfMetadataWriter::toColumnEncoding).collect(ImmutableList.toImmutableList())).build();
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)footerProtobuf);
    }

    private static DwrfProto.Stream toStream(Stream stream) {
        return DwrfProto.Stream.newBuilder().setColumn(stream.getColumn()).setKind(DwrfMetadataWriter.toStreamKind(stream.getStreamKind())).setLength((long)stream.getLength()).setUseVInts(stream.isUseVInts()).build();
    }

    private static DwrfProto.Stream.Kind toStreamKind(Stream.StreamKind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return DwrfProto.Stream.Kind.PRESENT;
            }
            case DATA: {
                return DwrfProto.Stream.Kind.DATA;
            }
            case SECONDARY: {
                return DwrfProto.Stream.Kind.NANO_DATA;
            }
            case LENGTH: {
                return DwrfProto.Stream.Kind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return DwrfProto.Stream.Kind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return DwrfProto.Stream.Kind.DICTIONARY_COUNT;
            }
            case ROW_INDEX: {
                return DwrfProto.Stream.Kind.ROW_INDEX;
            }
        }
        throw new IllegalArgumentException("Unsupported stream kind: " + (Object)((Object)streamKind));
    }

    private static DwrfProto.ColumnEncoding toColumnEncoding(ColumnEncoding columnEncodings) {
        return DwrfProto.ColumnEncoding.newBuilder().setKind(DwrfMetadataWriter.toColumnEncoding(columnEncodings.getColumnEncodingKind())).setDictionarySize(columnEncodings.getDictionarySize()).build();
    }

    private static DwrfProto.ColumnEncoding.Kind toColumnEncoding(ColumnEncoding.ColumnEncodingKind columnEncodingKind) {
        switch (columnEncodingKind) {
            case DIRECT: {
                return DwrfProto.ColumnEncoding.Kind.DIRECT;
            }
            case DICTIONARY: {
                return DwrfProto.ColumnEncoding.Kind.DICTIONARY;
            }
        }
        throw new IllegalArgumentException("Unsupported column encoding kind: " + (Object)((Object)columnEncodingKind));
    }

    @Override
    public int writeRowIndexes(SliceOutput output, List<RowGroupIndex> rowGroupIndexes) throws IOException {
        DwrfProto.RowIndex rowIndexProtobuf = DwrfProto.RowIndex.newBuilder().addAllEntry((Iterable)rowGroupIndexes.stream().map(DwrfMetadataWriter::toRowGroupIndex).collect(ImmutableList.toImmutableList())).build();
        return DwrfMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)rowIndexProtobuf);
    }

    private static DwrfProto.RowIndexEntry toRowGroupIndex(RowGroupIndex rowGroupIndex) {
        return DwrfProto.RowIndexEntry.newBuilder().addAllPositions((Iterable)rowGroupIndex.getPositions().stream().map(Integer::longValue).collect(ImmutableList.toImmutableList())).setStatistics(DwrfMetadataWriter.toColumnStatistics(rowGroupIndex.getColumnStatistics())).build();
    }

    private static DwrfProto.CompressionKind toCompression(CompressionKind compressionKind) {
        switch (compressionKind) {
            case NONE: {
                return DwrfProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return DwrfProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return DwrfProto.CompressionKind.SNAPPY;
            }
            case LZ4: {
                return DwrfProto.CompressionKind.LZ4;
            }
        }
        throw new IllegalArgumentException("Unsupported compression kind: " + (Object)((Object)compressionKind));
    }

    private static int writeProtobufObject(OutputStream output, MessageLite object) throws IOException {
        CountingOutputStream countingOutput = new CountingOutputStream(output);
        object.writeTo((OutputStream)countingOutput);
        return Math.toIntExact(countingOutput.getCount());
    }
}

