/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.StripeFooter;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.util.List;

public class CompressedMetadataWriter
implements MetadataWriter {
    private final MetadataWriter metadataWriter;
    private final OrcOutputBuffer buffer;

    public CompressedMetadataWriter(MetadataWriter metadataWriter, CompressionKind compression, int bufferSize) {
        this.metadataWriter = metadataWriter;
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    @Override
    public List<Integer> getOrcMetadataVersion() {
        return this.metadataWriter.getOrcMetadataVersion();
    }

    @Override
    public int writePostscript(SliceOutput output, int footerLength, int metadataLength, CompressionKind compression, int compressionBlockSize) throws IOException {
        return this.metadataWriter.writePostscript(output, footerLength, metadataLength, compression, compressionBlockSize);
    }

    @Override
    public int writeMetadata(SliceOutput output, Metadata metadata) throws IOException {
        this.buffer.reset();
        this.metadataWriter.writeMetadata(this.buffer, metadata);
        return this.buffer.writeDataTo(output);
    }

    @Override
    public int writeFooter(SliceOutput output, Footer footer) throws IOException {
        this.buffer.reset();
        this.metadataWriter.writeFooter(this.buffer, footer);
        return this.buffer.writeDataTo(output);
    }

    @Override
    public int writeStripeFooter(SliceOutput output, StripeFooter footer) throws IOException {
        this.buffer.reset();
        this.metadataWriter.writeStripeFooter(this.buffer, footer);
        return this.buffer.writeDataTo(output);
    }

    @Override
    public int writeRowIndexes(SliceOutput output, List<RowGroupIndex> rowGroupIndexes) throws IOException {
        this.buffer.reset();
        this.metadataWriter.writeRowIndexes(this.buffer, rowGroupIndexes);
        return this.buffer.writeDataTo(output);
    }
}

