/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.checkpoint.InputStreamCheckpoint;
import com.google.common.base.MoreObjects;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import sun.misc.Unsafe;

public final class OrcInputStream
extends InputStream {
    private final OrcDataSourceId orcDataSourceId;
    private final FixedLengthSliceInput compressedSliceInput;
    private final Optional<OrcDecompressor> decompressor;
    private int currentCompressedBlockOffset;
    private FixedLengthSliceInput current;
    private byte[] buffer;
    private final LocalMemoryContext bufferMemoryUsage;
    private final LocalMemoryContext fixedMemoryUsage;

    public OrcInputStream(OrcDataSourceId orcDataSourceId, FixedLengthSliceInput sliceInput, Optional<OrcDecompressor> decompressor, AggregatedMemoryContext systemMemoryContext) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSource is null");
        Objects.requireNonNull(sliceInput, "sliceInput is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.bufferMemoryUsage = systemMemoryContext.newLocalMemoryContext();
        this.fixedMemoryUsage = systemMemoryContext.newLocalMemoryContext();
        this.fixedMemoryUsage.setBytes(sliceInput.length());
        if (!decompressor.isPresent()) {
            this.current = sliceInput;
            this.compressedSliceInput = Slices.EMPTY_SLICE.getInput();
        } else {
            this.compressedSliceInput = sliceInput;
            this.current = Slices.EMPTY_SLICE.getInput();
        }
    }

    @Override
    public void close() {
        this.current = null;
        this.fixedMemoryUsage.setBytes(this.compressedSliceInput.length());
        this.buffer = null;
        this.bufferMemoryUsage.setBytes(0L);
    }

    @Override
    public int available() {
        if (this.current == null) {
            return 0;
        }
        return this.current.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        int result = this.current.read();
        if (result != -1) {
            return result;
        }
        this.advance();
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.current.remaining() == 0L) {
            this.advance();
            if (this.current == null) {
                return -1;
            }
        }
        return this.current.read(b, off, length);
    }

    public void skipFully(long length) throws IOException {
        while (length > 0L) {
            long result = this.skip(length);
            if (result < 0L) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Unexpected end of stream");
            }
            length -= result;
        }
    }

    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        while (offset < length) {
            int result = this.read(buffer, offset, length - offset);
            if (result < 0) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Unexpected end of stream");
            }
            offset += result;
        }
    }

    public OrcDataSourceId getOrcDataSourceId() {
        return this.orcDataSourceId;
    }

    public long getCheckpoint() {
        if (this.current == null || this.current.position() == 0L && this.current.remaining() == 0L) {
            return InputStreamCheckpoint.createInputStreamCheckpoint(Math.toIntExact(this.compressedSliceInput.position()), 0);
        }
        return InputStreamCheckpoint.createInputStreamCheckpoint(this.currentCompressedBlockOffset, Math.toIntExact(this.current.position()));
    }

    public boolean seekToCheckpoint(long checkpoint) throws IOException {
        boolean discardedBuffer;
        int compressedBlockOffset = InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint);
        int decompressedOffset = InputStreamCheckpoint.decodeDecompressedOffset(checkpoint);
        if (compressedBlockOffset != this.currentCompressedBlockOffset) {
            if (!this.decompressor.isPresent()) {
                throw new OrcCorruptionException(this.orcDataSourceId, "Reset stream has a compressed block offset but stream is not compressed");
            }
            this.compressedSliceInput.setPosition((long)compressedBlockOffset);
            this.current = Slices.EMPTY_SLICE.getInput();
            discardedBuffer = true;
        } else {
            discardedBuffer = false;
        }
        if ((long)decompressedOffset != this.current.position()) {
            this.current.setPosition(0L);
            if (this.current.remaining() < (long)decompressedOffset) {
                decompressedOffset = (int)((long)decompressedOffset - this.current.remaining());
                this.advance();
            }
            this.current.setPosition((long)decompressedOffset);
        }
        return discardedBuffer;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.current == null || n <= 0L) {
            return -1L;
        }
        long result = this.current.skip(n);
        if (result != 0L) {
            return result;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.current.skip(n - 1L);
    }

    private void advance() throws IOException {
        if (this.compressedSliceInput == null || this.compressedSliceInput.remaining() == 0L) {
            this.current = null;
            return;
        }
        this.currentCompressedBlockOffset = Math.toIntExact(this.compressedSliceInput.position());
        int b0 = this.compressedSliceInput.readUnsignedByte();
        int b1 = this.compressedSliceInput.readUnsignedByte();
        int b2 = this.compressedSliceInput.readUnsignedByte();
        boolean isUncompressed = (b0 & 1) == 1;
        int chunkLength = b2 << 15 | b1 << 7 | b0 >>> 1;
        if (chunkLength < 0 || (long)chunkLength > this.compressedSliceInput.remaining()) {
            throw new OrcCorruptionException(this.orcDataSourceId, "The chunkLength (%s) must not be negative or greater than remaining size (%s)", chunkLength, this.compressedSliceInput.remaining());
        }
        Slice chunk = this.compressedSliceInput.readSlice(chunkLength);
        if (isUncompressed) {
            this.current = chunk.getInput();
        } else {
            OrcDecompressor.OutputBuffer output = new OrcDecompressor.OutputBuffer(){

                @Override
                public byte[] initialize(int size) {
                    if (OrcInputStream.this.buffer == null || size > OrcInputStream.this.buffer.length) {
                        OrcInputStream.access$002(OrcInputStream.this, new byte[size]);
                        OrcInputStream.this.bufferMemoryUsage.setBytes((long)OrcInputStream.this.buffer.length);
                    }
                    return OrcInputStream.this.buffer;
                }

                @Override
                public byte[] grow(int size) {
                    if (size > OrcInputStream.this.buffer.length) {
                        OrcInputStream.access$002(OrcInputStream.this, Arrays.copyOfRange(OrcInputStream.this.buffer, 0, size));
                        OrcInputStream.this.bufferMemoryUsage.setBytes((long)OrcInputStream.this.buffer.length);
                    }
                    return OrcInputStream.this.buffer;
                }
            };
            int uncompressedSize = this.decompressor.get().decompress((byte[])chunk.getBase(), (int)(chunk.getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), chunk.length(), output);
            this.current = Slices.wrappedBuffer((byte[])this.buffer, (int)0, (int)uncompressedSize).getInput();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.orcDataSourceId).add("compressedOffset", this.compressedSliceInput.position()).add("uncompressedOffset", this.current == null ? null : Long.valueOf(this.current.position())).add("decompressor", (Object)this.decompressor.map(Object::toString).orElse("none")).toString();
    }

    static /* synthetic */ byte[] access$002(OrcInputStream x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }
}

