/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SliceStreamReader;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDirectStreamReader
implements StreamReader {
    private static final int ONE_GIGABYTE = Math.toIntExact(new DataSize(1.0, DataSize.Unit.GIGABYTE).toBytes());
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    @Nonnull
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private int[] lengthVector = new int[0];
    @Nonnull
    private InputStreamSource<ByteArrayInputStream> dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    @Nullable
    private ByteArrayInputStream dataStream;
    private boolean rowGroupOpen;

    public SliceDirectStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but length stream is not present");
                }
                long dataSkipSize = this.lengthStream.sum(this.readOffset);
                if (dataSkipSize > 0L) {
                    if (this.dataStream == null) {
                        throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                    }
                    this.dataStream.skip(dataSkipSize);
                }
            }
        }
        boolean[] isNullVector = new boolean[this.nextBatchSize];
        int[] offsetVector = new int[this.nextBatchSize + 1];
        if (this.lengthVector.length < this.nextBatchSize) {
            this.lengthVector = new int[this.nextBatchSize];
        }
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but length stream is not present");
            }
            Arrays.fill(isNullVector, false);
            this.lengthStream.nextIntVector(this.nextBatchSize, this.lengthVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, isNullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but length stream is not present");
                }
                this.lengthStream.nextIntVector(this.nextBatchSize, this.lengthVector, isNullVector);
            }
        }
        long totalLength = 0L;
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (isNullVector[i]) continue;
            totalLength += (long)this.lengthVector[i];
        }
        int currentBatchSize = this.nextBatchSize;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        if (totalLength == 0L) {
            return new VariableWidthBlock(currentBatchSize, Slices.EMPTY_SLICE, offsetVector, isNullVector);
        }
        if (totalLength > (long)ONE_GIGABYTE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Values in column \"%s\" are too large to process for Presto. %s column values are larger than 1GB [%s]", this.streamDescriptor.getFieldName(), this.nextBatchSize, this.streamDescriptor.getOrcDataSourceId()));
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
        }
        byte[] data = new byte[Math.toIntExact(totalLength)];
        Slice slice = Slices.wrappedBuffer((byte[])data);
        offsetVector[0] = 0;
        for (int i = 0; i < currentBatchSize; ++i) {
            if (isNullVector[i]) {
                offsetVector[i + 1] = offsetVector[i];
                continue;
            }
            int offset = offsetVector[i];
            int length = this.lengthVector[i];
            this.dataStream.next(data, offset, offset + length);
            int truncatedLength = SliceStreamReader.computeTruncatedLength(slice, offset, length, type);
            Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            offsetVector[i + 1] = offsetVector[i] + truncatedLength;
        }
        return new VariableWidthBlock(currentBatchSize, slice, offsetVector, isNullVector);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataByteSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dataByteSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

