/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.Objects;
import javax.annotation.Nullable;

public class StringStatistics
implements RangeStatistics<Slice> {
    public static final long STRING_VALUE_BYTES_OVERHEAD = 5L;
    @Nullable
    private final Slice minimum;
    @Nullable
    private final Slice maximum;
    private final long sum;

    public StringStatistics(Slice minimum, Slice maximum, long sum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum.compareTo(maximum) <= 0 ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.minimum = minimum;
        this.maximum = maximum;
        this.sum = sum;
    }

    @Override
    public Slice getMin() {
        return this.minimum;
    }

    @Override
    public Slice getMax() {
        return this.maximum;
    }

    public long getSum() {
        return this.sum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringStatistics that = (StringStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum) && Objects.equals(this.sum, that.sum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum, this.sum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)(this.minimum == null ? "<null>" : this.minimum.toStringUtf8())).add("max", (Object)(this.maximum == null ? "<null>" : this.maximum.toStringUtf8())).add("sum", this.sum).toString();
    }
}

