/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class IntegerStatistics
implements RangeStatistics<Long> {
    public static final long INTEGER_VALUE_BYTES = 9L;
    private final Long minimum;
    private final Long maximum;
    private final Long sum;

    public IntegerStatistics(Long minimum, Long maximum, Long sum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum <= maximum ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.minimum = minimum;
        this.maximum = maximum;
        this.sum = sum;
    }

    @Override
    public Long getMin() {
        return this.minimum;
    }

    @Override
    public Long getMax() {
        return this.maximum;
    }

    public Long getSum() {
        return this.sum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerStatistics that = (IntegerStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum) && Objects.equals(this.sum, that.sum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum, this.sum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.minimum).add("max", (Object)this.maximum).add("sum", (Object)this.sum).toString();
    }
}

