/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class OrcType {
    private final OrcTypeKind orcTypeKind;
    private final List<Integer> fieldTypeIndexes;
    private final List<String> fieldNames;
    private final Optional<Integer> length;
    private final Optional<Integer> precision;
    private final Optional<Integer> scale;

    private OrcType(OrcTypeKind orcTypeKind) {
        this(orcTypeKind, (List<Integer>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private OrcType(OrcTypeKind orcTypeKind, int length) {
        this(orcTypeKind, (List<Integer>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.of(length), Optional.empty(), Optional.empty());
    }

    private OrcType(OrcTypeKind orcTypeKind, int precision, int scale) {
        this(orcTypeKind, (List<Integer>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.of(precision), Optional.of(scale));
    }

    private OrcType(OrcTypeKind orcTypeKind, List<Integer> fieldTypeIndexes, List<String> fieldNames) {
        this(orcTypeKind, fieldTypeIndexes, fieldNames, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public OrcType(OrcTypeKind orcTypeKind, List<Integer> fieldTypeIndexes, List<String> fieldNames, Optional<Integer> length, Optional<Integer> precision, Optional<Integer> scale) {
        this.orcTypeKind = Objects.requireNonNull(orcTypeKind, "typeKind is null");
        this.fieldTypeIndexes = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldTypeIndexes, "fieldTypeIndexes is null"));
        if (fieldNames == null || fieldNames.isEmpty() && !fieldTypeIndexes.isEmpty()) {
            this.fieldNames = null;
        } else {
            this.fieldNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldNames, "fieldNames is null"));
            Preconditions.checkArgument((fieldNames.size() == fieldTypeIndexes.size() ? 1 : 0) != 0, (Object)"fieldNames and fieldTypeIndexes have different sizes");
        }
        this.length = Objects.requireNonNull(length, "length is null");
        this.precision = Objects.requireNonNull(precision, "precision is null");
        this.scale = Objects.requireNonNull(scale, "scale can not be null");
    }

    public OrcTypeKind getOrcTypeKind() {
        return this.orcTypeKind;
    }

    public int getFieldCount() {
        return this.fieldTypeIndexes.size();
    }

    public int getFieldTypeIndex(int field) {
        return this.fieldTypeIndexes.get(field);
    }

    public List<Integer> getFieldTypeIndexes() {
        return this.fieldTypeIndexes;
    }

    public String getFieldName(int field) {
        return this.fieldNames.get(field);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Optional<Integer> getLength() {
        return this.length;
    }

    public Optional<Integer> getPrecision() {
        return this.precision;
    }

    public Optional<Integer> getScale() {
        return this.scale;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcTypeKind", (Object)this.orcTypeKind).add("fieldTypeIndexes", this.fieldTypeIndexes).add("fieldNames", this.fieldNames).toString();
    }

    private static List<OrcType> toOrcType(int nextFieldTypeIndex, Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BOOLEAN));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BYTE));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.SHORT));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.INT));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.LONG));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DOUBLE));
        }
        if (RealType.REAL.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.FLOAT));
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return ImmutableList.of((Object)new OrcType(OrcTypeKind.STRING));
            }
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.VARCHAR, varcharType.getLengthSafe()));
        }
        if (type instanceof CharType) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.CHAR, ((CharType)type).getLength()));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BINARY));
        }
        if (DateType.DATE.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DATE));
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.TIMESTAMP));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DECIMAL, decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            return OrcType.createOrcArrayType(nextFieldTypeIndex, (Type)type.getTypeParameters().get(0));
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            return OrcType.createOrcMapType(nextFieldTypeIndex, (Type)type.getTypeParameters().get(0), (Type)type.getTypeParameters().get(1));
        }
        if (type.getTypeSignature().getBase().equals("row")) {
            List<String> fieldNames = type.getTypeSignature().getParameters().stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getName).collect(Collectors.toList());
            List fieldTypes = type.getTypeParameters();
            return OrcType.createOrcRowType(nextFieldTypeIndex, fieldNames, fieldTypes);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }

    private static List<OrcType> createOrcArrayType(int nextFieldTypeIndex, Type itemType) {
        List<OrcType> itemTypes = OrcType.toOrcType(++nextFieldTypeIndex, itemType);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.LIST, (List<Integer>)ImmutableList.of((Object)nextFieldTypeIndex), (List<String>)ImmutableList.of((Object)"item")));
        orcTypes.addAll(itemTypes);
        return orcTypes;
    }

    private static List<OrcType> createOrcMapType(int nextFieldTypeIndex, Type keyType, Type valueType) {
        List<OrcType> keyTypes = OrcType.toOrcType(++nextFieldTypeIndex, keyType);
        List<OrcType> valueTypes = OrcType.toOrcType(nextFieldTypeIndex + keyTypes.size(), valueType);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.MAP, (List<Integer>)ImmutableList.of((Object)nextFieldTypeIndex, (Object)(nextFieldTypeIndex + keyTypes.size())), (List<String>)ImmutableList.of((Object)"key", (Object)"value")));
        orcTypes.addAll(keyTypes);
        orcTypes.addAll(valueTypes);
        return orcTypes;
    }

    public static List<OrcType> createOrcRowType(int nextFieldTypeIndex, List<String> fieldNames, List<Type> fieldTypes) {
        ++nextFieldTypeIndex;
        ArrayList<Integer> fieldTypeIndexes = new ArrayList<Integer>();
        ArrayList<List<OrcType>> fieldTypesList = new ArrayList<List<OrcType>>();
        for (Type fieldType : fieldTypes) {
            fieldTypeIndexes.add(nextFieldTypeIndex);
            List<OrcType> fieldOrcTypes = OrcType.toOrcType(nextFieldTypeIndex, fieldType);
            fieldTypesList.add(fieldOrcTypes);
            nextFieldTypeIndex += fieldOrcTypes.size();
        }
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.STRUCT, fieldTypeIndexes, fieldNames));
        fieldTypesList.forEach(orcTypes::addAll);
        return orcTypes;
    }

    public static enum OrcTypeKind {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        DECIMAL,
        FLOAT,
        DOUBLE,
        STRING,
        VARCHAR,
        CHAR,
        BINARY,
        DATE,
        TIMESTAMP,
        LIST,
        MAP,
        STRUCT,
        UNION;

    }
}

