/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcWriterFlushStats;
import com.google.common.base.MoreObjects;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class OrcWriterStats {
    private final OrcWriterFlushStats allFlush = new OrcWriterFlushStats("ALL");
    private final OrcWriterFlushStats maxRowsFlush = new OrcWriterFlushStats(FlushReason.MAX_BYTES.name());
    private final OrcWriterFlushStats maxBytesFlush = new OrcWriterFlushStats(FlushReason.MAX_ROWS.name());
    private final OrcWriterFlushStats dictionaryFullFlush = new OrcWriterFlushStats(FlushReason.DICTIONARY_FULL.name());
    private final OrcWriterFlushStats closedFlush = new OrcWriterFlushStats(FlushReason.CLOSED.name());

    public void recordStripeWritten(FlushReason flushReason, long stripeBytes, int stripeRows, int dictionaryBytes) {
        this.getFlushStats(flushReason).recordStripeWritten(stripeBytes, stripeRows, dictionaryBytes);
        this.allFlush.recordStripeWritten(stripeBytes, stripeRows, dictionaryBytes);
    }

    @Managed
    @Nested
    public OrcWriterFlushStats getAllFlush() {
        return this.allFlush;
    }

    @Managed
    @Nested
    public OrcWriterFlushStats getMaxRowsFlush() {
        return this.maxRowsFlush;
    }

    @Managed
    @Nested
    public OrcWriterFlushStats getMaxBytesFlush() {
        return this.maxBytesFlush;
    }

    @Managed
    @Nested
    public OrcWriterFlushStats getDictionaryFullFlush() {
        return this.dictionaryFullFlush;
    }

    @Managed
    @Nested
    public OrcWriterFlushStats getClosedFlush() {
        return this.closedFlush;
    }

    private OrcWriterFlushStats getFlushStats(FlushReason flushReason) {
        switch (flushReason) {
            case MAX_ROWS: {
                return this.maxRowsFlush;
            }
            case MAX_BYTES: {
                return this.maxBytesFlush;
            }
            case DICTIONARY_FULL: {
                return this.dictionaryFullFlush;
            }
            case CLOSED: {
                return this.closedFlush;
            }
        }
        throw new IllegalArgumentException("unknown flush reason " + (Object)((Object)flushReason));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allFlush", (Object)this.allFlush).add("maxRowsFlush", (Object)this.maxRowsFlush).add("maxBytesFlush", (Object)this.maxBytesFlush).add("dictionaryFullFlush", (Object)this.dictionaryFullFlush).add("closedFlush", (Object)this.closedFlush).toString();
    }

    public static enum FlushReason {
        MAX_ROWS,
        MAX_BYTES,
        DICTIONARY_FULL,
        CLOSED;

    }
}

