/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.Objects;

public class OrcWriterOptions {
    private static final DataSize DEFAULT_STRIPE_MAX_SIZE = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private static final int DEFAULT_STRIPE_MIN_ROW_COUNT = 100000;
    private static final int DEFAULT_STRIPE_MAX_ROW_COUNT = 10000000;
    private static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    private static final DataSize DEFAULT_DICTIONARY_MAX_MEMORY = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private final DataSize stripeMaxSize;
    private final int stripeMinRowCount;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final DataSize dictionaryMaxMemory;

    public OrcWriterOptions() {
        this(DEFAULT_STRIPE_MAX_SIZE, 100000, 10000000, 10000, DEFAULT_DICTIONARY_MAX_MEMORY);
    }

    private OrcWriterOptions(DataSize stripeMaxSize, int stripeMinRowCount, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMaxMemory) {
        Objects.requireNonNull(stripeMaxSize, "stripeMaxSize is null");
        Preconditions.checkArgument((stripeMinRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMinRowCount must be at least 1");
        Preconditions.checkArgument((stripeMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be at least 1");
        Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
        Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
        this.stripeMaxSize = stripeMaxSize;
        this.stripeMinRowCount = stripeMinRowCount;
        this.stripeMaxRowCount = stripeMaxRowCount;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.dictionaryMaxMemory = dictionaryMaxMemory;
    }

    public DataSize getStripeMaxSize() {
        return this.stripeMaxSize;
    }

    public int getStripeMinRowCount() {
        return this.stripeMinRowCount;
    }

    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    public OrcWriterOptions withStripeMaxSize(DataSize stripeMaxSize) {
        return new OrcWriterOptions(stripeMaxSize, this.stripeMinRowCount, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory);
    }

    public OrcWriterOptions withStripeMinRowCount(int stripeMinRowCount) {
        return new OrcWriterOptions(this.stripeMaxSize, stripeMinRowCount, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory);
    }

    public OrcWriterOptions withStripeMaxRowCount(int stripeMaxRowCount) {
        return new OrcWriterOptions(this.stripeMaxSize, this.stripeMinRowCount, stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory);
    }

    public OrcWriterOptions withRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        return new OrcWriterOptions(this.stripeMaxSize, this.stripeMinRowCount, this.stripeMaxRowCount, rowGroupMaxRowCount, this.dictionaryMaxMemory);
    }

    public OrcWriterOptions withDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        return new OrcWriterOptions(this.stripeMaxSize, this.stripeMinRowCount, this.stripeMaxRowCount, this.rowGroupMaxRowCount, dictionaryMaxMemory);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stripeMaxSize", (Object)this.stripeMaxSize).add("stripeMinRowCount", this.stripeMinRowCount).add("stripeMaxRowCount", this.stripeMaxRowCount).add("rowGroupMaxRowCount", this.rowGroupMaxRowCount).add("dictionaryMaxMemory", (Object)this.dictionaryMaxMemory).toString();
    }
}

