/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfMetadataWriter;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.BooleanStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ShortDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.ColumnarArray;
import com.facebook.presto.spi.block.ColumnarMap;
import com.facebook.presto.spi.block.ColumnarRow;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;

public class OrcWriteValidation {
    private final List<Integer> version;
    private final CompressionKind compression;
    private final int rowGroupMaxRowCount;
    private final List<String> columnNames;
    private final Map<String, Slice> metadata;
    private final WriteChecksum checksum;
    private final Map<Long, List<RowGroupStatistics>> rowGroupStatistics;
    private final Map<Long, StripeStatistics> stripeStatistics;
    private final List<ColumnStatistics> fileStatistics;

    private OrcWriteValidation(List<Integer> version, CompressionKind compression, int rowGroupMaxRowCount, List<String> columnNames, Map<String, Slice> metadata, WriteChecksum checksum, Map<Long, List<RowGroupStatistics>> rowGroupStatistics, Map<Long, StripeStatistics> stripeStatistics, List<ColumnStatistics> fileStatistics) {
        this.version = version;
        this.compression = compression;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.columnNames = columnNames;
        this.metadata = metadata;
        this.checksum = checksum;
        this.rowGroupStatistics = rowGroupStatistics;
        this.stripeStatistics = stripeStatistics;
        this.fileStatistics = fileStatistics;
    }

    public List<Integer> getVersion() {
        return this.version;
    }

    public CompressionKind getCompression() {
        return this.compression;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Map<String, Slice> getMetadata() {
        return this.metadata;
    }

    public void validateMetadata(OrcDataSourceId orcDataSourceId, Map<String, Slice> actualMetadata) throws OrcCorruptionException {
        Map filteredMetadata = (Map)actualMetadata.entrySet().stream().filter(entry -> !DwrfMetadataWriter.STATIC_METADATA.containsKey(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!this.metadata.equals(filteredMetadata)) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected metadata");
        }
    }

    public WriteChecksum getChecksum() {
        return this.checksum;
    }

    public void validateFileStatistics(OrcDataSourceId orcDataSourceId, List<ColumnStatistics> actualFileStatistics) throws OrcCorruptionException {
        if (actualFileStatistics.isEmpty()) {
            return;
        }
        OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "file", actualFileStatistics, this.fileStatistics);
    }

    public void validateStripeStatistics(OrcDataSourceId orcDataSourceId, List<StripeInformation> actualStripes, List<StripeStatistics> actualStripeStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(actualStripes, "actualStripes is null");
        Objects.requireNonNull(actualStripeStatistics, "actualStripeStatistics is null");
        if (actualStripeStatistics.isEmpty()) {
            return;
        }
        if (actualStripeStatistics.size() != this.stripeStatistics.size()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of columns in stripe statistics");
        }
        for (int stripeIndex = 0; stripeIndex < actualStripes.size(); ++stripeIndex) {
            long stripeOffset = actualStripes.get(stripeIndex).getOffset();
            StripeStatistics actual = actualStripeStatistics.get(stripeIndex);
            this.validateStripeStatistics(orcDataSourceId, stripeOffset, actual.getColumnStatistics());
        }
    }

    public void validateStripeStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, List<ColumnStatistics> actual) throws OrcCorruptionException {
        StripeStatistics expected = this.stripeStatistics.get(stripeOffset);
        if (expected == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Stripe at " + stripeOffset, actual, expected.getColumnStatistics());
    }

    public void validateRowGroupStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, Map<Integer, List<RowGroupIndex>> actualRowGroupStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(actualRowGroupStatistics, "actualRowGroupStatistics is null");
        List<RowGroupStatistics> expectedRowGroupStatistics = this.rowGroupStatistics.get(stripeOffset);
        if (expectedRowGroupStatistics == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        int rowGroupCount = expectedRowGroupStatistics.size();
        for (Map.Entry<Integer, List<RowGroupIndex>> entry : actualRowGroupStatistics.entrySet()) {
            if (entry.getValue().size() == rowGroupCount) continue;
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected row group count stripe in at offset %s", stripeOffset);
        }
        for (int rowGroupIndex = 0; rowGroupIndex < expectedRowGroupStatistics.size(); ++rowGroupIndex) {
            Map<Integer, ColumnStatistics> expectedStatistics = expectedRowGroupStatistics.get(rowGroupIndex).getColumnStatistics();
            if (!expectedStatistics.keySet().equals(actualRowGroupStatistics.keySet())) {
                throw new OrcCorruptionException(orcDataSourceId, "Unexpected column in row group %s in stripe at offset %s", stripeOffset);
            }
            for (Map.Entry<Integer, ColumnStatistics> entry : expectedStatistics.entrySet()) {
                int columnIndex = entry.getKey();
                ColumnStatistics actual = actualRowGroupStatistics.get(columnIndex).get(rowGroupIndex).getColumnStatistics();
                ColumnStatistics expected = entry.getValue();
                OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Row group " + rowGroupIndex + " in stripe at offset " + stripeOffset, actual, expected);
            }
        }
    }

    public void validateRowGroupStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, int rowGroupIndex, List<ColumnStatistics> actual) throws OrcCorruptionException {
        List<RowGroupStatistics> rowGroups = this.rowGroupStatistics.get(stripeOffset);
        if (rowGroups == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        if (rowGroups.size() <= rowGroupIndex) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
        }
        Map<Integer, ColumnStatistics> expectedByColumnIndex = rowGroups.get(rowGroupIndex).getColumnStatistics();
        List expected = (List)IntStream.range(1, actual.size()).mapToObj(expectedByColumnIndex::get).collect(ImmutableList.toImmutableList());
        actual = actual.subList(1, actual.size());
        OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Row group " + rowGroupIndex + " in stripe at offset " + stripeOffset, actual, expected);
    }

    private static void validateColumnStatisticsEquivalent(OrcDataSourceId orcDataSourceId, String name, List<ColumnStatistics> actualColumnStatistics, List<ColumnStatistics> expectedColumnStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(actualColumnStatistics, "actualColumnStatistics is null");
        Objects.requireNonNull(expectedColumnStatistics, "expectedColumnStatistics is null");
        if (actualColumnStatistics.size() != expectedColumnStatistics.size()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of columns in %s statistics", name);
        }
        for (int i = 0; i < actualColumnStatistics.size(); ++i) {
            ColumnStatistics actual = actualColumnStatistics.get(i);
            ColumnStatistics expected = expectedColumnStatistics.get(i);
            OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, name + " column " + i, actual, expected);
        }
    }

    private static void validateColumnStatisticsEquivalent(OrcDataSourceId orcDataSourceId, String name, ColumnStatistics actualColumnStatistics, ColumnStatistics expectedColumnStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(actualColumnStatistics, "actualColumnStatistics is null");
        Objects.requireNonNull(expectedColumnStatistics, "expectedColumnStatistics is null");
        if (actualColumnStatistics.getNumberOfValues() != expectedColumnStatistics.getNumberOfValues()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of values in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getBooleanStatistics(), expectedColumnStatistics.getBooleanStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected boolean counts in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getIntegerStatistics(), expectedColumnStatistics.getIntegerStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected integer range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getDoubleStatistics(), expectedColumnStatistics.getDoubleStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected double range in %s statistics", name);
        }
        StringStatistics expectedStringStatistics = expectedColumnStatistics.getStringStatistics();
        if (expectedStringStatistics != null) {
            expectedStringStatistics = new StringStatistics(OrcMetadataReader.minStringTruncateToValidRange(expectedStringStatistics.getMin(), PostScript.HiveWriterVersion.ORC_HIVE_8732), OrcMetadataReader.maxStringTruncateToValidRange(expectedStringStatistics.getMax(), PostScript.HiveWriterVersion.ORC_HIVE_8732), expectedStringStatistics.getSum());
        }
        if (!Objects.equals(actualColumnStatistics.getStringStatistics(), expectedStringStatistics)) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected string range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getDateStatistics(), expectedColumnStatistics.getDateStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected date range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getDecimalStatistics(), expectedColumnStatistics.getDecimalStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected decimal range in %s statistics", name);
        }
        if (!Objects.equals((Object)actualColumnStatistics.getBloomFilter(), (Object)expectedColumnStatistics.getBloomFilter())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected bloom filter in %s statistics", name);
        }
    }

    public static class OrcWriteValidationBuilder {
        private List<Integer> version;
        private CompressionKind compression;
        private int rowGroupMaxRowCount;
        private List<String> columnNames;
        private final Map<String, Slice> metadata = new HashMap<String, Slice>();
        private final WriteChecksumBuilder checksum;
        private List<RowGroupStatistics> currentRowGroupStatistics = new ArrayList<RowGroupStatistics>();
        private final Map<Long, List<RowGroupStatistics>> rowGroupStatisticsByStripe = new HashMap<Long, List<RowGroupStatistics>>();
        private final Map<Long, StripeStatistics> stripeStatistics = new HashMap<Long, StripeStatistics>();
        private List<ColumnStatistics> fileStatistics;

        public OrcWriteValidationBuilder(List<Type> types) {
            this.checksum = new WriteChecksumBuilder(types);
        }

        public OrcWriteValidationBuilder setVersion(List<Integer> version) {
            this.version = ImmutableList.copyOf(version);
            return this;
        }

        public void setCompression(CompressionKind compression) {
            this.compression = compression;
        }

        public void setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
            this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        }

        public OrcWriteValidationBuilder setColumnNames(List<String> columnNames) {
            this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
            return this;
        }

        public OrcWriteValidationBuilder addMetadataProperty(String key, Slice value) {
            this.metadata.put(key, value);
            return this;
        }

        public OrcWriteValidationBuilder addStripe(int rowCount) {
            this.checksum.addStripe(rowCount);
            return this;
        }

        public OrcWriteValidationBuilder addPage(Page page) {
            this.checksum.addPage(page);
            return this;
        }

        public void addRowGroupStatistics(Map<Integer, ColumnStatistics> columnStatistics) {
            this.currentRowGroupStatistics.add(new RowGroupStatistics(columnStatistics));
        }

        public void addStripeStatistics(long stripStartOffset, StripeStatistics columnStatistics) {
            this.stripeStatistics.put(stripStartOffset, columnStatistics);
            this.rowGroupStatisticsByStripe.put(stripStartOffset, this.currentRowGroupStatistics);
            this.currentRowGroupStatistics = new ArrayList<RowGroupStatistics>();
        }

        public void setFileStatistics(List<ColumnStatistics> fileStatistics) {
            this.fileStatistics = fileStatistics;
        }

        public OrcWriteValidation build() {
            return new OrcWriteValidation(this.version, this.compression, this.rowGroupMaxRowCount, this.columnNames, this.metadata, this.checksum.build(), this.rowGroupStatisticsByStripe, this.stripeStatistics, this.fileStatistics);
        }
    }

    private static class RowGroupStatistics {
        private final Map<Integer, ColumnStatistics> columnStatistics;

        public RowGroupStatistics(Map<Integer, ColumnStatistics> columnStatistics) {
            this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
        }

        public Map<Integer, ColumnStatistics> getColumnStatistics() {
            return this.columnStatistics;
        }
    }

    private static class CountStatisticsBuilder
    implements StatisticsBuilder {
        private long rowCount;

        private CountStatisticsBuilder() {
        }

        @Override
        public void addBlock(Type type, Block block) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                ++this.rowCount;
            }
        }

        @Override
        public ColumnStatistics buildColumnStatistics() {
            return new ColumnStatistics(this.rowCount, 0L, null, null, null, null, null, null, null, null);
        }
    }

    private static class ColumnStatisticsValidation {
        private final Type type;
        private final StatisticsBuilder statisticsBuilder;
        private final Function<Block, List<Block>> fieldExtractor;
        private final List<ColumnStatisticsValidation> fieldBuilders;

        private ColumnStatisticsValidation(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                this.statisticsBuilder = new BooleanStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TinyintType.TINYINT.equals((Object)type)) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (SmallintType.SMALLINT.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (IntegerType.INTEGER.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (BigintType.BIGINT.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (DoubleType.DOUBLE.equals((Object)type)) {
                this.statisticsBuilder = new DoubleStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (RealType.REAL.equals((Object)type)) {
                this.statisticsBuilder = new DoubleStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof VarcharType) {
                this.statisticsBuilder = new StringStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof CharType) {
                this.statisticsBuilder = new StringStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
                this.statisticsBuilder = new BinaryStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (DateType.DATE.equals((Object)type)) {
                this.statisticsBuilder = new DateStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                this.statisticsBuilder = decimalType.isShort() ? new ShortDecimalStatisticsBuilder(decimalType.getScale()) : new LongDecimalStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type.getTypeSignature().getBase().equals("array")) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> ImmutableList.of((Object)ColumnarArray.toColumnarArray((Block)block).getElementsBlock());
                this.fieldBuilders = ImmutableList.of((Object)new ColumnStatisticsValidation((Type)Iterables.getOnlyElement((Iterable)type.getTypeParameters())));
            } else if (type.getTypeSignature().getBase().equals("map")) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> {
                    ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
                    return ImmutableList.of((Object)columnarMap.getKeysBlock(), (Object)columnarMap.getValuesBlock());
                };
                this.fieldBuilders = (List)type.getTypeParameters().stream().map(ColumnStatisticsValidation::new).collect(ImmutableList.toImmutableList());
            } else if (type.getTypeSignature().getBase().equals("row")) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> {
                    ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
                    ImmutableList.Builder fields = ImmutableList.builder();
                    for (int index = 0; index < columnarRow.getFieldCount(); ++index) {
                        fields.add((Object)columnarRow.getField(index));
                    }
                    return fields.build();
                };
                this.fieldBuilders = (List)type.getTypeParameters().stream().map(ColumnStatisticsValidation::new).collect(ImmutableList.toImmutableList());
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
            }
        }

        private void addBlock(Block block) {
            this.statisticsBuilder.addBlock(this.type, block);
            List<Block> fields = this.fieldExtractor.apply(block);
            for (int i = 0; i < this.fieldBuilders.size(); ++i) {
                this.fieldBuilders.get(i).addBlock(fields.get(i));
            }
        }

        private void build(ImmutableList.Builder<ColumnStatistics> output) {
            output.add((Object)this.statisticsBuilder.buildColumnStatistics());
            this.fieldBuilders.forEach(fieldBuilders -> fieldBuilders.build(output));
        }
    }

    public static class StatisticsValidation {
        private final List<Type> types;
        private List<ColumnStatisticsValidation> columnStatisticsValidations;
        private long rowCount;

        private StatisticsValidation(List<Type> types) {
            this.types = Objects.requireNonNull(types, "types is null");
            this.columnStatisticsValidations = (List)types.stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
        }

        public static StatisticsValidation createWriteStatisticsBuilder(Map<Integer, Type> readColumns) {
            Objects.requireNonNull(readColumns, "readColumns is null");
            Preconditions.checkArgument((!readColumns.isEmpty() ? 1 : 0) != 0, (Object)"readColumns is empty");
            int columnCount = readColumns.keySet().stream().mapToInt(Integer::intValue).max().getAsInt() + 1;
            Preconditions.checkArgument((readColumns.size() == columnCount ? 1 : 0) != 0, (Object)"statistics validation requires all columns to be read");
            ImmutableList.Builder types = ImmutableList.builder();
            for (int column = 0; column < columnCount; ++column) {
                Type type = readColumns.get(column);
                Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"statistics validation requires all columns to be read");
                types.add((Object)type);
            }
            return new StatisticsValidation((List<Type>)types.build());
        }

        public void reset() {
            this.rowCount = 0L;
            this.columnStatisticsValidations = (List)this.types.stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
        }

        public void addPage(Page page) {
            this.rowCount += (long)page.getPositionCount();
            for (int channel = 0; channel < this.columnStatisticsValidations.size(); ++channel) {
                this.columnStatisticsValidations.get(channel).addBlock(page.getBlock(channel));
            }
        }

        public List<ColumnStatistics> build() {
            ImmutableList.Builder statisticsBuilders = ImmutableList.builder();
            if (this.rowCount > 0L) {
                statisticsBuilders.add((Object)new ColumnStatistics(this.rowCount, 0L, null, null, null, null, null, null, null, null));
                this.columnStatisticsValidations.forEach(validation -> ((ColumnStatisticsValidation)validation).build((ImmutableList.Builder<ColumnStatistics>)statisticsBuilders));
            }
            return statisticsBuilders.build();
        }
    }

    public static class WriteChecksumBuilder {
        private static final long NULL_HASH_CODE = 7944063686788161739L;
        private final List<Type> types;
        private long totalRowCount;
        private final List<XxHash64> columnHashes;
        private final XxHash64 stripeHash = new XxHash64();
        private final byte[] longBuffer = new byte[8];
        private final Slice longSlice = Slices.wrappedBuffer((byte[])this.longBuffer);

        private WriteChecksumBuilder(List<Type> types) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            ImmutableList.Builder columnHashes = ImmutableList.builder();
            for (Type ignored : types) {
                columnHashes.add((Object)new XxHash64());
            }
            this.columnHashes = columnHashes.build();
        }

        public static WriteChecksumBuilder createWriteChecksumBuilder(Map<Integer, Type> readColumns) {
            Objects.requireNonNull(readColumns, "readColumns is null");
            Preconditions.checkArgument((!readColumns.isEmpty() ? 1 : 0) != 0, (Object)"readColumns is empty");
            int columnCount = readColumns.keySet().stream().mapToInt(Integer::intValue).max().getAsInt() + 1;
            Preconditions.checkArgument((readColumns.size() == columnCount ? 1 : 0) != 0, (Object)"checksum requires all columns to be read");
            ImmutableList.Builder types = ImmutableList.builder();
            for (int column = 0; column < columnCount; ++column) {
                Type type = readColumns.get(column);
                Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"checksum requires all columns to be read");
                types.add((Object)type);
            }
            return new WriteChecksumBuilder((List<Type>)types.build());
        }

        public void addStripe(int rowCount) {
            this.longSlice.setInt(0, rowCount);
            this.stripeHash.update(this.longBuffer, 0, 4);
        }

        public void addPage(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.columnHashes.size() ? 1 : 0) != 0, (Object)"invalid page");
            for (int channel = 0; channel < this.columnHashes.size(); ++channel) {
                Type type = this.types.get(channel);
                Block block = page.getBlock(channel);
                XxHash64 xxHash64 = this.columnHashes.get(channel);
                for (int position = 0; position < block.getPositionCount(); ++position) {
                    long hash = WriteChecksumBuilder.hashPositionSkipNullMapKeys(type, block, position);
                    this.longSlice.setLong(0, hash);
                    xxHash64.update(this.longBuffer);
                }
            }
            this.totalRowCount += (long)page.getPositionCount();
        }

        private static long hashPositionSkipNullMapKeys(Type type, Block block, int position) {
            if (block.isNull(position)) {
                return 7944063686788161739L;
            }
            if (type.getTypeSignature().getBase().equals("map")) {
                Type keyType = (Type)type.getTypeParameters().get(0);
                Type valueType = (Type)type.getTypeParameters().get(1);
                Block mapBlock = (Block)type.getObject(block, position);
                long hash = 0L;
                for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                    if (mapBlock.isNull(i)) continue;
                    hash += WriteChecksumBuilder.hashPositionSkipNullMapKeys(keyType, mapBlock, i);
                    hash += WriteChecksumBuilder.hashPositionSkipNullMapKeys(valueType, mapBlock, i + 1);
                }
                return hash;
            }
            if (type.getTypeSignature().getBase().equals("array")) {
                Type elementType = (Type)type.getTypeParameters().get(0);
                Block array = (Block)type.getObject(block, position);
                long hash = 0L;
                for (int i = 0; i < array.getPositionCount(); ++i) {
                    hash = 31L * hash + WriteChecksumBuilder.hashPositionSkipNullMapKeys(elementType, array, i);
                }
                return hash;
            }
            if (type.getTypeSignature().getBase().equals("row")) {
                Block row = (Block)type.getObject(block, position);
                long hash = 0L;
                for (int i = 0; i < row.getPositionCount(); ++i) {
                    Type elementType = (Type)type.getTypeParameters().get(i);
                    hash = 31L * hash + WriteChecksumBuilder.hashPositionSkipNullMapKeys(elementType, row, i);
                }
                return hash;
            }
            return type.hash(block, position);
        }

        public WriteChecksum build() {
            return new WriteChecksum(this.totalRowCount, this.stripeHash.hash(), (List)this.columnHashes.stream().map(XxHash64::hash).collect(ImmutableList.toImmutableList()));
        }
    }

    public static class WriteChecksum {
        private final long totalRowCount;
        private final long stripeHash;
        private final List<Long> columnHashes;

        public WriteChecksum(long totalRowCount, long stripeHash, List<Long> columnHashes) {
            this.totalRowCount = totalRowCount;
            this.stripeHash = stripeHash;
            this.columnHashes = columnHashes;
        }

        public long getTotalRowCount() {
            return this.totalRowCount;
        }

        public long getStripeHash() {
            return this.stripeHash;
        }

        public List<Long> getColumnHashes() {
            return this.columnHashes;
        }
    }
}

