/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.CachingOrcDataSource;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.ExceptionWrappingMetadataReader;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.joda.time.DateTimeZone;

public class OrcReader {
    public static final int MAX_BATCH_SIZE = 1024;
    private static final Logger log = Logger.get(OrcReader.class);
    private static final int CURRENT_MAJOR_VERSION = 0;
    private static final int CURRENT_MINOR_VERSION = 12;
    private static final int EXPECTED_FOOTER_SIZE = 16384;
    private final OrcDataSource orcDataSource;
    private final ExceptionWrappingMetadataReader metadataReader;
    private final DataSize maxMergeDistance;
    private final DataSize maxReadSize;
    private final DataSize maxBlockSize;
    private final PostScript.HiveWriterVersion hiveWriterVersion;
    private final int bufferSize;
    private final CompressionKind compressionKind;
    private final Optional<OrcDecompressor> decompressor;
    private final Footer footer;
    private final Metadata metadata;
    private final Optional<OrcWriteValidation> writeValidation;

    public OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, DataSize maxMergeDistance, DataSize maxReadSize, DataSize maxBlockSize) throws IOException {
        this(orcDataSource, orcEncoding, maxMergeDistance, maxReadSize, maxBlockSize, Optional.empty());
    }

    OrcReader(OrcDataSource orcDataSource, OrcEncoding orcEncoding, DataSize maxMergeDistance, DataSize maxReadSize, DataSize maxBlockSize, Optional<OrcWriteValidation> writeValidation) throws IOException {
        Slice completeFooterSlice;
        PostScript postScript;
        this.orcDataSource = orcDataSource = OrcReader.wrapWithCacheIfTiny(Objects.requireNonNull(orcDataSource, "orcDataSource is null"), maxMergeDistance);
        Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        this.metadataReader = new ExceptionWrappingMetadataReader(orcDataSource.getId(), orcEncoding.createMetadataReader());
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxReadSize = Objects.requireNonNull(maxReadSize, "maxReadSize is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.writeValidation = Objects.requireNonNull(writeValidation, "writeValidation is null");
        long size = orcDataSource.getSize();
        if (size <= (long)PostScript.MAGIC.length()) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Invalid file size %s", size);
        }
        byte[] buffer = new byte[Math.toIntExact(Math.min(size, 16384L))];
        orcDataSource.readFully(size - (long)buffer.length, buffer);
        int postScriptSize = buffer[buffer.length - 1] & 0xFF;
        if (postScriptSize >= buffer.length) {
            throw new OrcCorruptionException(orcDataSource.getId(), "Invalid postscript length %s", postScriptSize);
        }
        try {
            postScript = this.metadataReader.readPostScript(buffer, buffer.length - 1 - postScriptSize, postScriptSize);
        }
        catch (OrcCorruptionException e) {
            if (!OrcReader.isValidHeaderMagic(orcDataSource)) {
                throw new OrcCorruptionException(orcDataSource.getId(), "Not an ORC file");
            }
            throw e;
        }
        OrcReader.checkOrcVersion(orcDataSource, postScript.getVersion());
        this.validateWrite(validation -> validation.getVersion().equals(postScript.getVersion()), "Unexpected version", new Object[0]);
        this.bufferSize = Math.toIntExact(postScript.getCompressionBlockSize());
        this.compressionKind = postScript.getCompression();
        this.decompressor = OrcDecompressor.createOrcDecompressor(orcDataSource.getId(), this.compressionKind, this.bufferSize);
        this.validateWrite(validation -> validation.getCompression() == this.compressionKind, "Unexpected compression", new Object[0]);
        this.hiveWriterVersion = postScript.getHiveWriterVersion();
        int footerSize = Math.toIntExact(postScript.getFooterLength());
        int metadataSize = Math.toIntExact(postScript.getMetadataLength());
        int completeFooterSize = footerSize + metadataSize + postScriptSize + 1;
        if (completeFooterSize > buffer.length) {
            byte[] newBuffer = new byte[completeFooterSize];
            completeFooterSlice = Slices.wrappedBuffer((byte[])newBuffer);
            orcDataSource.readFully(size - (long)completeFooterSize, newBuffer, 0, completeFooterSize - buffer.length);
            completeFooterSlice.setBytes(completeFooterSize - buffer.length, buffer);
        } else {
            completeFooterSlice = Slices.wrappedBuffer((byte[])buffer, (int)(buffer.length - completeFooterSize), (int)completeFooterSize);
        }
        Slice metadataSlice = completeFooterSlice.slice(0, metadataSize);
        try (OrcInputStream metadataInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)metadataSlice.getInput(), this.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());){
            this.metadata = this.metadataReader.readMetadata(this.hiveWriterVersion, metadataInputStream);
        }
        Slice footerSlice = completeFooterSlice.slice(metadataSize, footerSize);
        try (OrcInputStream footerInputStream = new OrcInputStream(orcDataSource.getId(), (FixedLengthSliceInput)footerSlice.getInput(), this.decompressor, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());){
            this.footer = this.metadataReader.readFooter(this.hiveWriterVersion, footerInputStream);
        }
        this.validateWrite(validation -> validation.getColumnNames().equals(this.getColumnNames()), "Unexpected column names", new Object[0]);
        this.validateWrite(validation -> validation.getRowGroupMaxRowCount() == this.footer.getRowsInRowGroup(), "Unexpected rows in group", new Object[0]);
        if (writeValidation.isPresent()) {
            writeValidation.get().validateMetadata(orcDataSource.getId(), this.footer.getUserMetadata());
            writeValidation.get().validateFileStatistics(orcDataSource.getId(), this.footer.getFileStats());
            writeValidation.get().validateStripeStatistics(orcDataSource.getId(), this.footer.getStripes(), this.metadata.getStripeStatsList());
        }
    }

    public List<String> getColumnNames() {
        return this.footer.getTypes().get(0).getFieldNames();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OrcRecordReader createRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage) {
        return this.createRecordReader(includedColumns, predicate, 0L, this.orcDataSource.getSize(), hiveStorageTimeZone, systemMemoryUsage);
    }

    public OrcRecordReader createRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, AggregatedMemoryContext systemMemoryUsage) {
        return new OrcRecordReader(Objects.requireNonNull(includedColumns, "includedColumns is null"), Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.decompressor, this.footer.getRowsInRowGroup(), Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null"), this.hiveWriterVersion, this.metadataReader, this.maxMergeDistance, this.maxReadSize, this.maxBlockSize, this.footer.getUserMetadata(), systemMemoryUsage, this.writeValidation);
    }

    private static OrcDataSource wrapWithCacheIfTiny(OrcDataSource dataSource, DataSize maxCacheSize) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        if (dataSource.getSize() > maxCacheSize.toBytes()) {
            return dataSource;
        }
        DiskRange diskRange = new DiskRange(0L, Math.toIntExact(dataSource.getSize()));
        return new CachingOrcDataSource(dataSource, desiredOffset -> diskRange);
    }

    private static boolean isValidHeaderMagic(OrcDataSource source) throws IOException {
        byte[] headerMagic = new byte[PostScript.MAGIC.length()];
        source.readFully(0L, headerMagic);
        return PostScript.MAGIC.equals((Object)Slices.wrappedBuffer((byte[])headerMagic));
    }

    private static void checkOrcVersion(OrcDataSource orcDataSource, List<Integer> version) {
        if (version.size() >= 1) {
            int major = version.get(0);
            int minor = 0;
            if (version.size() > 1) {
                minor = version.get(1);
            }
            if (major > 0 || major == 0 && minor > 12) {
                log.warn("ORC file %s was written by a newer Hive version %s. This file may not be readable by this version of Hive (%s.%s).", new Object[]{orcDataSource, Joiner.on((char)'.').join(version), 0, 12});
            }
        }
    }

    private void validateWrite(Predicate<OrcWriteValidation> test, String messageFormat, Object ... args) throws OrcCorruptionException {
        if (this.writeValidation.isPresent() && !test.test(this.writeValidation.get())) {
            throw new OrcCorruptionException(this.orcDataSource.getId(), "Write validation failed: " + messageFormat, args);
        }
    }

    static void validateFile(OrcWriteValidation writeValidation, OrcDataSource input, List<Type> types, DateTimeZone hiveStorageTimeZone, OrcEncoding orcEncoding) throws OrcCorruptionException {
        ImmutableMap.Builder readTypes = ImmutableMap.builder();
        for (int columnIndex = 0; columnIndex < types.size(); ++columnIndex) {
            readTypes.put((Object)columnIndex, (Object)types.get(columnIndex));
        }
        try {
            OrcReader orcReader = new OrcReader(input, orcEncoding, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE), Optional.of(writeValidation));
            try (OrcRecordReader orcRecordReader = orcReader.createRecordReader((Map<Integer, Type>)readTypes.build(), OrcPredicate.TRUE, hiveStorageTimeZone, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());){
                while (orcRecordReader.nextBatch() >= 0) {
                }
            }
        }
        catch (IOException e) {
            throw new OrcCorruptionException(e, input.getId(), "Validation failed", new Object[0]);
        }
    }
}

