/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.LazySliceInput;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDataSourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.ChunkedSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class AbstractOrcDataSource
implements OrcDataSource {
    private final OrcDataSourceId id;
    private final long size;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final DataSize streamBufferSize;
    private final boolean lazyReadSmallRanges;
    private long readTimeNanos;
    private long readBytes;

    public AbstractOrcDataSource(OrcDataSourceId id, long size, DataSize maxMergeDistance, DataSize maxBufferSize, DataSize streamBufferSize, boolean lazyReadSmallRanges) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.size = size;
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"size must be at least 1");
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.streamBufferSize = Objects.requireNonNull(streamBufferSize, "streamBufferSize is null");
        this.lazyReadSmallRanges = lazyReadSmallRanges;
    }

    protected abstract void readInternal(long var1, byte[] var3, int var4, int var5) throws IOException;

    @Override
    public OrcDataSourceId getId() {
        return this.id;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public final void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)bufferLength;
    }

    @Override
    public final <K> Map<K, FixedLengthSliceInput> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        Objects.requireNonNull(diskRanges, "diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        long maxReadSizeBytes = this.maxBufferSize.toBytes();
        ImmutableMap.Builder smallRangesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder largeRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            if ((long)entry.getValue().getLength() <= maxReadSizeBytes) {
                smallRangesBuilder.put(entry);
                continue;
            }
            largeRangesBuilder.put(entry);
        }
        ImmutableMap smallRanges = smallRangesBuilder.build();
        ImmutableMap largeRanges = largeRangesBuilder.build();
        ImmutableMap.Builder slices = ImmutableMap.builder();
        slices.putAll(this.readSmallDiskRanges((Map<K, DiskRange>)smallRanges));
        slices.putAll(this.readLargeDiskRanges((Map<K, DiskRange>)largeRanges));
        return slices.build();
    }

    private <K> Map<K, FixedLengthSliceInput> readSmallDiskRanges(Map<K, DiskRange> diskRanges) throws IOException {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        List<DiskRange> mergedRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(diskRanges.values(), this.maxMergeDistance, this.maxBufferSize);
        ImmutableMap.Builder slices = ImmutableMap.builder();
        if (this.lazyReadSmallRanges) {
            for (DiskRange mergedRange : mergedRanges) {
                LazyBufferLoader lazyBufferLoader = new LazyBufferLoader(mergedRange);
                for (Map.Entry<K, DiskRange> diskRangeEntry : diskRanges.entrySet()) {
                    DiskRange diskRange = diskRangeEntry.getValue();
                    if (!mergedRange.contains(diskRange)) continue;
                    slices.put(diskRangeEntry.getKey(), (Object)new LazySliceInput(diskRange.getLength(), new LazyMergedSliceLoader(diskRange, lazyBufferLoader)));
                }
            }
        } else {
            LinkedHashMap<DiskRange, byte[]> buffers = new LinkedHashMap<DiskRange, byte[]>();
            for (DiskRange diskRange : mergedRanges) {
                byte[] buffer = new byte[diskRange.getLength()];
                this.readFully(diskRange.getOffset(), buffer);
                buffers.put(diskRange, buffer);
            }
            for (Map.Entry entry : diskRanges.entrySet()) {
                slices.put(entry.getKey(), (Object)OrcDataSourceUtils.getDiskRangeSlice((DiskRange)entry.getValue(), buffers).getInput());
            }
        }
        ImmutableMap sliceStreams = slices.build();
        Verify.verify((boolean)sliceStreams.keySet().equals(diskRanges.keySet()));
        return sliceStreams;
    }

    private <K> Map<K, FixedLengthSliceInput> readLargeDiskRanges(Map<K, DiskRange> diskRanges) {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            slices.put(entry.getKey(), (Object)new LazySliceInput(diskRange.getLength(), new LazyChunkedSliceLoader(diskRange, Math.toIntExact(this.streamBufferSize.toBytes()))));
        }
        return slices.build();
    }

    public final String toString() {
        return this.id.toString();
    }

    private final class LazyChunkedSliceLoader
    implements Supplier<FixedLengthSliceInput> {
        private final DiskRange diskRange;
        private final int bufferSize;

        public LazyChunkedSliceLoader(DiskRange diskRange, int bufferSize) {
            this.diskRange = Objects.requireNonNull(diskRange, "diskRange is null");
            Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"bufferSize must be greater than 0");
            this.bufferSize = bufferSize;
        }

        @Override
        public FixedLengthSliceInput get() {
            return new ChunkedSliceInput((ChunkedSliceInput.SliceLoader)new ChunkedSliceLoader(this.diskRange), this.bufferSize);
        }
    }

    private static class SliceBufferReference
    implements ChunkedSliceInput.BufferReference {
        private final byte[] buffer;
        private final Slice slice;

        public SliceBufferReference(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.slice = Slices.wrappedBuffer((byte[])this.buffer);
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public Slice getSlice() {
            return this.slice;
        }
    }

    private class ChunkedSliceLoader
    implements ChunkedSliceInput.SliceLoader<SliceBufferReference> {
        private final DiskRange diskRange;

        public ChunkedSliceLoader(DiskRange diskRange) {
            this.diskRange = diskRange;
        }

        public SliceBufferReference createBuffer(int bufferSize) {
            return new SliceBufferReference(bufferSize);
        }

        public long getSize() {
            return this.diskRange.getLength();
        }

        public void load(long position, SliceBufferReference bufferReference, int length) {
            try {
                AbstractOrcDataSource.this.readFully(this.diskRange.getOffset() + position, bufferReference.getBuffer(), 0, length);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
        }
    }

    private final class LazyMergedSliceLoader
    implements Supplier<FixedLengthSliceInput> {
        private final DiskRange diskRange;
        private final LazyBufferLoader lazyBufferLoader;

        public LazyMergedSliceLoader(DiskRange diskRange, LazyBufferLoader lazyBufferLoader) {
            this.diskRange = Objects.requireNonNull(diskRange, "diskRange is null");
            this.lazyBufferLoader = Objects.requireNonNull(lazyBufferLoader, "lazyBufferLoader is null");
        }

        @Override
        public FixedLengthSliceInput get() {
            Slice buffer = this.lazyBufferLoader.loadNestedDiskRangeBuffer(this.diskRange);
            return new BasicSliceInput(buffer);
        }
    }

    private final class LazyBufferLoader {
        private final DiskRange diskRange;
        private Slice bufferSlice;

        public LazyBufferLoader(DiskRange diskRange) {
            this.diskRange = Objects.requireNonNull(diskRange, "diskRange is null");
        }

        public Slice loadNestedDiskRangeBuffer(DiskRange nestedDiskRange) {
            this.load();
            Preconditions.checkArgument((boolean)this.diskRange.contains(nestedDiskRange));
            int offset = Math.toIntExact(nestedDiskRange.getOffset() - this.diskRange.getOffset());
            return this.bufferSlice.slice(offset, nestedDiskRange.getLength());
        }

        private void load() {
            if (this.bufferSlice != null) {
                return;
            }
            try {
                byte[] buffer = new byte[this.diskRange.getLength()];
                AbstractOrcDataSource.this.readFully(this.diskRange.getOffset(), buffer);
                this.bufferSlice = Slices.wrappedBuffer((byte[])buffer);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

