/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DictionaryBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DictionaryBuilder.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private static final int NULL_POSITION = 0;
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private final IntBigArray blockPositionByHash = new IntBigArray();
    private BlockBuilder elementBlock;
    private int maxFill;
    private int hashMask;
    private boolean containsNullElement;

    public DictionaryBuilder(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        BlockBuilderStatus blockBuilderStatus = new BlockBuilderStatus();
        int expectedEntries = Math.min(expectedSize, blockBuilderStatus.getMaxBlockSizeInBytes() / 32);
        this.elementBlock = new VariableWidthBlockBuilder(blockBuilderStatus, expectedEntries, expectedEntries * 32);
        this.elementBlock.appendNull();
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = DictionaryBuilder.calculateMaxFill(hashSize);
        this.hashMask = hashSize - 1;
        this.blockPositionByHash.ensureCapacity((long)hashSize);
        this.blockPositionByHash.fill(-1);
        this.containsNullElement = false;
    }

    public long getSizeInBytes() {
        return this.elementBlock.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.elementBlock.getRetainedSizeInBytes() + this.blockPositionByHash.sizeOf();
    }

    public Block getElementBlock() {
        return this.elementBlock;
    }

    public void clear() {
        this.containsNullElement = false;
        this.blockPositionByHash.fill(-1);
        this.elementBlock = this.elementBlock.newBlockBuilderLike(new BlockBuilderStatus());
        this.elementBlock.appendNull();
    }

    public boolean contains(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            return this.containsNullElement;
        }
        return this.blockPositionByHash.get(this.getHashPositionOfElement(block, position)) != -1;
    }

    public int putIfAbsent(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        if (block.isNull(position)) {
            this.containsNullElement = true;
            return 0;
        }
        long hashPosition = this.getHashPositionOfElement(block, position);
        if (this.blockPositionByHash.get(hashPosition) != -1) {
            return this.blockPositionByHash.get(hashPosition);
        }
        return this.addNewElement(hashPosition, block, position);
    }

    public int getEntryCount() {
        return this.elementBlock.getPositionCount();
    }

    private long getHashPositionOfElement(Block block, int position) {
        int length = block.getSliceLength(position);
        long hashPosition = this.getMaskedHash(block.hash(position, 0, length));
        int blockPosition;
        while ((blockPosition = this.blockPositionByHash.get(hashPosition)) != -1) {
            if (this.elementBlock.getSliceLength(blockPosition) == length && block.equals(position, 0, (Block)this.elementBlock, blockPosition, 0, length)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private int addNewElement(long hashPosition, Block block, int position) {
        if (block.isNull(position)) {
            throw new IllegalArgumentException("position is null");
        }
        block.writeBytesTo(position, 0, block.getSliceLength(position), this.elementBlock);
        this.elementBlock.closeEntry();
        int newElementPositionInBlock = this.elementBlock.getPositionCount() - 1;
        this.blockPositionByHash.set(hashPosition, newElementPositionInBlock);
        if (this.elementBlock.getPositionCount() >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return newElementPositionInBlock;
    }

    private void rehash(int size) {
        int newHashSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        this.hashMask = newHashSize - 1;
        this.maxFill = DictionaryBuilder.calculateMaxFill(newHashSize);
        this.blockPositionByHash.ensureCapacity((long)newHashSize);
        this.blockPositionByHash.fill(-1);
        this.rehashBlock((Block)this.elementBlock);
    }

    private void rehashBlock(Block block) {
        for (int blockPosition = 0; blockPosition < block.getPositionCount(); ++blockPosition) {
            this.blockPositionByHash.set(this.getHashPositionOfElement(block, blockPosition), blockPosition);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        return maxFill;
    }

    private long getMaskedHash(long rawHash) {
        return rawHash & (long)this.hashMask;
    }
}

