/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.DecimalStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.LongDecode;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.facebook.presto.spi.type.Decimals;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DecimalOutputStream
implements ValueOutputStream<DecimalStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    private final List<DecimalStreamCheckpoint> checkpoints = new ArrayList<DecimalStreamCheckpoint>();
    private boolean closed;

    public DecimalOutputStream(CompressionKind compression, int bufferSize) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    public void writeUnscaledValue(Slice slice) {
        BigInteger value = Decimals.decodeUnscaledValue((Slice)slice);
        int sign = (value = value.shiftLeft(1)).signum();
        if (sign < 0) {
            value = value.negate();
            value = value.subtract(BigInteger.ONE);
        }
        int length = value.bitLength();
        while (true) {
            long lowBits = value.longValue() & Long.MAX_VALUE;
            length -= 63;
            for (int i = 0; i < 9; ++i) {
                if (length <= 0 && (lowBits & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer.write((byte)lowBits);
                    return;
                }
                this.buffer.write((byte)(0x80L | lowBits & 0x7FL));
                lowBits >>>= 7;
            }
            value = value.shiftRight(63);
        }
    }

    public void writeUnscaledValue(long value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        LongDecode.writeVLong(this.buffer, value, true);
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new DecimalStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public List<DecimalStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public Optional<Stream> writeDataStreams(int column, SliceOutput outputStream) {
        Preconditions.checkState((boolean)this.closed);
        int length = this.buffer.writeDataTo(outputStream);
        return Optional.of(new Stream(column, Stream.StreamKind.DATA, length, true));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.size();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

