/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LongDictionaryStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean[] nullVector = new boolean[0];
    @Nonnull
    private InputStreamSource<LongInputStream> dictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private int dictionarySize;
    @Nonnull
    private long[] dictionary = new long[0];
    @Nonnull
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream inDictionaryStream;
    private boolean[] inDictionary = new boolean[0];
    @Nonnull
    private InputStreamSource<LongInputStream> dataStreamSource;
    @Nullable
    private LongInputStream dataStream;
    private long[] dataVector = new long[0];
    private boolean dictionaryOpen;
    private boolean rowGroupOpen;

    public LongDictionaryStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.nullVector.length < this.nextBatchSize) {
            this.nullVector = new boolean[this.nextBatchSize];
        }
        if (this.dataVector.length < this.nextBatchSize) {
            this.dataVector = new long[this.nextBatchSize];
        }
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            Arrays.fill(this.nullVector, false);
            this.dataStream.nextLongVector(this.nextBatchSize, this.dataVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.dataStream.nextLongVector(this.nextBatchSize, this.dataVector, this.nullVector);
            }
        }
        if (this.inDictionary.length < this.nextBatchSize) {
            this.inDictionary = new boolean[this.nextBatchSize];
        }
        if (this.inDictionaryStream == null) {
            Arrays.fill(this.inDictionary, true);
        } else {
            this.inDictionaryStream.getSetBits(this.nextBatchSize, this.inDictionary, this.nullVector);
        }
        BlockBuilder builder = type.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (this.nullVector[i]) {
                builder.appendNull();
                continue;
            }
            if (this.inDictionary[i]) {
                type.writeLong(builder, this.dictionary[(int)this.dataVector[i]]);
                continue;
            }
            type.writeLong(builder, this.dataVector[i]);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return builder.build();
    }

    private void openRowGroup() throws IOException {
        if (!this.dictionaryOpen && this.dictionarySize > 0) {
            LongInputStream dictionaryStream;
            if (this.dictionary.length < this.dictionarySize) {
                this.dictionary = new long[this.dictionarySize];
            }
            if ((dictionaryStream = this.dictionaryDataStreamSource.openStream()) == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but data stream is not present");
            }
            dictionaryStream.nextLongVector(this.dictionarySize, this.dictionary);
        }
        this.dictionaryOpen = true;
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.dictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, LongInputStream.class);
        this.dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.dictionaryOpen = false;
        this.inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

