/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.writer.BooleanColumnWriter;
import com.facebook.presto.orc.writer.ByteColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DecimalColumnWriter;
import com.facebook.presto.orc.writer.DoubleColumnWriter;
import com.facebook.presto.orc.writer.FloatColumnWriter;
import com.facebook.presto.orc.writer.ListColumnWriter;
import com.facebook.presto.orc.writer.LongColumnWriter;
import com.facebook.presto.orc.writer.MapColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.facebook.presto.orc.writer.StructColumnWriter;
import com.facebook.presto.orc.writer.TimestampColumnWriter;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public final class ColumnWriters {
    private ColumnWriters() {
    }

    public static ColumnWriter createColumnWriter(int columnIndex, List<OrcType> orcTypes, Type type, CompressionKind compression, int bufferSize, boolean isDwrf, DateTimeZone hiveStorageTimeZone) {
        Objects.requireNonNull(type, "type is null");
        OrcType orcType = orcTypes.get(columnIndex);
        switch (orcType.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanColumnWriter(columnIndex, type, compression, bufferSize);
            }
            case FLOAT: {
                return new FloatColumnWriter(columnIndex, type, compression, bufferSize);
            }
            case DOUBLE: {
                return new DoubleColumnWriter(columnIndex, type, compression, bufferSize);
            }
            case BYTE: {
                return new ByteColumnWriter(columnIndex, type, compression, bufferSize);
            }
            case DATE: {
                Preconditions.checkArgument((!isDwrf ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
                return new LongColumnWriter(columnIndex, type, compression, bufferSize, false, DateStatisticsBuilder::new);
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongColumnWriter(columnIndex, type, compression, bufferSize, isDwrf, IntegerStatisticsBuilder::new);
            }
            case DECIMAL: {
                Preconditions.checkArgument((!isDwrf ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
                return new DecimalColumnWriter(columnIndex, type, compression, bufferSize, false);
            }
            case TIMESTAMP: {
                return new TimestampColumnWriter(columnIndex, type, compression, bufferSize, isDwrf, hiveStorageTimeZone);
            }
            case BINARY: {
                return new SliceDirectColumnWriter(columnIndex, type, compression, bufferSize, isDwrf, BinaryStatisticsBuilder::new);
            }
            case CHAR: {
                Preconditions.checkArgument((!isDwrf ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
            }
            case VARCHAR: 
            case STRING: {
                return new SliceDictionaryColumnWriter(columnIndex, type, compression, bufferSize, isDwrf);
            }
            case LIST: {
                int fieldColumnIndex = orcType.getFieldTypeIndex(0);
                Type fieldType = (Type)type.getTypeParameters().get(0);
                ColumnWriter elementWriter = ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compression, bufferSize, isDwrf, hiveStorageTimeZone);
                return new ListColumnWriter(columnIndex, compression, bufferSize, isDwrf, elementWriter);
            }
            case MAP: {
                ColumnWriter keyWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(0), orcTypes, (Type)type.getTypeParameters().get(0), compression, bufferSize, isDwrf, hiveStorageTimeZone);
                ColumnWriter valueWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(1), orcTypes, (Type)type.getTypeParameters().get(1), compression, bufferSize, isDwrf, hiveStorageTimeZone);
                return new MapColumnWriter(columnIndex, compression, bufferSize, isDwrf, keyWriter, valueWriter);
            }
            case STRUCT: {
                ImmutableList.Builder fieldWriters = ImmutableList.builder();
                for (int fieldId = 0; fieldId < orcType.getFieldCount(); ++fieldId) {
                    int fieldColumnIndex = orcType.getFieldTypeIndex(fieldId);
                    Type fieldType = (Type)type.getTypeParameters().get(fieldId);
                    fieldWriters.add((Object)ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compression, bufferSize, isDwrf, hiveStorageTimeZone));
                }
                return new StructColumnWriter(columnIndex, compression, bufferSize, (List<ColumnWriter>)fieldWriters.build());
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }
}

