/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.DecimalStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ShortDecimalStatisticsBuilder;
import com.facebook.presto.orc.stream.DecimalOutputStream;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DecimalColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalColumnWriter.class).instanceSize();
    private final int column;
    private final DecimalType type;
    private final ColumnEncoding columnEncoding;
    private final boolean compressed;
    private final DecimalOutputStream dataStream;
    private final LongOutputStream scaleStream;
    private final PresentOutputStream presentStream;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private ShortDecimalStatisticsBuilder shortDecimalStatisticsBuilder;
    private LongDecimalStatisticsBuilder longDecimalStatisticsBuilder;
    private boolean closed;

    public DecimalColumnWriter(int column, Type type, CompressionKind compression, int bufferSize, boolean isDwrf) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Preconditions.checkArgument((!isDwrf ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
        this.column = column;
        this.type = (DecimalType)Objects.requireNonNull(type, "type is null");
        this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
        this.dataStream = new DecimalOutputStream(compression, bufferSize);
        this.scaleStream = new LongOutputStreamV2(compression, bufferSize, true, Stream.StreamKind.SECONDARY);
        this.presentStream = new PresentOutputStream(compression, bufferSize);
        if (this.type.isShort()) {
            this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        } else {
            this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        }
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
        this.scaleStream.recordCheckpoint();
    }

    @Override
    public void writeBlock(Block block) {
        int position;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        if (this.type.isShort()) {
            for (position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                long value = this.type.getLong(block, position);
                this.dataStream.writeUnscaledValue(value);
                this.shortDecimalStatisticsBuilder.addValue(value);
            }
        } else {
            for (position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                Slice value = this.type.getSlice(block, position);
                this.dataStream.writeUnscaledValue(value);
                this.longDecimalStatisticsBuilder.addValue(new BigDecimal(Decimals.decodeUnscaledValue((Slice)value), this.type.getScale()));
            }
        }
        for (position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            this.scaleStream.writeLong(this.type.getScale());
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        ColumnStatistics statistics;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.type.isShort()) {
            statistics = this.shortDecimalStatisticsBuilder.buildColumnStatistics();
            this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        } else {
            statistics = this.longDecimalStatisticsBuilder.buildColumnStatistics();
            this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        }
        this.rowGroupColumnStatistics.add(statistics);
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.dataStream.close();
        this.scaleStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<Stream> writeIndexStreams(SliceOutput outputStream, MetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List<DecimalStreamCheckpoint> dataCheckpoints = this.dataStream.getCheckpoints();
        List scaleCheckpoints = this.scaleStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            DecimalStreamCheckpoint dataCheckpoint = dataCheckpoints.get(groupId);
            LongStreamCheckpoint scaleCheckpoint = (LongStreamCheckpoint)scaleCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = DecimalColumnWriter.createDecimalColumnPositionList(this.compressed, dataCheckpoint, scaleCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        int length = metadataWriter.writeRowIndexes(outputStream, (List<RowGroupIndex>)rowGroupIndexes.build());
        return ImmutableList.of((Object)new Stream(this.column, Stream.StreamKind.ROW_INDEX, length, false));
    }

    private static List<Integer> createDecimalColumnPositionList(boolean compressed, DecimalStreamCheckpoint dataCheckpoint, LongStreamCheckpoint scaleCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        positionList.addAll(scaleCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<Stream> writeDataStreams(SliceOutput outputStream) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder dataStreams = ImmutableList.builder();
        this.presentStream.writeDataStreams(this.column, outputStream).ifPresent(arg_0 -> ((ImmutableList.Builder)dataStreams).add(arg_0));
        this.dataStream.writeDataStreams(this.column, outputStream).ifPresent(arg_0 -> ((ImmutableList.Builder)dataStreams).add(arg_0));
        this.scaleStream.writeDataStreams(this.column, outputStream).ifPresent(arg_0 -> ((ImmutableList.Builder)dataStreams).add(arg_0));
        return dataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.dataStream.getBufferedBytes() + this.scaleStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.dataStream.getRetainedBytes() + this.scaleStream.getRetainedBytes() + this.presentStream.getRetainedBytes();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.dataStream.reset();
        this.scaleStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
    }
}

