/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanOutputStream;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class PresentOutputStream {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PresentOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    @Nullable
    private BooleanOutputStream booleanOutputStream;
    private final List<Integer> groupsCounts = new ArrayList<Integer>();
    private int currentGroupCount;
    private boolean closed;

    public PresentOutputStream(CompressionKind compression, int bufferSize) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
    }

    public void writeBoolean(boolean value) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        if (!value && this.booleanOutputStream == null) {
            this.createBooleanOutputStream();
        }
        if (this.booleanOutputStream != null) {
            this.booleanOutputStream.writeBoolean(value);
        }
        ++this.currentGroupCount;
    }

    private void createBooleanOutputStream() {
        Preconditions.checkState((this.booleanOutputStream == null ? 1 : 0) != 0);
        this.booleanOutputStream = new BooleanOutputStream(this.buffer);
        for (int groupsCount : this.groupsCounts) {
            this.booleanOutputStream.writeBooleans(groupsCount, true);
            this.booleanOutputStream.recordCheckpoint();
        }
        this.booleanOutputStream.writeBooleans(this.currentGroupCount, true);
    }

    public void recordCheckpoint() {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        this.groupsCounts.add(this.currentGroupCount);
        this.currentGroupCount = 0;
        if (this.booleanOutputStream != null) {
            this.booleanOutputStream.recordCheckpoint();
        }
    }

    public void close() {
        this.closed = true;
        if (this.booleanOutputStream != null) {
            this.booleanOutputStream.close();
        }
    }

    public Optional<List<BooleanStreamCheckpoint>> getCheckpoints() {
        Preconditions.checkArgument((boolean)this.closed);
        if (this.booleanOutputStream == null) {
            return Optional.empty();
        }
        return Optional.of(this.booleanOutputStream.getCheckpoints());
    }

    public Optional<Stream> writeDataStreams(int column, SliceOutput outputStream) {
        Preconditions.checkArgument((boolean)this.closed);
        if (this.booleanOutputStream == null) {
            return Optional.empty();
        }
        Stream stream = this.booleanOutputStream.writeDataStreams(column, outputStream).get();
        return Optional.of(new Stream(stream.getColumn(), Stream.StreamKind.PRESENT, stream.getLength(), stream.isUseVInts()));
    }

    public long getBufferedBytes() {
        if (this.booleanOutputStream == null) {
            return 0L;
        }
        return this.booleanOutputStream.getBufferedBytes();
    }

    public long getRetainedBytes() {
        if (this.booleanOutputStream == null) {
            return INSTANCE_SIZE + this.buffer.getRetainedSize();
        }
        return (long)INSTANCE_SIZE + this.booleanOutputStream.getRetainedBytes();
    }

    public void reset() {
        this.closed = false;
        this.booleanOutputStream = null;
        this.buffer.reset();
        this.groupsCounts.clear();
        this.currentGroupCount = 0;
    }
}

